/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.statistics.provider;

import com.google.common.collect.ImmutableSet;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.statistics.provider.SimpleIntProvider;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class SimpleIntProviderFactory {
    private static final SimpleIntProvider.SimpleIntProviderImplementation edgeCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "edgeCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + 1;
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation gotoCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "gotoCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            if (edge.getEdgeType() == CFAEdgeType.BlankEdge && edge.getDescription().startsWith("Goto: ")) {
                return pCurrent + 1;
            }
            return pCurrent;
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation functionCallCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "functionCallCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countFunctionCalls(edge);
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation branchCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "branchCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            if (edge.getSuccessor().getNumLeavingEdges() > 1) {
                return pCurrent + 1;
            }
            return pCurrent;
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation jumpCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "jumpCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            if (edge.getPredecessor().getNodeNumber() + 1 != edge.getSuccessor().getNodeNumber()) {
                return pCurrent + 1;
            }
            return pCurrent;
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation functionDefCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "functionDefCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge pEdge) {
            return pCurrent + SimpleIntProviderFactory.countDeclarations(pEdge, new Counter<CDeclaration>(){

                @Override
                public int count(CDeclaration pE) {
                    if (pE instanceof CFunctionDeclaration) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation localVariablesCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "localVariablesCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countDeclarations(edge, new Counter<CDeclaration>(){

                @Override
                public int count(CDeclaration declaration) {
                    if (declaration instanceof CVariableDeclaration && !declaration.isGlobal()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation globalVariablesCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "globalVariablesCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countDeclarations(edge, new Counter<CDeclaration>(){

                @Override
                public int count(CDeclaration declaration) {
                    if (declaration instanceof CVariableDeclaration && declaration.isGlobal()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation structVariablesCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "structVariablesCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countDeclarations(edge, new Counter<CDeclaration>(){

                @Override
                public int count(CDeclaration declaration) {
                    if (declaration instanceof CVariableDeclaration && declaration.getType().getCanonicalType() instanceof CCompositeType) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation pointerVariablesCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "pointerVariablesCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countDeclarations(edge, new Counter<CDeclaration>(){

                @Override
                public int count(CDeclaration declaration) {
                    if (declaration instanceof CVariableDeclaration && declaration.getType().getCanonicalType() instanceof CPointerType) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation arrayVariablesCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "arrayVariablesCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countDeclarations(edge, new Counter<CDeclaration>(){

                @Override
                public int count(CDeclaration declaration) {
                    if (declaration instanceof CVariableDeclaration && declaration.getType().getCanonicalType() instanceof CArrayType) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation integerVariablesCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "integerVariablesCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countDeclarations(edge, new Counter<CDeclaration>(){

                @Override
                public int count(CDeclaration declaration) {
                    CSimpleType simple;
                    CType canonical;
                    if (declaration instanceof CVariableDeclaration && (canonical = declaration.getType().getCanonicalType()) instanceof CSimpleType && ((simple = (CSimpleType)canonical).getType() == CBasicType.INT || simple.getType() == CBasicType.CHAR)) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation floatVariablesCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "floatVariablesCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countDeclarations(edge, new Counter<CDeclaration>(){

                @Override
                public int count(CDeclaration declaration) {
                    CSimpleType simple;
                    CType canonical;
                    if (declaration instanceof CVariableDeclaration && (canonical = declaration.getType().getCanonicalType()) instanceof CSimpleType && ((simple = (CSimpleType)canonical).getType() == CBasicType.FLOAT || simple.getType() == CBasicType.DOUBLE)) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation bitwiseOperationCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "bitwiseOperationCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countExpressions(edge, new Counter<CExpression>(){

                @Override
                public int count(CExpression pExpression) {
                    CBinaryExpression binexp;
                    if (pExpression instanceof CBinaryExpression && SimpleIntProviderFactory.isBitwiseOperation(binexp = (CBinaryExpression)pExpression)) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation dereferenceCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "dereferenceCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countExpressions(edge, new Counter<CExpression>(){

                @Override
                public int count(CExpression pExpression) {
                    if (pExpression instanceof CPointerExpression) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation assumeCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "assumeCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countAssumeStmts(edge);
        }
    };
    private static final SimpleIntProvider.SimpleIntProviderImplementation arithmeticOperationCountProvider = new SimpleIntProvider.SimpleIntProviderImplementation(){

        @Override
        public String getPropertyName() {
            return "arithmeticOperationCount";
        }

        @Override
        public int calculateNext(int pCurrent, CFAEdge edge) {
            return pCurrent + SimpleIntProviderFactory.countExpressions(edge, new Counter<CExpression>(){

                @Override
                public int count(CExpression pExpression) {
                    CBinaryExpression binexp;
                    if (pExpression instanceof CBinaryExpression && SimpleIntProviderFactory.isArithmeticOperation(binexp = (CBinaryExpression)pExpression)) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };

    private static int countExpressions(CAstNode pExpression, Counter<CExpression> counter) {
        return CFAUtils.traverseRecursively(pExpression).filter(CExpression.class).stream().mapToInt(counter::count).sum();
    }

    private static int countDeclarations(CFAEdge pEdge, Counter<CDeclaration> counter) {
        int count = 0;
        switch (pEdge.getEdgeType()) {
            case DeclarationEdge: {
                CDeclarationEdge declEdge = (CDeclarationEdge)pEdge;
                CDeclaration decl = declEdge.getDeclaration();
                count += counter.count(decl);
                break;
            }
        }
        return count;
    }

    private static int countExpressions(CFAEdge pEdge, Counter<CExpression> counter) {
        int count = 0;
        switch (pEdge.getEdgeType()) {
            case DeclarationEdge: {
                CVariableDeclaration varDecl;
                CInitializer init;
                CDeclarationEdge declEdge = (CDeclarationEdge)pEdge;
                CDeclaration decl = declEdge.getDeclaration();
                if (!(decl instanceof CVariableDeclaration) || (init = (varDecl = (CVariableDeclaration)decl).getInitializer()) == null) break;
                count += SimpleIntProviderFactory.countExpressions(init, counter);
                break;
            }
            case AssumeEdge: {
                CAssumeEdge assumeEdge = (CAssumeEdge)pEdge;
                count += SimpleIntProviderFactory.countExpressions(assumeEdge.getExpression(), counter);
                break;
            }
            case FunctionCallEdge: {
                CFunctionCallEdge fcallEdge = (CFunctionCallEdge)pEdge;
                for (CExpression arg : fcallEdge.getArguments()) {
                    count += SimpleIntProviderFactory.countExpressions(arg, counter);
                }
                break;
            }
            case StatementEdge: {
                CStatementEdge stmtEdge = (CStatementEdge)pEdge;
                CStatement stmt = stmtEdge.getStatement();
                count += SimpleIntProviderFactory.countExpressions(stmt, counter);
                break;
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge returnEdge = (CReturnStatementEdge)pEdge;
                if (!returnEdge.getExpression().isPresent()) break;
                count += SimpleIntProviderFactory.countExpressions(returnEdge.getExpression().orElseThrow(), counter);
                break;
            }
        }
        return count;
    }

    public static SimpleIntProvider getEdgeCountProvider(MergeOption option) {
        return new SimpleIntProvider(edgeCountProvider, option, 0);
    }

    public static SimpleIntProvider getGotoCountProvider(MergeOption option) {
        return new SimpleIntProvider(gotoCountProvider, option, 0);
    }

    public static SimpleIntProvider getLoopCountProvider(CFA cfa, MergeOption option) {
        final ImmutableSet<CFANode> loopHeads = cfa.getAllLoopHeads().orElseThrow();
        return new SimpleIntProvider(new SimpleIntProvider.SimpleIntProviderImplementation(){

            @Override
            public String getPropertyName() {
                return "loopCount";
            }

            @Override
            public int calculateNext(int pCurrent, CFAEdge edge) {
                CFANode pred = edge.getPredecessor();
                CFANode succ = edge.getSuccessor();
                if (loopHeads.contains((Object)succ) && succ.getNodeNumber() > pred.getNodeNumber()) {
                    return pCurrent + 1;
                }
                return pCurrent;
            }
        }, option, 0);
    }

    private static int countFunctionCalls(CFAEdge pEdge) {
        int count = 0;
        switch (pEdge.getEdgeType()) {
            case FunctionCallEdge: {
                ++count;
                break;
            }
            case StatementEdge: {
                CStatementEdge stmtEdge = (CStatementEdge)pEdge;
                CStatement stmt = stmtEdge.getStatement();
                if (!(stmt instanceof CFunctionCall)) break;
                ++count;
                break;
            }
        }
        return count;
    }

    public static SimpleIntProvider getFunctionCallCountProvider(MergeOption option) {
        return new SimpleIntProvider(functionCallCountProvider, option, 0);
    }

    public static SimpleIntProvider getBranchCountProvider(MergeOption option) {
        return new SimpleIntProvider(branchCountProvider, option, 0);
    }

    public static SimpleIntProvider getJumpCountProvider(MergeOption option) {
        return new SimpleIntProvider(jumpCountProvider, option, 0);
    }

    public static SimpleIntProvider getFunctionDefCountProvider(MergeOption option) {
        return new SimpleIntProvider(functionDefCountProvider, option, 0);
    }

    public static SimpleIntProvider getLocalVariablesCountProvider(MergeOption option) {
        return new SimpleIntProvider(localVariablesCountProvider, option, 0);
    }

    public static SimpleIntProvider getGlobalVariablesCountProvider(MergeOption option) {
        return new SimpleIntProvider(globalVariablesCountProvider, option, 0);
    }

    public static SimpleIntProvider getStructVariablesCountProvider(MergeOption option) {
        return new SimpleIntProvider(structVariablesCountProvider, option, 0);
    }

    public static SimpleIntProvider getPointerVariablesCountProvider(MergeOption option) {
        return new SimpleIntProvider(pointerVariablesCountProvider, option, 0);
    }

    public static SimpleIntProvider getArrayVariablesCountProvider(MergeOption option) {
        return new SimpleIntProvider(arrayVariablesCountProvider, option, 0);
    }

    public static SimpleIntProvider getIntegerVariablesCountProvider(MergeOption option) {
        return new SimpleIntProvider(integerVariablesCountProvider, option, 0);
    }

    public static SimpleIntProvider getFloatVariablesCountProvider(MergeOption option) {
        return new SimpleIntProvider(floatVariablesCountProvider, option, 0);
    }

    private static boolean isBitwiseOperation(CBinaryExpression exp) {
        switch (exp.getOperator()) {
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: {
                return true;
            }
        }
        return false;
    }

    public static SimpleIntProvider getBitwiseOperationCountProvider(MergeOption option) {
        return new SimpleIntProvider(bitwiseOperationCountProvider, option, 0);
    }

    public static SimpleIntProvider getDereferenceCountProvider(MergeOption option) {
        return new SimpleIntProvider(dereferenceCountProvider, option, 0);
    }

    private static int countAssumeStmts(CFAEdge pEdge) {
        int count = 0;
        switch (pEdge.getEdgeType()) {
            case AssumeEdge: {
                ++count;
                break;
            }
        }
        return count;
    }

    public static SimpleIntProvider getAssumeCountProvider(MergeOption option) {
        return new SimpleIntProvider(assumeCountProvider, option, 0);
    }

    private static boolean isArithmeticOperation(CBinaryExpression exp) {
        switch (exp.getOperator()) {
            case DIVIDE: 
            case MINUS: 
            case MODULO: 
            case MULTIPLY: 
            case PLUS: {
                return true;
            }
        }
        return false;
    }

    public static SimpleIntProvider getArithmeticOperationCountProvider(MergeOption option) {
        return new SimpleIntProvider(arithmeticOperationCountProvider, option, 0);
    }

    public static enum MergeOption implements SimpleIntProvider.IntMerger
    {
        Min{

            @Override
            public int merge(int s1, int s2) {
                return Math.min(s1, s2);
            }

            @Override
            public String toString() {
                return "min";
            }
        }
        ,
        Max{

            @Override
            public int merge(int s1, int s2) {
                return Math.max(s1, s2);
            }

            @Override
            public String toString() {
                return "max";
            }
        }
        ,
        Add{

            @Override
            public int merge(int s1, int s2) {
                return s1 + s2;
            }

            @Override
            public String toString() {
                return "add";
            }
        };

    }

    public static interface Counter<T> {
        public int count(T var1);
    }
}

