/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.targetreachability;

import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.targetreachability.ReachabilityState;
import org.sosy_lab.cpachecker.cpa.targetreachability.TargetReachabilityTransferRelation;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProviderImpl;

@Options(prefix="cpa.property_reachability")
public class TargetReachabilityCPA
extends AbstractCPA
implements StatisticsProvider,
Statistics {
    @Option(secure=true, description="Do not follow states which can not syntactically lead to a target location")
    private boolean noFollowBackwardsUnreachable = true;
    private final Timer backwardsReachability = new Timer();
    private final ImmutableSet<CFANode> targetReachableFrom;

    private TargetReachabilityCPA(Configuration pConfig, ShutdownNotifier shutdownNotifier, LogManager pLogger, CFA pCfa, Specification pSpecification) throws InvalidConfigurationException {
        super("join", "sep", new FlatLatticeDomain(ReachabilityState.RELEVANT_TO_TARGET), null);
        pConfig.inject((Object)this);
        this.targetReachableFrom = this.getReachableNodes(shutdownNotifier, pLogger, pCfa, pSpecification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableSet<CFANode> getReachableNodes(ShutdownNotifier shutdownNotifier, LogManager pLogger, CFA pCfa, Specification pSpecification) {
        TargetLocationProviderImpl targetProvider = new TargetLocationProviderImpl(shutdownNotifier, pLogger, pCfa);
        if (this.noFollowBackwardsUnreachable) {
            this.backwardsReachability.start();
            ImmutableSet.Builder builder = ImmutableSet.builder();
            try {
                ImmutableSet<CFANode> targetNodes = targetProvider.tryGetAutomatonTargetLocations(pCfa.getMainFunction(), pSpecification);
                for (CFANode target : targetNodes) {
                    builder.addAll(CFATraversal.dfs().backwards().collectNodesReachableFrom(target));
                }
            }
            finally {
                this.backwardsReachability.stop();
            }
            return builder.build();
        }
        return ImmutableSet.copyOf(pCfa.getAllNodes());
    }

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(TargetReachabilityCPA.class);
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new TargetReachabilityTransferRelation(this.targetReachableFrom);
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) {
        return ReachabilityState.RELEVANT_TO_TARGET;
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this);
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        out.println("Time spent in pre-calculating backwards-reachable nodes: " + this.backwardsReachability.prettyFormat());
    }

    @Override
    public @Nullable String getName() {
        return "Property Reachability Statistics";
    }
}

