/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.termination;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.termination.TerminationARGPath;
import org.sosy_lab.cpachecker.cpa.termination.TerminationCPA;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CPAs;

public class TerminationARGBasedRefiner
extends AbstractARGBasedRefiner {
    private final TerminationCPA terminationCPA;

    public static TerminationARGBasedRefiner create(ConfigurableProgramAnalysis pCpa, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        TerminationCPA terminationCPA = CPAs.retrieveCPAOrFail(pCpa, TerminationCPA.class, TerminationCPA.class);
        Refiner.Factory refinerFactory = new TerminationARGBasedRefinerConfig((Configuration)terminationCPA.getConfig()).refinerFactory;
        Refiner refiner = refinerFactory.create(pCpa, pLogger, pShutdownNotifier);
        if (refiner instanceof AbstractARGBasedRefiner) {
            return new TerminationARGBasedRefiner((AbstractARGBasedRefiner)refiner, terminationCPA);
        }
        throw new InvalidConfigurationException(TerminationARGBasedRefiner.class.getSimpleName() + " requires ARGBasedRefiner.");
    }

    private TerminationARGBasedRefiner(AbstractARGBasedRefiner pWrappedRefine, TerminationCPA pTerminationCPA) {
        super(pWrappedRefine);
        this.terminationCPA = (TerminationCPA)Preconditions.checkNotNull((Object)pTerminationCPA);
    }

    @Override
    protected ARGPath computePath(ARGState pLastElement, ARGReachedSet pReached) throws InterruptedException, CPATransferException {
        ARGPath basicPath = ARGUtils.getOnePathTo(pLastElement);
        return new TerminationARGPath(basicPath, this.terminationCPA.getTerminationInformation());
    }

    @Options(prefix="cpa.termination")
    private static class TerminationARGBasedRefinerConfig {
        @Option(secure=true, name="refiner", required=true, description="Which refinement algorithm to use? (give class name, required for termination algorithm with CEGAR) If the package name starts with 'org.sosy_lab.cpachecker.', this prefix can be omitted.")
        @ClassOption(packagePrefix={"org.sosy_lab.cpachecker"})
        @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
        private Refiner.Factory refinerFactory;

        public TerminationARGBasedRefinerConfig(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }
    }
}

