/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.termination;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.termination.TerminationLoopInformation;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.termination.TerminationState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class TerminationARGPath
extends ARGPath {
    private final TerminationLoopInformation terminationInformation;
    private @Nullable List<CFAEdge> terminationFullPath = null;

    public TerminationARGPath(ARGPath pBasicArgPath, TerminationLoopInformation pTerminationInformation) {
        super(pBasicArgPath);
        this.terminationInformation = (TerminationLoopInformation)Preconditions.checkNotNull((Object)pTerminationInformation);
    }

    @Override
    public List<CFAEdge> getFullPath() {
        if (this.terminationFullPath != null) {
            return this.terminationFullPath;
        }
        ImmutableList.Builder fullPathBuilder = ImmutableList.builder();
        PathIterator it = this.pathIterator();
        HashSet<CFAEdge> intermediateTermiantionEdges = new HashSet<CFAEdge>();
        while (it.hasNext()) {
            CFANode curNode;
            ARGState prev = it.getAbstractState();
            CFAEdge curOutgoingEdge = it.getOutgoingEdge();
            it.advance();
            ARGState succ = it.getAbstractState();
            TerminationState terminationPrev = AbstractStates.extractStateByType(prev, TerminationState.class);
            TerminationState terminationSucc = AbstractStates.extractStateByType(succ, TerminationState.class);
            if (terminationPrev.isPartOfStem() && terminationSucc.isPartOfLoop()) {
                curNode = AbstractStates.extractLocation(prev);
                List<CFAEdge> stemToLoopTransition = this.terminationInformation.createStemToLoopTransition(curNode, curNode);
                intermediateTermiantionEdges.addAll(stemToLoopTransition);
                fullPathBuilder.addAll(stemToLoopTransition);
            }
            if (curOutgoingEdge == null) {
                curNode = AbstractStates.extractLocation(prev);
                CFANode nextNode = AbstractStates.extractLocation(succ);
                if (AbstractStates.isTargetState(succ)) {
                    CFAEdge negatedRankingRelationAssumeEdge = this.terminationInformation.createRankingRelationAssumeEdge(curNode, nextNode, false);
                    intermediateTermiantionEdges.add(negatedRankingRelationAssumeEdge);
                    fullPathBuilder.add((Object)negatedRankingRelationAssumeEdge);
                    nextNode = curNode;
                }
                while (!Objects.equals(curNode, nextNode)) {
                    FluentIterable leavingEdges = CFAUtils.leavingEdges(curNode).filter(Predicates.not((Predicate)Predicates.in(intermediateTermiantionEdges)));
                    if (leavingEdges.size() != 1 || curNode.getLeavingSummaryEdge() != null) {
                        return ImmutableList.of();
                    }
                    CFAEdge intermediateEdge = (CFAEdge)leavingEdges.get(0);
                    fullPathBuilder.add((Object)intermediateEdge);
                    curNode = intermediateEdge.getSuccessor();
                }
                continue;
            }
            fullPathBuilder.add((Object)curOutgoingEdge);
        }
        this.terminationFullPath = fullPathBuilder.build();
        this.terminationInformation.resetCfa();
        return this.terminationFullPath;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (!(pOther instanceof TerminationARGPath)) {
            return false;
        }
        return super.equals(pOther);
    }
}

