/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.termination;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.termination.TerminationLoopInformation;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.termination.TerminationAbstractDomain;
import org.sosy_lab.cpachecker.cpa.termination.TerminationMergeOperator;
import org.sosy_lab.cpachecker.cpa.termination.TerminationPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.termination.TerminationState;
import org.sosy_lab.cpachecker.cpa.termination.TerminationStopOperator;
import org.sosy_lab.cpachecker.cpa.termination.TerminationTransferRelation;

public class TerminationCPA
extends AbstractSingleWrapperCPA {
    private final TerminationLoopInformation terminationInformation;
    private final Configuration config;
    private final AbstractDomain abstractDomain;
    private final TerminationTransferRelation transferRelation;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final PrecisionAdjustment precisionAdjustment;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(TerminationCPA.class);
    }

    public TerminationCPA(ConfigurableProgramAnalysis pCpa, CFA pCfa, Configuration pConfig, LogManager pLogger) {
        super(pCpa);
        this.config = (Configuration)Preconditions.checkNotNull((Object)pConfig);
        this.terminationInformation = new TerminationLoopInformation(pCfa.getMachineModel(), pLogger);
        this.transferRelation = new TerminationTransferRelation(pCpa.getTransferRelation(), this.terminationInformation, pLogger);
        this.abstractDomain = new TerminationAbstractDomain(pCpa.getAbstractDomain());
        this.stopOperator = new TerminationStopOperator(pCpa.getStopOperator(), this.terminationInformation);
        this.mergeOperator = new TerminationMergeOperator(pCpa.getMergeOperator());
        this.precisionAdjustment = new TerminationPrecisionAdjustment(pCpa.getPrecisionAdjustment());
    }

    public Configuration getConfig() {
        return this.config;
    }

    public TerminationLoopInformation getTerminationInformation() {
        return this.terminationInformation;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return TerminationState.createStemState(this.getWrappedCpa().getInitialState(pNode, pPartition));
    }
}

