/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.termination;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankingRelation;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithDummyLocation;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Immutable
public class TerminationState
extends AbstractSingleWrapperState
implements AbstractStateWithDummyLocation,
FormulaReportingState,
Graphable {
    private final @Nullable CFANode hondaLocation;
    private final boolean dummyLocation;
    private final Collection<CFAEdge> enteringEdges;
    private final @Nullable Set<Targetable.TargetInformation> targetInformation;
    private final @Nullable RankingRelation unsatisfiedRankingRelation;

    private TerminationState(AbstractState pWrappedState, @Nullable CFANode pHondaLocation, boolean pDummyLocation, Collection<CFAEdge> pEnteringEdges, @Nullable Set<Targetable.TargetInformation> pTargetInformation, @Nullable RankingRelation pUnsatisfiedRankingRelation) {
        super((AbstractState)Preconditions.checkNotNull((Object)pWrappedState));
        Preconditions.checkArgument((pDummyLocation || pEnteringEdges.isEmpty() ? 1 : 0) != 0);
        this.hondaLocation = pHondaLocation;
        this.dummyLocation = pDummyLocation;
        this.enteringEdges = (Collection)Preconditions.checkNotNull(pEnteringEdges);
        this.targetInformation = pTargetInformation;
        this.unsatisfiedRankingRelation = pUnsatisfiedRankingRelation;
    }

    private TerminationState(AbstractState pWrappedState, @Nullable CFANode pHondaLocation, boolean pDummyLocation, Collection<CFAEdge> pEnteringEdges) {
        this(pWrappedState, pHondaLocation, pDummyLocation, pEnteringEdges, null, null);
    }

    public static TerminationState createStemState(AbstractState pWrappedState) {
        return new TerminationState(pWrappedState, null, false, (Collection<CFAEdge>)ImmutableList.of());
    }

    public TerminationState withWrappedState(AbstractState pWrappedState) {
        return new TerminationState(pWrappedState, this.hondaLocation, this.dummyLocation, this.enteringEdges);
    }

    public TerminationState enterLoop(CFANode pHondaLocation) {
        Preconditions.checkArgument((boolean)this.isPartOfStem(), (String)"%s is entered the lasso's loop at %s", (Object)this, (Object)this.hondaLocation);
        return new TerminationState(this.getWrappedState(), pHondaLocation, this.dummyLocation, this.enteringEdges);
    }

    public TerminationState withDummyLocation(Collection<CFAEdge> pEnteringEdges) {
        return new TerminationState(this.getWrappedState(), this.hondaLocation, true, pEnteringEdges);
    }

    public TerminationState withTargetInformation(Set<Targetable.TargetInformation> pTargetInformation) {
        Preconditions.checkNotNull(pTargetInformation);
        Preconditions.checkArgument((!pTargetInformation.isEmpty() ? 1 : 0) != 0);
        return new TerminationState(this.getWrappedState(), this.hondaLocation, this.dummyLocation, this.enteringEdges, pTargetInformation, null);
    }

    public TerminationState withUnsatisfiedRankingRelation(RankingRelation pUnsatisfiedRankingRelation) {
        Preconditions.checkNotNull((Object)pUnsatisfiedRankingRelation);
        return new TerminationState(this.getWrappedState(), this.hondaLocation, this.dummyLocation, this.enteringEdges, this.targetInformation, pUnsatisfiedRankingRelation);
    }

    @Override
    public boolean isDummyLocation() {
        return this.dummyLocation;
    }

    @Override
    public Collection<CFAEdge> getEnteringEdges() {
        return this.enteringEdges;
    }

    public boolean isPartOfLoop() {
        return this.hondaLocation != null;
    }

    public boolean isPartOfStem() {
        return this.hondaLocation == null;
    }

    public CFANode getHondaLocation() {
        return this.hondaLocation;
    }

    @Override
    public BooleanFormula getFormulaApproximation(FormulaManagerView pManager) {
        if (this.unsatisfiedRankingRelation == null) {
            return pManager.getBooleanFormulaManager().makeTrue();
        }
        return pManager.makeNot(this.unsatisfiedRankingRelation.asFormulaFromOtherSolver(pManager));
    }

    @Override
    public boolean isTarget() {
        return this.targetInformation != null || super.isTarget();
    }

    @Override
    public Set<Targetable.TargetInformation> getTargetInformation() throws IllegalStateException {
        if (this.targetInformation != null) {
            return this.targetInformation;
        }
        return super.getTargetInformation();
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.isPartOfStem()) {
            sb.append("stem");
        } else {
            sb.append("loop");
        }
        if (this.getWrappedState() instanceof Graphable) {
            sb.append("\n");
            sb.append(((Graphable)((Object)this.getWrappedState())).toDOTLabel());
        }
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        if (this.getWrappedState() instanceof Graphable) {
            return ((Graphable)((Object)this.getWrappedState())).shouldBeHighlighted();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TerminationState.class.getSimpleName());
        if (this.isPartOfStem()) {
            sb.append("(stem)");
        } else {
            sb.append("(loop)");
        }
        sb.append(" ");
        sb.append(this.getWrappedState());
        return sb.toString();
    }
}

