/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.termination;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.algorithm.termination.TerminationLoopInformation;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.termination.TerminationState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class TerminationStopOperator
implements StopOperator {
    private final StopOperator stopOperator;
    private final TerminationLoopInformation terminationInformation;

    public TerminationStopOperator(StopOperator pStopOperator, TerminationLoopInformation pTerminationInformation) {
        this.stopOperator = (StopOperator)Preconditions.checkNotNull((Object)pStopOperator);
        this.terminationInformation = pTerminationInformation;
    }

    @Override
    public boolean stop(AbstractState pState, Collection<AbstractState> pReached, Precision pPrecision) throws CPAException, InterruptedException {
        TerminationState terminationState = (TerminationState)pState;
        AbstractState wrappedState = terminationState.getWrappedState();
        Collection wrappedReached = pReached.stream().map(s -> (TerminationState)s).filter(s -> terminationState.isPartOfLoop() == s.isPartOfLoop()).map(AbstractSingleWrapperState::getWrappedState).collect(Collectors.toCollection(ArrayList::new));
        CFANode locNode = AbstractStates.extractLocation(wrappedState);
        if (terminationState.isPartOfLoop() && terminationState.getHondaLocation() instanceof FunctionEntryNode || locNode instanceof FunctionEntryNode && this.terminationInformation.isLoopHead(locNode)) {
            return this.checkCoverageInRecursion(wrappedState, terminationState, wrappedReached, pPrecision);
        }
        return this.stopOperator.stop(wrappedState, wrappedReached, pPrecision);
    }

    public boolean checkCoverageInRecursion(AbstractState pWrappedState, TerminationState pTerminationState, Collection<AbstractState> pWrappedReached, Precision pPrecision) throws CPAException, InterruptedException {
        Preconditions.checkArgument((boolean)(pWrappedState instanceof CompositeState), (Object)"Recursion detection assumes that TerminationCPA wraps CompositeCPA");
        ArrayList<AbstractState> elements = new ArrayList<AbstractState>((Collection<AbstractState>)((CompositeState)pWrappedState).getWrappedStates());
        int index = -1;
        CallstackState callState = null;
        for (int i = 0; i < elements.size(); ++i) {
            if (!(elements.get(i) instanceof CallstackState)) continue;
            callState = (CallstackState)elements.get(i);
            index = i;
            break;
        }
        if (index >= 0) {
            String functionName = pTerminationState.isPartOfLoop() ? pTerminationState.getHondaLocation().getFunctionName() : AbstractStates.extractLocation(pWrappedState).getFunctionName();
            while (callState != null) {
                elements.set(index, callState);
                CompositeState newWrappedState = new CompositeState(elements);
                if (this.stopOperator.stop(newWrappedState, pWrappedReached, pPrecision)) {
                    return true;
                }
                while ((callState = callState.getPreviousState()) != null && !callState.getCurrentFunction().equals(functionName)) {
                }
            }
            return false;
        }
        return this.stopOperator.stop(pWrappedState, pWrappedReached, pPrecision);
    }
}

