/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.termination;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.core.algorithm.termination.TerminationLoopInformation;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankingRelation;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.termination.TerminationState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class TerminationTransferRelation
extends AbstractSingleWrapperTransferRelation {
    private static final String TMP_VARIABLE_NAME = "__CPAchecker_termination_temp";
    private static final CFunctionDeclaration NONDET_INT = new CFunctionDeclaration(FileLocation.DUMMY, CFunctionType.functionTypeWithReturnType(CNumericTypes.INT), "__VERIFIER_nondet_int", (List<CParameterDeclaration>)ImmutableList.of(), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
    private Set<CFAEdge> createdCfaEdges = new LinkedHashSet<CFAEdge>();
    private final TerminationLoopInformation terminationInformation;
    private final LogManager logger;

    public TerminationTransferRelation(TransferRelation pTransferRelation, TerminationLoopInformation terminationInformation, LogManager pLogger) {
        super(pTransferRelation);
        this.terminationInformation = (TerminationLoopInformation)Preconditions.checkNotNull((Object)terminationInformation);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
    }

    public Collection<? extends TerminationState> getAbstractSuccessors(AbstractState pState, Precision pPrecision) throws CPATransferException, InterruptedException {
        ImmutableList targetStatesAtCurrentLocation;
        Collection<TerminationState> statesAtCurrentLocation;
        CFANode location = AbstractStates.extractLocation(pState);
        TerminationState terminationState = (TerminationState)pState;
        if (location == null) {
            throw new UnsupportedOperationException("TransferRelation requires location information.");
        }
        if (terminationState.isPartOfStem() && this.terminationInformation.isPredecessorOfIncomingEdge(location)) {
            statesAtCurrentLocation = this.declarePrimedVariables(terminationState, pPrecision, location);
            targetStatesAtCurrentLocation = ImmutableList.of();
        } else if (this.terminationInformation.isLoopHead(location)) {
            statesAtCurrentLocation = this.insertRankingRelation(terminationState, pPrecision, location);
            targetStatesAtCurrentLocation = FluentIterable.from(statesAtCurrentLocation).filter(AbstractStates::isTargetState).toList();
            statesAtCurrentLocation.removeAll((Collection<?>)targetStatesAtCurrentLocation);
        } else {
            statesAtCurrentLocation = Collections.singleton(terminationState);
            targetStatesAtCurrentLocation = ImmutableList.of();
        }
        this.resetCfa();
        assert (!statesAtCurrentLocation.isEmpty() || !targetStatesAtCurrentLocation.isEmpty()) : pState + " has no successors.";
        ArrayList<TerminationState> resultingSuccessors = new ArrayList<TerminationState>(statesAtCurrentLocation.size());
        resultingSuccessors.addAll(this.getAbstractSuccessors0(statesAtCurrentLocation, pPrecision));
        for (TerminationState targetState : targetStatesAtCurrentLocation) {
            Collection<? extends AbstractState> strengthenedStates = this.transferRelation.strengthen(targetState.getWrappedState(), Collections.singletonList(targetState), null, pPrecision);
            strengthenedStates.stream().map(targetState::withWrappedState).forEach(resultingSuccessors::add);
        }
        return resultingSuccessors;
    }

    private Collection<TerminationState> declarePrimedVariables(TerminationState pState, Precision pPrecision, CFANode pCfaNode) throws CPATransferException, InterruptedException {
        Collection<TerminationState> states = Collections.singletonList(pState);
        for (CFAEdge edge : this.terminationInformation.createPrimedVariableDeclarations(pCfaNode)) {
            states = this.getAbstractSuccessorsForEdge0(states, pPrecision, edge);
        }
        return states;
    }

    private Collection<TerminationState> insertRankingRelation(TerminationState loopHeadState, Precision pPrecision, CFANode loopHead) throws CPATransferException, InterruptedException {
        ArrayList<TerminationState> resultingSuccessors = new ArrayList<TerminationState>(4);
        AFunctionDeclaration functionName = loopHead.getFunction();
        this.logger.logf(Level.FINEST, "Adding ranking relations %s after location %s in function %s.", new Object[]{this.terminationInformation.getRankingRelationAsCExpression(), loopHead, functionName});
        CFANode potentialNonTerminationNode = this.createCfaNode(functionName);
        CFAEdge negativeRankingRelation = this.terminationInformation.createRankingRelationAssumeEdge(loopHead, potentialNonTerminationNode, false);
        Collection<TerminationState> potentialNonTerminationStates = this.getAbstractSuccessorsForEdge0(Collections.singleton(loopHeadState), pPrecision, negativeRankingRelation);
        if (loopHeadState.isPartOfLoop() && loopHeadState.getHondaLocation().equals(loopHead)) {
            CFAEdge nonTerminationLabel = this.terminationInformation.createEdgeToNonTerminationLabel(potentialNonTerminationNode);
            Collection<TerminationState> targetStates = this.getAbstractSuccessorsForEdge0(potentialNonTerminationStates, pPrecision, nonTerminationLabel);
            CFAEdge edgeToTargetState = this.terminationInformation.createNegatedRankingRelationAssumeEdgeToTargetNode(loopHead);
            Optional<RankingRelation> rankingRelation = this.terminationInformation.getRankingRelation();
            FluentIterable.from(targetStates).transform(ts -> ts.withDummyLocation(Collections.singleton(edgeToTargetState))).transform(ts -> rankingRelation.map(ts::withUnsatisfiedRankingRelation).orElse((TerminationState)ts)).copyInto(resultingSuccessors);
        }
        CFANode node1 = this.createCfaNode(functionName);
        ArrayList<TerminationState> statesAtNode1 = new ArrayList<TerminationState>(2);
        BlankEdge blankEdge = this.createBlankEdge(potentialNonTerminationNode, node1, "");
        statesAtNode1.addAll(this.getAbstractSuccessorsForEdge0(potentialNonTerminationStates, pPrecision, blankEdge));
        CFAEdge positiveRankingRelation = this.terminationInformation.createRankingRelationAssumeEdge(loopHead, node1, true);
        statesAtNode1.addAll(this.getAbstractSuccessorsForEdge0(Collections.singleton(loopHeadState), pPrecision, positiveRankingRelation));
        CFANode node2 = this.createCfaNode(functionName);
        CDeclarationEdge nondetEdge = this.createTmpVarDeclaration(node1, node2);
        Collection<TerminationState> statesAtNode2 = this.getAbstractSuccessorsForEdge0(statesAtNode1, pPrecision, nondetEdge);
        CFANode node3 = this.createCfaNode(functionName);
        CFunctionCallAssignmentStatement nondetAssignment = new CFunctionCallAssignmentStatement(FileLocation.DUMMY, new CIdExpression(FileLocation.DUMMY, nondetEdge.getDeclaration()), new CFunctionCallExpression(FileLocation.DUMMY, CNumericTypes.INT, new CIdExpression(FileLocation.DUMMY, NONDET_INT), (List<CExpression>)ImmutableList.of(), NONDET_INT));
        CStatementEdge nondetAssignmentEdge = this.crateCStatementEdge(nondetAssignment, node2, node3);
        Collection<TerminationState> statesAtNode3 = this.getAbstractSuccessorsForEdge0(statesAtNode2, pPrecision, nondetAssignmentEdge);
        CFANode node4 = this.createCfaNode(functionName);
        CIdExpression nondetTmpVariable = new CIdExpression(FileLocation.DUMMY, nondetEdge.getDeclaration());
        CBinaryExpression nondetTmpVariableAssumption = new CBinaryExpression(FileLocation.DUMMY, CNumericTypes.INT, CNumericTypes.INT, nondetTmpVariable, CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.EQUALS);
        CAssumeEdge negativeNondetAssumeEdge = this.createAssumeEdge(nondetTmpVariableAssumption, node3, node4, false);
        Collection nonLoopStatesAtNode3 = statesAtNode3.stream().filter(TerminationState::isPartOfStem).collect(Collectors.toCollection(ArrayList::new));
        Collection<TerminationState> statesAtNode4 = this.getAbstractSuccessorsForEdge0(nonLoopStatesAtNode3, pPrecision, negativeNondetAssumeEdge);
        ArrayList<TerminationState> statesAtNode5 = new ArrayList<TerminationState>();
        CFANode node5 = this.createCfaNode(functionName);
        this.initializePrimedVariables(node4, node5, statesAtNode4, pPrecision).stream().map(s -> s.enterLoop(loopHead)).forEach(statesAtNode5::add);
        CAssumeEdge positiveNodetAssumeEdge = this.createAssumeEdge(nondetTmpVariableAssumption, node3, node5, true);
        statesAtNode5.addAll(this.getAbstractSuccessorsForEdge0(statesAtNode3, pPrecision, positiveNodetAssumeEdge));
        BlankEdge edgeBackToLoopHead = this.createBlankEdge(node5, loopHead, "");
        resultingSuccessors.addAll(this.getAbstractSuccessorsForEdge0(statesAtNode5, pPrecision, edgeBackToLoopHead));
        return resultingSuccessors;
    }

    private Collection<? extends TerminationState> initializePrimedVariables(CFANode startNode, CFANode endNode, Collection<? extends TerminationState> pStates, Precision pPrecision) throws CPATransferException, InterruptedException {
        Collection<? extends TerminationState> states = pStates;
        List<CFAEdge> stemToLoopTransition = this.terminationInformation.createStemToLoopTransition(startNode, endNode);
        for (CFAEdge assignment : stemToLoopTransition) {
            states = this.getAbstractSuccessorsForEdge0(states, pPrecision, assignment);
        }
        return states;
    }

    private Collection<TerminationState> getAbstractSuccessorsForEdge0(Collection<? extends TerminationState> pStates, Precision pPrecision, CFAEdge pEdge) throws CPATransferException, InterruptedException {
        ArrayList<TerminationState> successors = new ArrayList<TerminationState>(pStates.size());
        for (TerminationState terminationState : pStates) {
            if (!terminationState.isPartOfStem() && this.terminationInformation.isloopLeavingEdge(pEdge)) continue;
            AbstractState wrappedState = terminationState.getWrappedState();
            this.transferRelation.getAbstractSuccessorsForEdge(wrappedState, pPrecision, pEdge).stream().map(terminationState::withWrappedState).forEach(successors::add);
        }
        return successors;
    }

    private Collection<TerminationState> getAbstractSuccessors0(Collection<? extends TerminationState> pStates, Precision pPrecision) throws CPATransferException, InterruptedException {
        ArrayList<TerminationState> resultingSuccessors = new ArrayList<TerminationState>(pStates.size());
        for (TerminationState terminationState : pStates) {
            this.transferRelation.getAbstractSuccessors(terminationState.getWrappedState(), pPrecision).stream().map(terminationState::withWrappedState).filter(s -> s.isPartOfStem() || !this.terminationInformation.isloopLeavingLocation(AbstractStates.extractLocation(s))).forEach(resultingSuccessors::add);
        }
        return resultingSuccessors;
    }

    private CDeclarationEdge createTmpVarDeclaration(CFANode predecessor, CFANode successor) {
        AFunctionDeclaration function = predecessor.getFunction();
        CVariableDeclaration declaration = new CVariableDeclaration(FileLocation.DUMMY, false, CStorageClass.AUTO, CNumericTypes.INT, TMP_VARIABLE_NAME, TMP_VARIABLE_NAME, function + "::__CPAchecker_termination_temp", null);
        CDeclarationEdge edge = new CDeclarationEdge(declaration.toASTString(), FileLocation.DUMMY, predecessor, successor, declaration);
        this.addToCfa(edge);
        return edge;
    }

    private CFANode createCfaNode(AFunctionDeclaration functionName) {
        return new CFANode(functionName);
    }

    private BlankEdge createBlankEdge(CFANode pPredecessor, CFANode pSuccessor, String pDescription) {
        BlankEdge edge = new BlankEdge(pDescription + ";", FileLocation.DUMMY, pPredecessor, pSuccessor, pDescription);
        this.addToCfa(edge);
        return edge;
    }

    private CStatementEdge crateCStatementEdge(CStatement pStatement, CFANode pPredecessor, CFANode pSuccessor) {
        CStatementEdge edge = new CStatementEdge(pStatement.toASTString(), pStatement, FileLocation.DUMMY, pPredecessor, pSuccessor);
        this.addToCfa(edge);
        return edge;
    }

    private CAssumeEdge createAssumeEdge(CExpression condition, CFANode predecessor, CFANode successor, boolean postive) {
        CAssumeEdge edge = new CAssumeEdge(condition.toASTString(), FileLocation.DUMMY, predecessor, successor, condition, postive);
        this.addToCfa(edge);
        return edge;
    }

    private void addToCfa(CFAEdge edge) {
        CFACreationUtils.addEdgeUnconditionallyToCFA(edge);
        this.createdCfaEdges.add(edge);
    }

    private void resetCfa() {
        this.createdCfaEdges.forEach(CFACreationUtils::removeEdgeFromNodes);
        this.createdCfaEdges.clear();
        this.terminationInformation.resetCfa();
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) {
        throw new UnsupportedOperationException("TerminationCPA does not support returning successors for a single edge.");
    }
}

