/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.testtargets;

import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetMinimizerBasicEssential;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetMinimizerEssential;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetReductionSpanningSet;
import org.sosy_lab.cpachecker.util.CFAUtils;

public enum TestTargetAdaption {
    NONE{

        @Override
        public Set<CFAEdge> adaptTestTargets(Set<CFAEdge> pTargets, CFA pCfa) {
            return pTargets;
        }
    }
    ,
    COVERED_NEXT_EDGE{

        @Override
        public Set<CFAEdge> adaptTestTargets(Set<CFAEdge> pTargets, CFA pCfa) {
            HashSet<CFAEdge> newGoals = new HashSet<CFAEdge>(pTargets);
            for (CFAEdge target : pTargets) {
                if (target.getSuccessor().getNumEnteringEdges() != 1) continue;
                boolean allSuccessorsGoals = true;
                for (CFAEdge leaving : CFAUtils.leavingEdges(target.getSuccessor())) {
                    if (pTargets.contains(leaving)) continue;
                    allSuccessorsGoals = false;
                    break;
                }
                if (!allSuccessorsGoals) continue;
                newGoals.remove(target);
            }
            return newGoals;
        }
    }
    ,
    BASIC_ESSENTIAL_EDGE{

        @Override
        public Set<CFAEdge> adaptTestTargets(Set<CFAEdge> pTargets, CFA pCfa) {
            return new TestTargetMinimizerBasicEssential().reduceTargets(pTargets);
        }
    }
    ,
    ESSENTIAL_EDGE_ORIGINAL{

        @Override
        public Set<CFAEdge> adaptTestTargets(Set<CFAEdge> pTargets, CFA pCfa) {
            return new TestTargetMinimizerEssential().reduceTargets(pTargets, pCfa, true);
        }
    }
    ,
    ESSENTIAL_EDGE{

        @Override
        public Set<CFAEdge> adaptTestTargets(Set<CFAEdge> pTargets, CFA pCfa) {
            return new TestTargetMinimizerEssential().reduceTargets(pTargets, pCfa, false);
        }
    }
    ,
    PORTFOLIO{

        @Override
        public Set<CFAEdge> adaptTestTargets(Set<CFAEdge> pTargets, CFA pCfa) {
            Set<CFAEdge> finalResult = COVERED_NEXT_EDGE.adaptTestTargets(pTargets, pCfa);
            Set<CFAEdge> returnResult = ESSENTIAL_EDGE_ORIGINAL.adaptTestTargets(pTargets, pCfa);
            finalResult = finalResult.size() > returnResult.size() ? returnResult : finalResult;
            returnResult = SPANNING_SET.adaptTestTargets(pTargets, pCfa);
            finalResult = finalResult.size() > returnResult.size() ? returnResult : finalResult;
            return finalResult;
        }
    }
    ,
    SPANNING_SET{

        @Override
        public Set<CFAEdge> adaptTestTargets(Set<CFAEdge> pTargets, CFA pCfa) {
            return new TestTargetReductionSpanningSet().reduceTargets(pTargets, pCfa);
        }
    }
    ,
    TESTCOMP{

        @Override
        public Set<CFAEdge> adaptTestTargets(Set<CFAEdge> targets, CFA pCfa) {
            HashSet<CFAEdge> newGoals;
            if (targets.size() < 1000) {
                newGoals = COVERED_NEXT_EDGE.adaptTestTargets(targets, pCfa);
            } else {
                newGoals = new HashSet();
                for (CFAEdge target : targets) {
                    if (target.getEdgeType() == CFAEdgeType.AssumeEdge) {
                        for (CFAEdge leaving : CFAUtils.leavingEdges(target.getSuccessor())) {
                            if (leaving.getEdgeType() == CFAEdgeType.AssumeEdge) continue;
                            newGoals.add(leaving);
                        }
                        continue;
                    }
                    newGoals.add(target);
                }
            }
            return newGoals;
        }
    };


    public abstract Set<CFAEdge> adaptTestTargets(Set<CFAEdge> var1, CFA var2);
}

