/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.testtargets;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetAdaption;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetProvider;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetState;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetTransferRelation;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetType;
import org.sosy_lab.cpachecker.util.CFAUtils;

@Options(prefix="testcase")
public class TestTargetCPA
extends AbstractCPA {
    private final TestTargetPrecisionAdjustment precisionAdjustment;
    private final TransferRelation transferRelation;
    @Option(secure=true, name="generate.parallel", description="set to true if run multiple test case generation instances in parallel")
    private boolean runParallel = false;
    @Option(secure=true, name="targets.type", description="Which CFA edges to use as test targets")
    private TestTargetType targetType = TestTargetType.ASSUME;
    @Option(secure=true, name="targets.funName", description="Name of target function if target type is FUN_CALL")
    private String targetFun = null;
    @Option(secure=true, name="targets.optimization.strategy", description="Which strategy to use to optimize set of test target edges")
    private TestTargetAdaption targetOptimization = TestTargetAdaption.NONE;
    @Option(secure=true, name="targets.edge", description="CFA edge if only a specific edge should be considered, e.g., in counterexample check")
    private String targetEdge = null;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(TestTargetCPA.class);
    }

    public TestTargetCPA(CFA pCfa, Configuration pConfig) throws InvalidConfigurationException {
        super("sep", "sep", DelegateAbstractDomain.getInstance(), null);
        pConfig.inject((Object)this);
        if (this.targetType == TestTargetType.FUN_CALL && this.targetFun == null) {
            throw new InvalidConfigurationException("If you choose target type to be FUN_CALL, you need to specify the target function.");
        }
        this.precisionAdjustment = new TestTargetPrecisionAdjustment();
        this.transferRelation = new TestTargetTransferRelation(this.targetEdge == null ? TestTargetProvider.getTestTargets(pCfa, this.runParallel, this.targetType, this.targetFun, this.targetOptimization) : this.findTargetEdge(pCfa));
    }

    private Set<CFAEdge> findTargetEdge(CFA pCfa) {
        Preconditions.checkNotNull((Object)this.targetEdge);
        List components = Splitter.on((char)'#').splitToList((CharSequence)this.targetEdge);
        if (components.size() > 1) {
            try {
                int predNum = Integer.parseInt((String)components.get(0));
                int edgeID = Integer.parseInt((String)components.get(1));
                Optional<CFANode> pred = pCfa.getAllNodes().stream().filter(node -> node.getNodeNumber() == predNum).findFirst();
                if (pred.isPresent()) {
                    for (CFAEdge edge : CFAUtils.allLeavingEdges(pred.orElseThrow())) {
                        if (System.identityHashCode(edge) != edgeID) continue;
                        return ImmutableSet.of((Object)edge);
                    }
                }
            }
            catch (NumberFormatException e) {
                return ImmutableSet.of();
            }
        }
        return ImmutableSet.of();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return TestTargetState.noTargetState();
    }

    @Override
    public TestTargetPrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }
}

