/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.testtargets;

import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class TestTargetMinimizerBasicEssential {
    public Set<CFAEdge> reduceTargets(Set<CFAEdge> testTargets) {
        HashSet<CFAEdge> targetsAfterRule1 = new HashSet<CFAEdge>(testTargets);
        block0: for (CFAEdge currentEdge : testTargets) {
            CFANode predecessor = currentEdge.getPredecessor();
            while (predecessor.getNumLeavingEdges() == 1 && predecessor.getNumEnteringEdges() == 1) {
                if (testTargets.contains(predecessor.getEnteringEdge(0))) {
                    targetsAfterRule1.remove(currentEdge);
                }
                predecessor = predecessor.getEnteringEdge(0).getPredecessor();
            }
            if (predecessor.getNumLeavingEdges() != 1) continue;
            for (CFAEdge enteringEdge : CFAUtils.enteringEdges(predecessor)) {
                if (!testTargets.contains(enteringEdge)) continue;
                targetsAfterRule1.remove(currentEdge);
                continue block0;
            }
        }
        HashSet<CFAEdge> finalTargets = new HashSet<CFAEdge>(targetsAfterRule1);
        block3: for (CFAEdge currentEdge : targetsAfterRule1) {
            CFANode successor = currentEdge.getSuccessor();
            while (successor.getNumLeavingEdges() == 1 && successor.getNumEnteringEdges() == 1) {
                if (testTargets.contains(successor.getLeavingEdge(0))) {
                    finalTargets.remove(currentEdge);
                }
                successor = successor.getLeavingEdge(0).getSuccessor();
            }
            if (successor.getNumEnteringEdges() != 1) continue;
            for (CFAEdge leavingEdge : CFAUtils.leavingEdges(successor)) {
                if (!testTargets.contains(leavingEdge)) continue;
                finalTargets.remove(currentEdge);
                continue block3;
            }
        }
        return finalTargets;
    }
}

