/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.testtargets;

import com.google.common.collect.FluentIterable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.DummyCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetReductionUtils;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.graph.dominance.DomTree;

public class TestTargetMinimizerEssential {
    public Set<CFAEdge> reduceTargets(Set<CFAEdge> testTargets, CFA pCfa, boolean fullCFACopy) {
        HashMap<CFAEdge, CFAEdge> copiedEdgeToTestTargetsMap = new HashMap<CFAEdge, CFAEdge>();
        Pair<CFANode, CFANode> copiedFunctionEntryExit = fullCFACopy ? this.copyCFA(testTargets, copiedEdgeToTestTargetsMap, pCfa.getMainFunction()) : TestTargetReductionUtils.buildTestGoalGraph(testTargets, copiedEdgeToTestTargetsMap, pCfa.getMainFunction());
        this.applyRule1(testTargets, copiedEdgeToTestTargetsMap, copiedFunctionEntryExit);
        this.applyRule2(testTargets, copiedEdgeToTestTargetsMap, copiedFunctionEntryExit);
        this.applyRule3(testTargets, copiedEdgeToTestTargetsMap, copiedFunctionEntryExit);
        this.applyRule4(testTargets, copiedEdgeToTestTargetsMap, copiedFunctionEntryExit.getFirst());
        return testTargets;
    }

    private Pair<CFANode, CFANode> copyCFA(Set<CFAEdge> pTestTargets, Map<CFAEdge, CFAEdge> copiedEdgeToTestTargetsMap, FunctionEntryNode pEntryNode) {
        HashSet<CFANode> origNodesCopied = new HashSet<CFANode>();
        HashMap<CFANode, CFANode> origCFANodeToCopyMap = new HashMap<CFANode, CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        origCFANodeToCopyMap.put(pEntryNode, CFANode.newDummyCFANode());
        waitlist.add(pEntryNode);
        origNodesCopied.add(pEntryNode);
        while (!waitlist.isEmpty()) {
            CFANode currentNode = (CFANode)waitlist.poll();
            for (CFAEdge currentEdge : CFAUtils.leavingEdges(currentNode)) {
                CFANode copiedSuccessorNode;
                if (origNodesCopied.contains(currentEdge.getSuccessor())) {
                    copiedSuccessorNode = (CFANode)origCFANodeToCopyMap.get(currentEdge.getSuccessor());
                } else {
                    copiedSuccessorNode = CFANode.newDummyCFANode("");
                    origCFANodeToCopyMap.put(currentEdge.getSuccessor(), copiedSuccessorNode);
                    waitlist.add(currentEdge.getSuccessor());
                    origNodesCopied.add(currentEdge.getSuccessor());
                }
                DummyCFAEdge copyEdge = new DummyCFAEdge((CFANode)origCFANodeToCopyMap.get(currentNode), copiedSuccessorNode);
                ((CFANode)origCFANodeToCopyMap.get(currentNode)).addLeavingEdge(copyEdge);
                copiedSuccessorNode.addEnteringEdge(copyEdge);
                if (!pTestTargets.contains(currentEdge)) continue;
                copiedEdgeToTestTargetsMap.put(copyEdge, currentEdge);
            }
        }
        return Pair.of((CFANode)origCFANodeToCopyMap.get(pEntryNode), (CFANode)origCFANodeToCopyMap.get(pEntryNode.getExitNode()));
    }

    private boolean isSelfLoop(CFAEdge pEdge) {
        return pEdge.getPredecessor() == pEdge.getSuccessor();
    }

    private boolean entersNode(CFAEdge pEdge, CFANode pNode) {
        return pEdge.getSuccessor() == pNode;
    }

    private boolean entersProgramStart(CFAEdge pEdge, CFANode pFunctionEntryNode) {
        return this.entersNode(pEdge, pFunctionEntryNode);
    }

    private boolean entersProgramEnd(CFAEdge pEdge, CFANode pFunctionExitNode) {
        return this.entersNode(pEdge, pFunctionExitNode);
    }

    private void redirectEdgeToNewPredecessor(CFAEdge edgeToRedirect, CFANode newPredecessor, Map<CFAEdge, CFAEdge> copiedEdgeToTestTargetsMap) {
        DummyCFAEdge redirectedEdge = this.isSelfLoop(edgeToRedirect) ? new DummyCFAEdge(newPredecessor, newPredecessor) : new DummyCFAEdge(newPredecessor, edgeToRedirect.getSuccessor());
        edgeToRedirect.getSuccessor().removeEnteringEdge(edgeToRedirect);
        redirectedEdge.getSuccessor().addEnteringEdge(redirectedEdge);
        redirectedEdge.getPredecessor().addLeavingEdge(redirectedEdge);
        this.copyTestTargetProperty(edgeToRedirect, redirectedEdge, copiedEdgeToTestTargetsMap);
    }

    private void redirectEdgeToNewSuccessor(CFAEdge edgeToRedirect, CFANode newSuccessor, Map<CFAEdge, CFAEdge> pCopiedEdgeToTestTargetsMap) {
        DummyCFAEdge redirectedEdge = this.isSelfLoop(edgeToRedirect) ? new DummyCFAEdge(newSuccessor, newSuccessor) : new DummyCFAEdge(edgeToRedirect.getPredecessor(), newSuccessor);
        edgeToRedirect.getPredecessor().removeLeavingEdge(edgeToRedirect);
        redirectedEdge.getPredecessor().addLeavingEdge(redirectedEdge);
        redirectedEdge.getSuccessor().addEnteringEdge(redirectedEdge);
        this.copyTestTargetProperty(edgeToRedirect, redirectedEdge, pCopiedEdgeToTestTargetsMap);
    }

    private void copyTestTargetProperty(CFAEdge copyFrom, CFAEdge copyTo, Map<CFAEdge, CFAEdge> pCopiedEdgeToTestTargetsMap) {
        if (pCopiedEdgeToTestTargetsMap.containsKey(copyFrom)) {
            pCopiedEdgeToTestTargetsMap.put(copyTo, pCopiedEdgeToTestTargetsMap.get(copyFrom));
            pCopiedEdgeToTestTargetsMap.remove(copyFrom);
        }
    }

    private void updateTestGoalMappingAfterRemoval(CFAEdge removedEdge, FluentIterable<CFAEdge> dominatorCandidates, Map<CFAEdge, CFAEdge> copiedEdgeToTestTargetsMap, Set<CFAEdge> pTestTargets) {
        if (copiedEdgeToTestTargetsMap.containsKey(removedEdge)) {
            CFAEdge testTargetToBeDominated = copiedEdgeToTestTargetsMap.get(removedEdge);
            for (CFAEdge domEdgeCandidate : dominatorCandidates) {
                if (copiedEdgeToTestTargetsMap.containsKey(domEdgeCandidate) && !copiedEdgeToTestTargetsMap.get(domEdgeCandidate).equals(testTargetToBeDominated)) {
                    pTestTargets.remove(testTargetToBeDominated);
                    copiedEdgeToTestTargetsMap.values().removeAll(Collections.singleton(testTargetToBeDominated));
                    break;
                }
                copiedEdgeToTestTargetsMap.put(domEdgeCandidate, testTargetToBeDominated);
            }
            copiedEdgeToTestTargetsMap.remove(removedEdge);
        }
    }

    private void removeLeavingEdge(CFAEdge toRemove, Map<CFAEdge, CFAEdge> copiedEdgeToTestTargetsMap, Set<CFAEdge> pTestTargets) {
        CFANode pred = toRemove.getPredecessor();
        pred.removeLeavingEdge(toRemove);
        toRemove.getSuccessor().removeEnteringEdge(toRemove);
        CFANode successorNode = toRemove.getSuccessor();
        for (CFAEdge twoStepDescendantEdge : CFAUtils.leavingEdges(successorNode)) {
            this.redirectEdgeToNewPredecessor(twoStepDescendantEdge, pred, copiedEdgeToTestTargetsMap);
        }
        for (CFAEdge enteringRemovedNode : CFAUtils.enteringEdges(successorNode)) {
            if (enteringRemovedNode == toRemove) continue;
            this.redirectEdgeToNewSuccessor(enteringRemovedNode, pred, copiedEdgeToTestTargetsMap);
        }
        this.updateTestGoalMappingAfterRemoval(toRemove, CFAUtils.enteringEdges(pred), copiedEdgeToTestTargetsMap, pTestTargets);
    }

    private void removeEnteringEdge(CFAEdge toRemove, Map<CFAEdge, CFAEdge> copiedEdgeToTestTargetsMap, Set<CFAEdge> pTestTargets, boolean mayBeLoopHead) {
        CFANode succ = toRemove.getSuccessor();
        toRemove.getPredecessor().removeLeavingEdge(toRemove);
        succ.removeEnteringEdge(toRemove);
        for (CFAEdge leavingEdge : CFAUtils.leavingEdges(succ)) {
            this.redirectEdgeToNewPredecessor(leavingEdge, toRemove.getPredecessor(), copiedEdgeToTestTargetsMap);
        }
        if (mayBeLoopHead) {
            for (CFAEdge enteringEdge : CFAUtils.enteringEdges(succ)) {
                if (toRemove == enteringEdge) continue;
                this.redirectEdgeToNewSuccessor(enteringEdge, toRemove.getPredecessor(), copiedEdgeToTestTargetsMap);
            }
        }
        this.updateTestGoalMappingAfterRemoval(toRemove, CFAUtils.leavingEdges(succ), copiedEdgeToTestTargetsMap, pTestTargets);
    }

    private void applyRule1(Set<CFAEdge> pTestTargets, Map<CFAEdge, CFAEdge> copiedEdgeToTestTargetsMap, Pair<CFANode, CFANode> pCopiedFunctionEntryExit) {
        HashSet<CFANode> visitedNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        waitlist.add(pCopiedFunctionEntryExit.getFirst());
        visitedNodes.add(pCopiedFunctionEntryExit.getFirst());
        while (!waitlist.isEmpty()) {
            CFANode currentNode = (CFANode)waitlist.poll();
            while (!(currentNode.getNumLeavingEdges() != 1 || this.entersProgramStart(currentNode.getLeavingEdge(0), pCopiedFunctionEntryExit.getFirst()) || this.entersProgramEnd(currentNode.getLeavingEdge(0), pCopiedFunctionEntryExit.getSecond()) || this.isSelfLoop(currentNode.getLeavingEdge(0)))) {
                CFAEdge removedEdge = currentNode.getLeavingEdge(0);
                this.removeLeavingEdge(removedEdge, copiedEdgeToTestTargetsMap, pTestTargets);
                waitlist.remove(removedEdge.getSuccessor());
            }
            for (CFAEdge leaveEdge : CFAUtils.leavingEdges(currentNode)) {
                if (!visitedNodes.add(leaveEdge.getSuccessor())) continue;
                waitlist.add(leaveEdge.getSuccessor());
            }
        }
    }

    private void applyRule2(Set<CFAEdge> pTestTargets, Map<CFAEdge, CFAEdge> copiedEdgeToTestTargetsMap, Pair<CFANode, CFANode> pCopiedFunctionEntryExit) {
        HashSet<CFANode> vistedNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        waitlist.add(pCopiedFunctionEntryExit.getFirst());
        vistedNodes.add(pCopiedFunctionEntryExit.getFirst());
        while (!waitlist.isEmpty()) {
            CFANode currentNode = (CFANode)waitlist.poll();
            if (!(currentNode.getNumEnteringEdges() != 1 || this.entersProgramStart(currentNode.getEnteringEdge(0), pCopiedFunctionEntryExit.getFirst()) || this.entersProgramEnd(currentNode.getEnteringEdge(0), pCopiedFunctionEntryExit.getSecond()) || this.isSelfLoop(currentNode.getEnteringEdge(0)))) {
                this.removeEnteringEdge(currentNode.getEnteringEdge(0), copiedEdgeToTestTargetsMap, pTestTargets, false);
                waitlist.remove(currentNode);
            }
            for (CFAEdge leavingEdge : CFAUtils.leavingEdges(currentNode)) {
                if (!vistedNodes.add(leavingEdge.getSuccessor())) continue;
                waitlist.add(leavingEdge.getSuccessor());
            }
        }
    }

    private void applyRule3(Set<CFAEdge> pTestTargets, Map<CFAEdge, CFAEdge> copiedEdgeToTestTargetsMap, Pair<CFANode, CFANode> pCopiedFunctionEntryExit) {
        if (pCopiedFunctionEntryExit.getSecond() == null) {
            return;
        }
        HashSet<CFANode> visitedNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        DomTree<CFANode> inverseDomTree = DomTree.forGraph(CFAUtils::allSuccessorsOf, CFAUtils::allPredecessorsOf, pCopiedFunctionEntryExit.getSecond());
        waitlist.add(pCopiedFunctionEntryExit.getFirst());
        visitedNodes.add(pCopiedFunctionEntryExit.getFirst());
        while (!waitlist.isEmpty()) {
            CFANode currentNode = (CFANode)waitlist.poll();
            boolean ruleApplicable = currentNode.getNumEnteringEdges() > 0;
            CFAEdge removedEdge = null;
            for (CFAEdge leavingEdge : CFAUtils.leavingEdges(currentNode)) {
                if (inverseDomTree.isAncestorOf(leavingEdge.getSuccessor(), currentNode)) continue;
                if (removedEdge == null) {
                    removedEdge = leavingEdge;
                    if (!this.entersProgramStart(removedEdge, pCopiedFunctionEntryExit.getFirst()) && !this.entersProgramEnd(removedEdge, pCopiedFunctionEntryExit.getSecond()) && !this.isSelfLoop(removedEdge)) continue;
                    ruleApplicable = false;
                    break;
                }
                ruleApplicable = false;
                break;
            }
            if (ruleApplicable && removedEdge != null && !this.isSelfLoop(removedEdge)) {
                this.removeLeavingEdge(removedEdge, copiedEdgeToTestTargetsMap, pTestTargets);
                waitlist.remove(removedEdge.getSuccessor());
                waitlist.add(currentNode);
            }
            if (waitlist.contains(currentNode)) continue;
            for (CFAEdge leavingEdge : CFAUtils.leavingEdges(currentNode)) {
                if (!visitedNodes.add(leavingEdge.getSuccessor())) continue;
                waitlist.add(leavingEdge.getSuccessor());
            }
        }
    }

    private void applyRule4(Set<CFAEdge> pTestTargets, Map<CFAEdge, CFAEdge> copiedEdgeToTestTargetsMap, CFANode copiedFunctionEntry) {
        HashSet<CFANode> visitedNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        DomTree<CFANode> domTree = DomTree.forGraph(CFAUtils::allPredecessorsOf, CFAUtils::allSuccessorsOf, copiedFunctionEntry);
        waitlist.add(copiedFunctionEntry);
        visitedNodes.add(copiedFunctionEntry);
        while (!waitlist.isEmpty()) {
            CFANode currentNode = (CFANode)waitlist.poll();
            boolean ruleApplicable = currentNode.getNumLeavingEdges() > 0;
            CFAEdge removedEdge = null;
            for (CFAEdge enteringEdge : CFAUtils.enteringEdges(currentNode)) {
                if (domTree.isAncestorOf(currentNode, enteringEdge.getPredecessor())) continue;
                if (removedEdge == null) {
                    removedEdge = enteringEdge;
                    if (!this.entersProgramStart(removedEdge, copiedFunctionEntry) && !this.isSelfLoop(removedEdge)) continue;
                    ruleApplicable = false;
                    break;
                }
                ruleApplicable = false;
                break;
            }
            if (ruleApplicable && removedEdge != null && !this.isSelfLoop(removedEdge)) {
                this.removeEnteringEdge(removedEdge, copiedEdgeToTestTargetsMap, pTestTargets, true);
                waitlist.remove(removedEdge.getSuccessor());
            }
            for (CFAEdge leavingEdge : CFAUtils.leavingEdges(currentNode)) {
                if (!visitedNodes.add(leavingEdge.getSuccessor())) continue;
                waitlist.add(leavingEdge.getSuccessor());
            }
        }
    }
}

