/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.testtargets;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetAdaption;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetType;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class TestTargetProvider
implements Statistics {
    private static TestTargetProvider instance = null;
    private final CFA cfa;
    private final TestTargetType type;
    private final ImmutableSet<CFAEdge> initialTestTargets;
    private final Set<CFAEdge> uncoveredTargets;
    private int numNonOptimizedTargets = -1;
    private boolean printTargets = false;
    private boolean runParallel;
    private TestTargetAdaption optimization;
    private Timer optimizationTimer = new Timer();

    private TestTargetProvider(CFA pCfa, boolean pRunParallel, TestTargetType pType, String pTargetFun, TestTargetAdaption pGoalAdaption) {
        Predicate<CFAEdge> edgeCriterion;
        this.cfa = pCfa;
        this.runParallel = pRunParallel;
        this.type = pType;
        this.optimization = pGoalAdaption;
        switch (this.type) {
            case FUN_CALL: {
                edgeCriterion = this.type.getEdgeCriterion(pTargetFun);
                break;
            }
            default: {
                edgeCriterion = this.type.getEdgeCriterion();
            }
        }
        Set<CFAEdge> targets = this.extractEdgesByCriterion(edgeCriterion, pGoalAdaption, pCfa);
        this.uncoveredTargets = this.runParallel ? Collections.synchronizedSet(targets) : targets;
        this.initialTestTargets = ImmutableSet.copyOf(this.uncoveredTargets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<CFAEdge> extractEdgesByCriterion(Predicate<CFAEdge> criterion, TestTargetAdaption pAdaption, CFA pCfa) {
        Set<CFAEdge> edges = new HashSet<CFAEdge>();
        for (CFANode node : this.cfa.getAllNodes()) {
            edges.addAll((Collection<CFAEdge>)CFAUtils.allLeavingEdges(node).filter(criterion).toSet());
        }
        this.numNonOptimizedTargets = edges.size();
        this.optimizationTimer.start();
        try {
            edges = pAdaption.adaptTestTargets(edges, pCfa);
        }
        finally {
            this.optimizationTimer.stopIfRunning();
        }
        return edges;
    }

    public static int getTotalNumberOfTestTargets() {
        if (instance == null) {
            return 0;
        }
        return TestTargetProvider.instance.initialTestTargets.size();
    }

    public static int getNumberOfUncoveredTestTargets() {
        if (instance == null) {
            return 0;
        }
        return TestTargetProvider.instance.uncoveredTargets.size();
    }

    public static Set<CFAEdge> getTestTargets(CFA pCfa, boolean pRunParallel, TestTargetType pType, String pTargetFun, TestTargetAdaption pTargetOptimization) {
        if (instance == null || pCfa != TestTargetProvider.instance.cfa || TestTargetProvider.instance.type != pType || TestTargetProvider.instance.optimization != pTargetOptimization) {
            instance = new TestTargetProvider(pCfa, pRunParallel, pType, pTargetFun, pTargetOptimization);
        }
        Preconditions.checkState((TestTargetProvider.instance.runParallel || !pRunParallel ? 1 : 0) != 0);
        return TestTargetProvider.instance.uncoveredTargets;
    }

    public static String getCoverageInfo() {
        Preconditions.checkNotNull((Object)instance);
        return TestTargetProvider.instance.initialTestTargets.size() - TestTargetProvider.instance.uncoveredTargets.size() + " of " + TestTargetProvider.instance.initialTestTargets.size() + " covered";
    }

    public static Statistics getTestTargetStatisitics(boolean pPrintTestGoalInfo) {
        Preconditions.checkNotNull((Object)instance);
        TestTargetProvider.instance.printTargets = pPrintTestGoalInfo;
        return instance;
    }

    public static boolean isTerminatingFunctionCall(CFAEdge pEdge) {
        if (pEdge instanceof CStatementEdge && ((CStatementEdge)pEdge).getStatement() instanceof CFunctionCall) {
            String funName = "";
            CExpression funExpr = ((CFunctionCall)((CStatementEdge)pEdge).getStatement()).getFunctionCallExpression().getFunctionNameExpression();
            if (funExpr instanceof CIdExpression) {
                funName = ((CIdExpression)funExpr).getName();
            }
            return funName.equals("abort") || funName.equals("exit") || funName.equals("__assert_fail");
        }
        return false;
    }

    @Override
    public @Nullable String getName() {
        return "Testtargets";
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        int numCovered = this.initialTestTargets.size() - this.uncoveredTargets.size();
        double testTargetCoverage = this.initialTestTargets.isEmpty() ? 0.0 : (double)numCovered / (double)this.initialTestTargets.size();
        pOut.printf("Test target coverage: %.2f%%%n", testTargetCoverage * 100.0);
        if (this.numNonOptimizedTargets >= 0) {
            pOut.println("Number of total test targets before optimization: " + this.numNonOptimizedTargets);
        }
        pOut.println("Number of total test targets: " + this.initialTestTargets.size());
        pOut.println("Number of covered test targets: " + numCovered);
        pOut.println("Number of uncovered test targets: " + this.uncoveredTargets.size());
        pOut.println("Total time for test goal reduction:     " + this.optimizationTimer);
        if (this.printTargets) {
            pOut.println("Initial test targets: ");
            for (CFAEdge edge : this.initialTestTargets) {
                pOut.println(edge.toString());
            }
            pOut.println("Test targets that have not been covered: ");
            for (CFAEdge edge : this.uncoveredTargets) {
                pOut.println(edge.toString());
            }
        }
    }
}

