/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.testtargets;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetReductionUtils;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.graph.dominance.DomTree;

public class TestTargetReductionSpanningSet {
    public Set<CFAEdge> reduceTargets(Set<CFAEdge> pTargets, CFA pCfa) {
        Preconditions.checkNotNull(pTargets);
        return this.getTestTargetsFromLeaves(this.reduceSubsumptionGraph(this.computeStronglyConnectedComponents(this.constructSubsumptionGraph(pTargets, pCfa.getMainFunction()))));
    }

    private ImmutableSet<CFAEdgeNode> constructSubsumptionGraph(Set<CFAEdge> pTargets, FunctionEntryNode pStartNode) {
        ImmutableSet.Builder nodeBuilder = ImmutableSet.builder();
        HashMap edgeToNode = Maps.newHashMapWithExpectedSize((int)pTargets.size());
        HashMap copyToTarget = Maps.newHashMapWithExpectedSize((int)pTargets.size());
        Pair<CFANode, CFANode> entryExit = TestTargetReductionUtils.buildTestGoalGraph(pTargets, copyToTarget, pStartNode);
        HashMap targetToCopy = Maps.newHashMapWithExpectedSize((int)copyToTarget.size());
        for (Map.Entry entry : copyToTarget.entrySet()) {
            targetToCopy.put((CFAEdge)entry.getValue(), (CFAEdge)entry.getKey());
        }
        for (CFAEdge target : pTargets) {
            CFAEdgeNode node = new CFAEdgeNode(target);
            edgeToNode.put(target, node);
            nodeBuilder.add((Object)node);
        }
        DomTree<CFANode> domTree = DomTree.forGraph(CFAUtils::allPredecessorsOf, CFAUtils::allSuccessorsOf, entryExit.getFirst());
        DomTree<CFANode> inverseDomTree = entryExit.getSecond() != null ? DomTree.forGraph(CFAUtils::allSuccessorsOf, CFAUtils::allPredecessorsOf, entryExit.getSecond()) : null;
        for (CFAEdge targetPred : pTargets) {
            for (CFAEdge targetSucc : pTargets) {
                if (targetPred == targetSucc || targetPred.getSuccessor().getNumEnteringEdges() != 1 || targetSucc.getSuccessor().getNumEnteringEdges() != 1 || !domTree.isAncestorOf(((CFAEdge)targetToCopy.get(targetPred)).getSuccessor(), ((CFAEdge)targetToCopy.get(targetSucc)).getSuccessor()) && (inverseDomTree == null || !inverseDomTree.isAncestorOf(((CFAEdge)targetToCopy.get(targetPred)).getSuccessor(), ((CFAEdge)targetToCopy.get(targetSucc)).getSuccessor()))) continue;
                ((CFAEdgeNode)edgeToNode.get(targetPred)).addEdgeTo((CFAEdgeNode)edgeToNode.get(targetSucc));
            }
        }
        return nodeBuilder.build();
    }

    private ImmutableSet<Collection<CFAEdgeNode>> computeStronglyConnectedComponents(ImmutableSet<CFAEdgeNode> nodes) {
        ImmutableSet.Builder componentsBuilder = ImmutableSet.builder();
        ArrayDeque<CFAEdgeNode> ordered = new ArrayDeque<CFAEdgeNode>(nodes.size());
        HashSet visited = Sets.newHashSetWithExpectedSize((int)nodes.size());
        for (CFAEdgeNode node : nodes) {
            this.dfs(node, false, visited, ordered);
        }
        visited = Sets.newHashSetWithExpectedSize((int)nodes.size());
        for (CFAEdgeNode node : ordered) {
            ArrayDeque<CFAEdgeNode> componentElems = new ArrayDeque<CFAEdgeNode>();
            this.dfs(node, true, visited, componentElems);
            if (componentElems.isEmpty()) continue;
            componentsBuilder.add(componentElems);
        }
        return componentsBuilder.build();
    }

    private void dfs(CFAEdgeNode pNode, boolean pBackwards, Set<CFAEdgeNode> pVisited, Deque<CFAEdgeNode> componentElems) {
        if (pVisited.add(pNode)) {
            for (CFAEdgeNode succ : pNode.edges(pBackwards)) {
                this.dfs(succ, pBackwards, pVisited, componentElems);
            }
            componentElems.addFirst(pNode);
        }
    }

    private ImmutableSet<CFAEdgeNode> reduceSubsumptionGraph(ImmutableSet<Collection<CFAEdgeNode>> pComponents) {
        ImmutableSet.Builder nodeBuilder = ImmutableSet.builder();
        for (Collection component : pComponents) {
            nodeBuilder.add((Object)CFAEdgeNode.merge(component));
        }
        return nodeBuilder.build();
    }

    private Set<CFAEdge> getTestTargetsFromLeaves(ImmutableSet<CFAEdgeNode> pNodes) {
        return new HashSet<CFAEdge>((Collection<CFAEdge>)FluentIterable.from(pNodes).filter(node -> node.isLeave()).transform(node -> node.representativeTarget).toSet());
    }

    private static class CFAEdgeNode {
        private final CFAEdge representativeTarget;
        private final Collection<CFAEdgeNode> predecessors;
        private final Collection<CFAEdgeNode> successors;

        public CFAEdgeNode(CFAEdge pTarget) {
            this.representativeTarget = pTarget;
            this.predecessors = new ArrayList<CFAEdgeNode>();
            this.successors = new ArrayList<CFAEdgeNode>();
        }

        public void addEdgeTo(CFAEdgeNode succ) {
            this.successors.add(succ);
            succ.predecessors.add(this);
        }

        public FluentIterable<CFAEdgeNode> edges(boolean incoming) {
            return incoming ? FluentIterable.from(this.predecessors) : FluentIterable.from(this.successors);
        }

        public boolean isLeave() {
            return this.successors.isEmpty();
        }

        public static CFAEdgeNode merge(Collection<CFAEdgeNode> pComponent) {
            Preconditions.checkArgument((!pComponent.isEmpty() ? 1 : 0) != 0);
            CFAEdgeNode superNode = new CFAEdgeNode(pComponent.iterator().next().representativeTarget);
            HashSet<CFAEdgeNode> newPred = new HashSet<CFAEdgeNode>();
            HashSet<CFAEdgeNode> newSucc = new HashSet<CFAEdgeNode>();
            for (CFAEdgeNode elem : pComponent) {
                newPred.addAll(elem.predecessors);
                newSucc.addAll(elem.successors);
                for (CFAEdgeNode pred : elem.predecessors) {
                    pred.successors.remove(pred);
                }
                for (CFAEdgeNode succ : elem.successors) {
                    succ.predecessors.remove(succ);
                }
            }
            newPred.removeAll(pComponent);
            newSucc.removeAll(pComponent);
            for (CFAEdgeNode pred : newPred) {
                pred.addEdgeTo(superNode);
            }
            for (CFAEdgeNode succ : newSucc) {
                superNode.addEdgeTo(succ);
            }
            return superNode;
        }

        public String toString() {
            return this.representativeTarget + "\n predecessors:" + FluentIterable.from(this.predecessors).transform(edgeNode -> edgeNode.representativeTarget).join(Joiner.on((char)'\t')) + "\n successors:" + FluentIterable.from(this.successors).transform(edgeNode -> edgeNode.representativeTarget).join(Joiner.on((char)'\t')) + "\n";
        }
    }
}

