/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.testtargets;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.cpachecker.cfa.DummyCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;

public final class TestTargetReductionUtils {
    private TestTargetReductionUtils() {
    }

    public static Pair<CFANode, CFANode> buildTestGoalGraph(Set<CFAEdge> pTestTargets, Map<CFAEdge, CFAEdge> pCopiedEdgeToTestTargetsMap, FunctionEntryNode pEntryNode) {
        HashSet successorNodes = Sets.newHashSetWithExpectedSize((int)(pTestTargets.size() + 2));
        HashSet<CFANode> visited = new HashSet<CFANode>();
        HashMap<CFANode, CFANode> origCFANodeToCopyMap = new HashMap<CFANode, CFANode>();
        HashSet toExplore = Sets.newHashSetWithExpectedSize((int)(pTestTargets.size() + 1));
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        origCFANodeToCopyMap.put(pEntryNode, CFANode.newDummyCFANode());
        toExplore.add(pEntryNode);
        origCFANodeToCopyMap.put(pEntryNode.getExitNode(), CFANode.newDummyCFANode(""));
        successorNodes.add(pEntryNode.getExitNode());
        for (CFAEdge target : pTestTargets) {
            successorNodes.add(target.getPredecessor());
            toExplore.add(target.getSuccessor());
            if (!origCFANodeToCopyMap.containsKey(target.getPredecessor())) {
                origCFANodeToCopyMap.put(target.getPredecessor(), CFANode.newDummyCFANode(""));
            }
            if (!origCFANodeToCopyMap.containsKey(target.getSuccessor())) {
                origCFANodeToCopyMap.put(target.getSuccessor(), CFANode.newDummyCFANode(""));
            }
            pCopiedEdgeToTestTargetsMap.put(TestTargetReductionUtils.copyAsDummyEdge((CFANode)origCFANodeToCopyMap.get(target.getPredecessor()), (CFANode)origCFANodeToCopyMap.get(target.getSuccessor())), target);
        }
        for (CFANode predecessor : toExplore) {
            if (!successorNodes.contains(predecessor)) {
                waitlist.add(predecessor);
                visited.clear();
            }
            while (!waitlist.isEmpty()) {
                CFANode currentNode = (CFANode)waitlist.poll();
                for (CFAEdge leaving : CFAUtils.leavingEdges(currentNode)) {
                    if (successorNodes.contains(leaving.getSuccessor())) {
                        if (((CFANode)origCFANodeToCopyMap.get(predecessor)).hasEdgeTo((CFANode)origCFANodeToCopyMap.get(leaving.getSuccessor()))) continue;
                        TestTargetReductionUtils.copyAsDummyEdge((CFANode)origCFANodeToCopyMap.get(predecessor), (CFANode)origCFANodeToCopyMap.get(leaving.getSuccessor()));
                        continue;
                    }
                    if (!visited.add(leaving.getSuccessor())) continue;
                    waitlist.add(leaving.getSuccessor());
                }
            }
        }
        if (TestTargetReductionUtils.removeUnreachableTestGoalsAndIsReachExit(pTestTargets, pCopiedEdgeToTestTargetsMap, (CFANode)origCFANodeToCopyMap.get(pEntryNode), (CFANode)origCFANodeToCopyMap.get(pEntryNode.getExitNode()))) {
            return Pair.of((CFANode)origCFANodeToCopyMap.get(pEntryNode), (CFANode)origCFANodeToCopyMap.get(pEntryNode.getExitNode()));
        }
        return Pair.of((CFANode)origCFANodeToCopyMap.get(pEntryNode), null);
    }

    private static boolean removeUnreachableTestGoalsAndIsReachExit(Set<CFAEdge> pTestTargets, Map<CFAEdge, CFAEdge> pCopiedEdgeToTestTargetsMap, CFANode pEntry, CFANode pExit) {
        HashSet<CFANode> visited = new HashSet<CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        visited.add(pEntry);
        waitlist.add(pEntry);
        while (!waitlist.isEmpty()) {
            CFANode pred = (CFANode)waitlist.poll();
            for (CFANode succ : CFAUtils.allSuccessorsOf(pred)) {
                if (!visited.add(succ)) continue;
                waitlist.add(succ);
            }
        }
        ArrayList<CFAEdge> toDelete = new ArrayList<CFAEdge>();
        for (Map.Entry<CFAEdge, CFAEdge> mapEntry : pCopiedEdgeToTestTargetsMap.entrySet()) {
            if (visited.contains(mapEntry.getKey().getPredecessor())) continue;
            pTestTargets.remove(mapEntry.getValue());
            toDelete.add(mapEntry.getKey());
        }
        for (CFAEdge unreachTarget : toDelete) {
            pCopiedEdgeToTestTargetsMap.remove(unreachTarget);
        }
        return visited.contains(pExit);
    }

    public static CFAEdge copyAsDummyEdge(CFANode pred, CFANode succ) {
        DummyCFAEdge newEdge = new DummyCFAEdge(pred, succ);
        pred.addLeavingEdge(newEdge);
        succ.addEnteringEdge(newEdge);
        return newEdge;
    }

    public static void drawGraph(Path pOutputfile, CFANode pEntry) throws IOException {
        try (Writer sb = IO.openOutputFile((Path)pOutputfile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            sb.append("digraph CFA {\n");
            sb.append("node [shape=\"circle\"]\n");
            HashSet<CFANode> visited = new HashSet<CFANode>();
            ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
            visited.add(pEntry);
            waitlist.add(pEntry);
            sb.append(pEntry.getNodeNumber() + " [shape=\"circle\"]\n");
            while (!waitlist.isEmpty()) {
                CFANode pred = (CFANode)waitlist.poll();
                for (CFANode succ : CFAUtils.allSuccessorsOf(pred)) {
                    if (visited.add(succ)) {
                        sb.append(succ.getNodeNumber() + " [shape=\"circle\"]\n");
                        waitlist.add(succ);
                    }
                    sb.append(pred.getNodeNumber() + " -> " + succ.getNodeNumber() + "\n");
                }
            }
            sb.append("}");
        }
    }
}

