/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.testtargets;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class TestTargetState
implements LatticeAbstractState<TestTargetState>,
Targetable,
Graphable {
    private static final TestTargetState noTargetState = new TestTargetState(Status.NO_TARGET);
    private Status currentState;

    public static AbstractState noTargetState() {
        return noTargetState;
    }

    TestTargetState(Status pInitialStatus) {
        this.currentState = pInitialStatus;
    }

    @Override
    public boolean isTarget() {
        return this.currentState.isConsideredTarget;
    }

    @Override
    public @NonNull Set<Targetable.TargetInformation> getTargetInformation() throws IllegalStateException {
        return ImmutableSet.of();
    }

    @Override
    public String toDOTLabel() {
        return this.currentState.name();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public String toString() {
        return this.currentState.name();
    }

    @Override
    public TestTargetState join(TestTargetState pOther) throws CPAException, InterruptedException {
        throw new UnsupportedOperationException("Join is not supported");
    }

    @Override
    public boolean isLessOrEqual(TestTargetState pOther) throws CPAException, InterruptedException {
        return this.equals(pOther) || pOther.currentState == Status.TARGET && this.currentState == Status.STOP_POSSIBLY_INFEASIBLE_TARGET;
    }

    public void changeToStopTargetStatus() {
        if (this != noTargetState) {
            this.currentState = Status.STOP_POSSIBLY_INFEASIBLE_TARGET;
        }
    }

    public boolean isStop() {
        return this.currentState == Status.STOP_POSSIBLY_INFEASIBLE_TARGET;
    }

    static enum Status {
        TARGET(true),
        NO_TARGET(false),
        STOP_POSSIBLY_INFEASIBLE_TARGET(false);

        private final boolean isConsideredTarget;

        private Status(boolean isTarget) {
            this.isConsideredTarget = isTarget;
        }
    }
}

