/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.testtargets;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class TestTargetTransferRelation
extends SingleEdgeTransferRelation {
    private final Set<CFAEdge> testTargets;

    TestTargetTransferRelation(Set<CFAEdge> pTestTargets) {
        this.testTargets = pTestTargets;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        Preconditions.checkNotNull(this.testTargets);
        Preconditions.checkArgument((boolean)(pState instanceof TestTargetState), (Object)"Abstract state in TestTargetTransferRelation not an element of TestTargetState");
        if (((TestTargetState)pState).isStop()) {
            return ImmutableSet.of();
        }
        return Collections.singleton(this.testTargets.contains(pCfaEdge) ? new TestTargetState(TestTargetState.Status.TARGET) : TestTargetState.noTargetState());
    }

    public Set<CFAEdge> getTestTargets() {
        return this.testTargets;
    }
}

