/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.thread;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.cpa.thread.ThreadReducer;
import org.sosy_lab.cpachecker.cpa.thread.ThreadState;
import org.sosy_lab.cpachecker.cpa.thread.ThreadTransferRelation;

public class ThreadCPA
extends AbstractCPA
implements ConfigurableProgramAnalysisWithBAM,
StatisticsProvider {
    private final ThreadReducer reducer = new ThreadReducer();

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ThreadCPA.class);
    }

    public ThreadCPA(Configuration pConfig) throws InvalidConfigurationException {
        super("sep", "sep", DelegateAbstractDomain.getInstance(), new ThreadTransferRelation(pConfig));
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        Preconditions.checkNotNull((Object)pNode);
        return ThreadState.emptyState();
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition partition) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(((ThreadTransferRelation)this.getTransferRelation()).getStatistics());
    }
}

