/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.thread;

import java.util.Objects;

public final class ThreadLabel
implements Comparable<ThreadLabel> {
    private final String threadName;
    private final String varName;

    public ThreadLabel(String name, String vName) {
        this.threadName = name;
        this.varName = vName;
    }

    public int hashCode() {
        return Objects.hash(this.varName, this.threadName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadLabel other = (ThreadLabel)obj;
        return Objects.equals(this.threadName, other.threadName) && Objects.equals(this.varName, other.varName);
    }

    @Override
    public int compareTo(ThreadLabel pO) {
        int result = this.threadName.compareTo(pO.threadName);
        if (result != 0) {
            return result;
        }
        return this.varName.compareTo(pO.varName);
    }

    public String getName() {
        return this.threadName;
    }

    public String getVarName() {
        return this.varName;
    }

    public String toString() {
        return "(" + this.threadName + ", " + this.varName + ")";
    }

    public static enum LabelStatus {
        PARENT_THREAD,
        CREATED_THREAD,
        SELF_PARALLEL_THREAD;

    }
}

