/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.thread;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.cpa.thread.ThreadLabel;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleNode;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleState;

public class ThreadState
implements LatticeAbstractState<ThreadState>,
CompatibleNode {
    private final Map<String, ThreadStatus> threadSet;
    private final ImmutableMap<ThreadLabel, ThreadStatus> removedSet;
    private final List<ThreadLabel> order;

    public ThreadState(Map<String, ThreadStatus> Tset, ImmutableMap<ThreadLabel, ThreadStatus> Rset, List<ThreadLabel> pOrder) {
        this.threadSet = Tset;
        this.removedSet = Rset;
        this.order = ImmutableList.copyOf(pOrder);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.removedSet, this.threadSet);
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadState other = (ThreadState)obj;
        return Objects.equals(this.removedSet, other.removedSet) && Objects.equals(this.threadSet, other.threadSet);
    }

    @Override
    public int compareTo(CompatibleState pOther) {
        ThreadState other = (ThreadState)pOther;
        int result = other.threadSet.size() - this.threadSet.size();
        if (result != 0) {
            return result;
        }
        Iterator<Map.Entry<String, ThreadStatus>> thisIterator = this.threadSet.entrySet().iterator();
        Iterator<Map.Entry<String, ThreadStatus>> otherIterator = other.threadSet.entrySet().iterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            ThreadStatus otherStatus;
            String otherLabel;
            Map.Entry<String, ThreadStatus> thisEntry = thisIterator.next();
            Map.Entry<String, ThreadStatus> otherEntry = otherIterator.next();
            String thisLabel = thisEntry.getKey();
            result = thisLabel.compareTo(otherLabel = otherEntry.getKey());
            if (result != 0) {
                return result;
            }
            ThreadStatus thisStatus = this.threadSet.get(thisLabel);
            result = thisStatus.compareTo(otherStatus = other.threadSet.get(otherLabel));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public boolean isCompatibleWith(CompatibleState state) {
        Preconditions.checkArgument((boolean)(state instanceof ThreadState));
        ThreadState other = (ThreadState)state;
        for (Map.Entry<String, ThreadStatus> entry : this.threadSet.entrySet()) {
            String l = entry.getKey();
            ThreadStatus s = entry.getValue();
            if (!other.threadSet.containsKey(l)) continue;
            ThreadStatus otherL = other.threadSet.get(l);
            if (!(s == ThreadStatus.SELF_PARALLEL_THREAD && otherL != ThreadStatus.CREATED_THREAD || s == ThreadStatus.PARENT_THREAD && otherL != ThreadStatus.PARENT_THREAD) && (s != ThreadStatus.CREATED_THREAD || otherL != ThreadStatus.PARENT_THREAD)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ThreadState prepareToStore() {
        return new ThreadState(this.threadSet, (ImmutableMap<ThreadLabel, ThreadStatus>)ImmutableMap.of(), (List<ThreadLabel>)ImmutableList.of());
    }

    public static ThreadState emptyState() {
        return new ThreadState((Map<String, ThreadStatus>)ImmutableMap.of(), (ImmutableMap<ThreadLabel, ThreadStatus>)ImmutableMap.of(), (List<ThreadLabel>)ImmutableList.of());
    }

    @Override
    public String toString() {
        return Lists.reverse(this.order).stream().filter(l -> this.threadSet.getOrDefault(l.getVarName(), null) == ThreadStatus.CREATED_THREAD).findFirst().map(ThreadLabel::getName).orElse("");
    }

    @Override
    public boolean cover(CompatibleNode pNode) {
        return ((ThreadState)pNode).isLessOrEqual(this);
    }

    @Override
    public ThreadState join(ThreadState pOther) {
        throw new UnsupportedOperationException("Join is not implemented for ThreadCPA");
    }

    @Override
    public boolean isLessOrEqual(ThreadState pOther) {
        boolean b = Objects.equals(this.removedSet, pOther.removedSet);
        if (b && pOther.threadSet == this.threadSet) {
            return true;
        }
        return b &= pOther.threadSet.entrySet().containsAll(this.threadSet.entrySet());
    }

    Map<String, ThreadStatus> getThreadSet() {
        return this.threadSet;
    }

    ImmutableMap<ThreadLabel, ThreadStatus> getRemovedSet() {
        return this.removedSet;
    }

    List<ThreadLabel> getOrder() {
        return this.order;
    }

    int getThreadSize() {
        return this.threadSet.size();
    }

    public static class SimpleThreadState
    extends ThreadState {
        public SimpleThreadState(Map<String, ThreadStatus> Tset, ImmutableMap<ThreadLabel, ThreadStatus> Rset, List<ThreadLabel> pOrder) {
            super(Tset, Rset, pOrder);
        }

        @Override
        public boolean isCompatibleWith(CompatibleState state) {
            return !Objects.equals(this.getThreadSet(), ((ThreadState)state).getThreadSet());
        }

        @Override
        public ThreadState prepareToStore() {
            return new SimpleThreadState(this.getThreadSet(), (ImmutableMap<ThreadLabel, ThreadStatus>)ImmutableMap.of(), (List<ThreadLabel>)ImmutableList.of());
        }

        public static ThreadState emptyState() {
            return new SimpleThreadState((Map<String, ThreadStatus>)ImmutableMap.of(), (ImmutableMap<ThreadLabel, ThreadStatus>)ImmutableMap.of(), (List<ThreadLabel>)ImmutableList.of());
        }
    }

    public static enum ThreadStatus {
        PARENT_THREAD,
        CREATED_THREAD,
        SELF_PARALLEL_THREAD;

    }
}

