/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.thread;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CThreadOperationStatement;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.cpa.thread.ThreadCPAStatistics;
import org.sosy_lab.cpachecker.cpa.thread.ThreadLabel;
import org.sosy_lab.cpachecker.cpa.thread.ThreadState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

@Options(prefix="cpa.thread")
public class ThreadTransferRelation
extends SingleEdgeTransferRelation {
    @Option(secure=true, description="The case when the same thread is created several times we do not support.We may skip or fail in this case.")
    private boolean skipTheSameThread = false;
    @Option(secure=true, description="The case when the same thread is created several times we do not support.We may try to support it with self-parallelizm.")
    private boolean supportSelfCreation = false;
    @Option(secure=true, description="Simple thread analysis from theory paper")
    private boolean simpleMode = false;
    private final ThreadCPAStatistics threadStatistics;

    public ThreadTransferRelation(Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.threadStatistics = new ThreadCPAStatistics();
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        ThreadState tState;
        this.threadStatistics.transfer.start();
        ThreadState newState = tState = (ThreadState)pState;
        try {
            Object functionCall;
            if (pCfaEdge.getEdgeType() == CFAEdgeType.FunctionCallEdge) {
                newState = this.handleFunctionCall(tState, (CFunctionCallEdge)pCfaEdge);
            } else if (pCfaEdge instanceof CFunctionSummaryStatementEdge) {
                functionCall = ((CFunctionSummaryStatementEdge)pCfaEdge).getFunctionCall();
                if (this.isThreadCreateFunction((CFunctionCall)functionCall)) {
                    newState = this.handleParentThread(tState, (CThreadOperationStatement.CThreadCreateStatement)functionCall);
                }
            } else if (pCfaEdge.getEdgeType() == CFAEdgeType.StatementEdge) {
                CStatement stmnt = ((CStatementEdge)pCfaEdge).getStatement();
                if (stmnt instanceof CThreadOperationStatement.CThreadJoinStatement) {
                    this.threadStatistics.threadJoins.inc();
                    newState = this.joinThread(tState, (CThreadOperationStatement.CThreadJoinStatement)stmnt);
                }
            } else if (pCfaEdge.getEdgeType() == CFAEdgeType.FunctionReturnEdge && this.isThreadCreateFunction((CFunctionCall)(functionCall = ((CFunctionReturnEdge)pCfaEdge).getSummaryEdge().getExpression()))) {
                newState = null;
            }
            if (newState != null) {
                functionCall = Collections.singleton(newState);
                return functionCall;
            }
            functionCall = ImmutableSet.of();
            return functionCall;
        }
        catch (CPATransferException e) {
            if (this.skipTheSameThread) {
                ImmutableSet immutableSet = ImmutableSet.of();
                return immutableSet;
            }
            throw e;
        }
        finally {
            this.threadStatistics.transfer.stop();
        }
    }

    private ThreadState handleFunctionCall(ThreadState state, CFunctionCallEdge pCfaEdge) throws CPATransferException {
        ThreadState newState = state;
        CFunctionCall fCall = pCfaEdge.getSummaryEdge().getExpression();
        if (this.isThreadCreateFunction(fCall)) {
            newState = this.handleChildThread(state, (CThreadOperationStatement.CThreadCreateStatement)fCall);
            if (this.threadStatistics.createdThreads.add(pCfaEdge.getSuccessor().getFunctionName())) {
                this.threadStatistics.threadCreates.inc();
                this.threadStatistics.maxNumberOfThreads.setNextValue(state.getThreadSize());
            }
        } else if (this.isThreadJoinFunction(fCall)) {
            this.threadStatistics.threadJoins.inc();
            newState = this.joinThread(state, (CThreadOperationStatement.CThreadJoinStatement)fCall);
        }
        return newState;
    }

    private ThreadState handleParentThread(ThreadState state, CThreadOperationStatement.CThreadCreateStatement tCall) throws CPATransferException {
        return this.createThread(state, tCall, ThreadState.ThreadStatus.PARENT_THREAD);
    }

    private ThreadState handleChildThread(ThreadState state, CThreadOperationStatement.CThreadCreateStatement tCall) throws CPATransferException {
        return this.createThread(state, tCall, tCall.isSelfParallel() ? ThreadState.ThreadStatus.SELF_PARALLEL_THREAD : ThreadState.ThreadStatus.CREATED_THREAD);
    }

    private ThreadState createThread(ThreadState state, CThreadOperationStatement.CThreadCreateStatement tCall, ThreadState.ThreadStatus pParentThread) throws CPATransferException {
        ArrayList<Object> newOrder;
        TreeMap<Object, Object> newSet;
        ThreadLabel last;
        String pVarName = tCall.getVariableName();
        String pFunctionName = tCall.getFunctionCallExpression().getFunctionNameExpression().toASTString();
        Map<String, ThreadState.ThreadStatus> tSet = state.getThreadSet();
        List<ThreadLabel> order = state.getOrder();
        ThreadState.ThreadStatus status = pParentThread;
        if (tSet.containsKey(pVarName)) {
            if (this.supportSelfCreation) {
                status = ThreadState.ThreadStatus.SELF_PARALLEL_THREAD;
            } else {
                throw new CPATransferException("Can not create thread " + pFunctionName + ", it was already created");
            }
        }
        if (!tSet.isEmpty() && tSet.get((last = order.get(order.size() - 1)).getVarName()) == ThreadState.ThreadStatus.SELF_PARALLEL_THREAD) {
            status = ThreadState.ThreadStatus.SELF_PARALLEL_THREAD;
        }
        ThreadLabel label = new ThreadLabel(pFunctionName, pVarName);
        if (this.simpleMode) {
            newSet = new TreeMap();
            newOrder = new ArrayList();
        } else {
            newSet = new TreeMap<String, ThreadState.ThreadStatus>(tSet);
            newOrder = new ArrayList<ThreadLabel>(order);
        }
        newSet.put(pVarName, (Object)status);
        newOrder.add(label);
        return new ThreadState(newSet, state.getRemovedSet(), newOrder);
    }

    public ThreadState joinThread(ThreadState state, CThreadOperationStatement.CThreadJoinStatement jCall) {
        ThreadLabel toRemove;
        String var;
        List<ThreadLabel> order = state.getOrder();
        Map<String, ThreadState.ThreadStatus> tSet = state.getThreadSet();
        Optional<ThreadLabel> result = Lists.reverse(order).stream().filter(l -> l.getVarName().equals(jCall.getVariableName())).findFirst();
        if (result.isPresent() && tSet.containsKey(var = (toRemove = result.orElseThrow()).getVarName()) && tSet.get(var) != ThreadState.ThreadStatus.CREATED_THREAD) {
            TreeMap<String, ThreadState.ThreadStatus> newSet = new TreeMap<String, ThreadState.ThreadStatus>(tSet);
            ArrayList<ThreadLabel> newOrder = new ArrayList<ThreadLabel>(order);
            newSet.remove(var);
            newOrder.remove(toRemove);
            return new ThreadState(newSet, state.getRemovedSet(), newOrder);
        }
        return state;
    }

    private boolean isThreadCreateFunction(CFunctionCall statement) {
        return statement instanceof CThreadOperationStatement.CThreadCreateStatement;
    }

    private boolean isThreadJoinFunction(CFunctionCall statement) {
        return statement instanceof CThreadOperationStatement.CThreadJoinStatement;
    }

    public Statistics getStatistics() {
        return this.threadStatistics;
    }
}

