/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.threading;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.AbstractDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.exceptions.NoException;

public class GlobalAccessChecker {
    private final IdentityHashMap<AAstNode, Boolean> astCache = new IdentityHashMap();

    boolean hasGlobalAccess(CFAEdge edge) {
        switch (edge.getEdgeType()) {
            case BlankEdge: {
                return false;
            }
            case AssumeEdge: {
                return this.hasGlobalAccess(((CAssumeEdge)edge).getExpression());
            }
            case StatementEdge: {
                return this.hasGlobalAccess(((CStatementEdge)edge).getStatement());
            }
            case DeclarationEdge: {
                return this.hasGlobalAccess(((CDeclarationEdge)edge).getDeclaration());
            }
            case ReturnStatementEdge: {
                return ((CReturnStatementEdge)edge).getExpression().isPresent() && this.hasGlobalAccess(((CReturnStatementEdge)edge).getExpression().orElseThrow());
            }
            case FunctionCallEdge: {
                return this.hasGlobalAccess(((CFunctionCallEdge)edge).getFunctionCall());
            }
            case FunctionReturnEdge: {
                return this.hasGlobalAccess(((FunctionReturnEdge)edge).getSummaryEdge().getExpression());
            }
        }
        throw new AssertionError((Object)("unexpected edge: " + edge));
    }

    private <T extends AAstNode> boolean hasGlobalAccess(T ast) {
        if (ast == null) {
            return false;
        }
        if (this.astCache.containsKey(ast)) {
            return this.astCache.get(ast);
        }
        boolean hasGlobalAccess = this.hasGlobalAccessDirect(ast);
        this.astCache.put(ast, hasGlobalAccess);
        return hasGlobalAccess;
    }

    private <T extends AAstNode> Boolean anyHasGlobalAccess(List<T> astList) {
        for (AAstNode ast : astList) {
            if (!this.hasGlobalAccess(ast)) continue;
            return true;
        }
        return false;
    }

    private Boolean hasGlobalAccessDirect(AAstNode ast) {
        if (ast instanceof CRightHandSide) {
            if (ast instanceof CExpression) {
                return ((CExpression)ast).accept(GlobalAccessVisitor.INSTANCE);
            }
            if (ast instanceof CFunctionCallExpression) {
                CFunctionCallExpression func = (CFunctionCallExpression)ast;
                return this.anyHasGlobalAccess(func.getParameterExpressions());
            }
        } else if (ast instanceof CInitializer) {
            if (ast instanceof CInitializerExpression) {
                return this.hasGlobalAccess(((CInitializerExpression)ast).getExpression());
            }
            if (ast instanceof CInitializerList) {
                return this.anyHasGlobalAccess(((CInitializerList)ast).getInitializers());
            }
            if (ast instanceof CDesignatedInitializer) {
                CDesignatedInitializer di = (CDesignatedInitializer)ast;
                return this.anyHasGlobalAccess(di.getDesignators()) != false || this.hasGlobalAccess(di.getRightHandSide());
            }
        } else if (ast instanceof CSimpleDeclaration) {
            if (ast instanceof CVariableDeclaration) {
                CVariableDeclaration decl = (CVariableDeclaration)ast;
                return decl.isGlobal() || this.hasGlobalAccess(decl.getInitializer());
            }
            if (ast instanceof CFunctionDeclaration) {
                CFunctionDeclaration decl = (CFunctionDeclaration)ast;
                return this.anyHasGlobalAccess(decl.getParameters());
            }
            if (ast instanceof CComplexTypeDeclaration) {
                CComplexTypeDeclaration decl = (CComplexTypeDeclaration)ast;
                return decl.isGlobal();
            }
            if (ast instanceof CTypeDefDeclaration) {
                CTypeDefDeclaration decl = (CTypeDefDeclaration)ast;
                return decl.isGlobal();
            }
            if (ast instanceof CParameterDeclaration) {
                return false;
            }
            if (ast instanceof CEnumType.CEnumerator) {
                return false;
            }
        } else if (ast instanceof CStatement) {
            if (ast instanceof CFunctionCallAssignmentStatement) {
                CFunctionCallAssignmentStatement stat = (CFunctionCallAssignmentStatement)ast;
                return this.hasGlobalAccess(stat.getLeftHandSide()) || this.hasGlobalAccess(stat.getRightHandSide());
            }
            if (ast instanceof CExpressionAssignmentStatement) {
                CExpressionAssignmentStatement stat = (CExpressionAssignmentStatement)ast;
                return this.hasGlobalAccess(stat.getLeftHandSide()) || this.hasGlobalAccess(stat.getRightHandSide());
            }
            if (ast instanceof CFunctionCallStatement) {
                return this.hasGlobalAccess(((CFunctionCallStatement)ast).getFunctionCallExpression());
            }
            if (ast instanceof CExpressionStatement) {
                return this.hasGlobalAccess(((CExpressionStatement)ast).getExpression());
            }
        } else {
            if (ast instanceof CReturnStatement) {
                Optional<CExpression> returnExp = ((CReturnStatement)ast).getReturnValue();
                Optional<CAssignment> returnAssignment = ((CReturnStatement)ast).asAssignment();
                return returnExp.isPresent() && this.hasGlobalAccess(returnExp.orElseThrow()) || returnAssignment.isPresent() && this.hasGlobalAccess(returnAssignment.orElseThrow());
            }
            if (ast instanceof CDesignator) {
                if (ast instanceof CArrayDesignator) {
                    return this.hasGlobalAccess(((CArrayDesignator)ast).getSubscriptExpression());
                }
                if (ast instanceof CArrayRangeDesignator) {
                    return this.hasGlobalAccess(((CArrayRangeDesignator)ast).getFloorExpression()) || this.hasGlobalAccess(((CArrayRangeDesignator)ast).getCeilExpression());
                }
                if (ast instanceof CFieldDesignator) {
                    return false;
                }
            }
        }
        throw new AssertionError((Object)("unhandled ASTNode " + ast + " of " + ast.getClass()));
    }

    private static class GlobalAccessVisitor
    extends DefaultCExpressionVisitor<Boolean, NoException>
    implements CRightHandSideVisitor<Boolean, NoException> {
        static final GlobalAccessVisitor INSTANCE = new GlobalAccessVisitor();

        private GlobalAccessVisitor() {
        }

        @Override
        public Boolean visit(CIdExpression pE) {
            CSimpleDeclaration decl = pE.getDeclaration();
            return decl instanceof AbstractDeclaration && ((AbstractDeclaration)((Object)decl)).isGlobal();
        }

        @Override
        public Boolean visit(CArraySubscriptExpression pE) {
            return pE.getArrayExpression().accept(this) != false || pE.getSubscriptExpression().accept(this) != false;
        }

        @Override
        public Boolean visit(CBinaryExpression pE) {
            return pE.getOperand1().accept(this) != false || pE.getOperand2().accept(this) != false;
        }

        @Override
        public Boolean visit(CCastExpression pE) {
            return pE.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CComplexCastExpression pE) {
            return pE.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CFieldReference pE) {
            return pE.getFieldOwner().accept(this);
        }

        @Override
        public Boolean visit(CFunctionCallExpression pE) {
            if (pE.getFunctionNameExpression().accept(this).booleanValue()) {
                return true;
            }
            for (CExpression param : pE.getParameterExpressions()) {
                if (!param.accept(this).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visit(CUnaryExpression pE) {
            return pE.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CPointerExpression pE) {
            return pE.getOperand().accept(this);
        }

        @Override
        protected Boolean visitDefault(CExpression pExp) {
            return false;
        }
    }
}

