/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.threading;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.cpa.threading.ThreadingState;
import org.sosy_lab.cpachecker.cpa.threading.ThreadingTransferRelation;

public class ThreadingCPA
extends AbstractCPA {
    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ThreadingCPA.class);
    }

    public ThreadingCPA(Configuration config, LogManager pLogger, CFA pCfa) throws InvalidConfigurationException {
        super("sep", "sep", new ThreadingTransferRelation(config, pCfa, pLogger));
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        Preconditions.checkNotNull((Object)pNode);
        String mainThread = pNode.getFunctionName();
        return ((ThreadingTransferRelation)this.getTransferRelation()).addNewThread(new ThreadingState(), mainThread, 0, mainThread);
    }
}

