/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.threading;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocations;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.threading.ThreadingTransferRelation;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class ThreadingState
implements AbstractState,
AbstractStateWithLocations,
Graphable,
Partitionable,
AbstractQueryableState {
    private static final String PROPERTY_DEADLOCK = "deadlock";
    static final int MIN_THREAD_NUM = 0;
    private final PersistentMap<String, ThreadState> threads;
    private final PersistentMap<String, String> locks;
    private final @Nullable String activeThread;
    private final @Nullable FunctionCallEdge entryFunction;
    private final PersistentMap<String, Integer> threadIdsForWitness;

    public ThreadingState() {
        this.threads = PathCopyingPersistentTreeMap.of();
        this.locks = PathCopyingPersistentTreeMap.of();
        this.activeThread = null;
        this.entryFunction = null;
        this.threadIdsForWitness = PathCopyingPersistentTreeMap.of();
    }

    private ThreadingState(PersistentMap<String, ThreadState> pThreads, PersistentMap<String, String> pLocks, String pActiveThread, FunctionCallEdge entryFunction, PersistentMap<String, Integer> pThreadIdsForWitness) {
        this.threads = pThreads;
        this.locks = pLocks;
        this.activeThread = pActiveThread;
        this.entryFunction = entryFunction;
        this.threadIdsForWitness = pThreadIdsForWitness;
    }

    private ThreadingState withThreads(PersistentMap<String, ThreadState> pThreads) {
        return new ThreadingState(pThreads, this.locks, this.activeThread, this.entryFunction, this.threadIdsForWitness);
    }

    private ThreadingState withLocks(PersistentMap<String, String> pLocks) {
        return new ThreadingState(this.threads, pLocks, this.activeThread, this.entryFunction, this.threadIdsForWitness);
    }

    private ThreadingState withThreadIdsForWitness(PersistentMap<String, Integer> pThreadIdsForWitness) {
        return new ThreadingState(this.threads, this.locks, this.activeThread, this.entryFunction, pThreadIdsForWitness);
    }

    public ThreadingState addThreadAndCopy(String id, int num, AbstractState stack, AbstractState loc) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((!this.threads.containsKey((Object)id) ? 1 : 0) != 0, (Object)"thread already exists");
        return this.withThreads((PersistentMap<String, ThreadState>)this.threads.putAndCopy((Object)id, (Object)new ThreadState(loc, stack, num)));
    }

    public ThreadingState updateLocationAndCopy(String id, AbstractState stack, AbstractState loc) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((boolean)this.threads.containsKey((Object)id), (Object)"updating non-existing thread");
        return this.withThreads((PersistentMap<String, ThreadState>)this.threads.putAndCopy((Object)id, (Object)new ThreadState(loc, stack, ((ThreadState)this.threads.get((Object)id)).getNum())));
    }

    public ThreadingState removeThreadAndCopy(String id) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkState((boolean)this.threads.containsKey((Object)id), (String)"leaving non-existing thread: %s", (Object)id);
        return this.withThreads((PersistentMap<String, ThreadState>)this.threads.removeAndCopy((Object)id));
    }

    public Set<String> getThreadIds() {
        return this.threads.keySet();
    }

    public AbstractState getThreadCallstack(String id) {
        return (AbstractState)Preconditions.checkNotNull((Object)((ThreadState)this.threads.get((Object)id)).getCallstack());
    }

    public LocationState getThreadLocation(String id) {
        return (LocationState)Preconditions.checkNotNull((Object)((ThreadState)this.threads.get((Object)id)).getLocation());
    }

    Set<Integer> getThreadNums() {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (ThreadState ts : this.threads.values()) {
            result.add(ts.getNum());
        }
        Preconditions.checkState((result.size() == this.threads.size() ? 1 : 0) != 0);
        return result;
    }

    int getSmallestMissingThreadNum() {
        int num = 0;
        Set<Integer> threadNums = this.getThreadNums();
        while (threadNums.contains(num)) {
            ++num;
        }
        return num;
    }

    public ThreadingState addLockAndCopy(String threadId, String lockId) {
        Preconditions.checkNotNull((Object)lockId);
        Preconditions.checkNotNull((Object)threadId);
        Preconditions.checkArgument((boolean)this.threads.containsKey((Object)threadId), (String)"blocking non-existant thread: %s with lock: %s", (Object)threadId, (Object)lockId);
        return this.withLocks((PersistentMap<String, String>)this.locks.putAndCopy((Object)lockId, (Object)threadId));
    }

    public ThreadingState removeLockAndCopy(String threadId, String lockId) {
        Preconditions.checkNotNull((Object)threadId);
        Preconditions.checkNotNull((Object)lockId);
        Preconditions.checkArgument((boolean)this.threads.containsKey((Object)threadId), (String)"unblocking non-existant thread: %s with lock: %s", (Object)threadId, (Object)lockId);
        return this.withLocks((PersistentMap<String, String>)this.locks.removeAndCopy((Object)lockId));
    }

    public boolean hasLock(String lockId) {
        return this.locks.containsKey((Object)lockId);
    }

    public boolean hasLock(String threadId, String lockId) {
        return this.locks.containsKey((Object)lockId) && threadId.equals(this.locks.get((Object)lockId));
    }

    public boolean hasLockForThread(String threadId) {
        return this.locks.containsValue((Object)threadId);
    }

    public Set<String> getLocksForThread(String threadId) {
        return FluentIterable.from((Iterable)this.locks.entrySet()).filter(entry -> ((String)entry.getValue()).equals(threadId)).transform(Map.Entry::getKey).toSet();
    }

    @Override
    public String toString() {
        return "( threads={\n" + Joiner.on((String)",\n ").withKeyValueSeparator("=").join(this.threads) + "}\n and locks={" + Joiner.on((String)",\n ").withKeyValueSeparator("=").join(this.locks) + "}" + (String)(this.activeThread == null ? "" : "\n produced from thread " + this.activeThread) + " \n" + Joiner.on((String)",\n ").withKeyValueSeparator("=").join(this.threadIdsForWitness) + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ThreadingState)) {
            return false;
        }
        ThreadingState ts = (ThreadingState)other;
        return this.threads.equals(ts.threads) && this.locks.equals(ts.locks) && Objects.equals(this.activeThread, ts.activeThread) && this.threadIdsForWitness.equals(ts.threadIdsForWitness);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.threads, this.locks, this.activeThread, this.threadIdsForWitness);
    }

    private FluentIterable<AbstractStateWithLocations> getLocations() {
        return FluentIterable.from((Iterable)this.threads.values()).transform(s -> (AbstractStateWithLocations)s.getLocation());
    }

    @Override
    public Iterable<CFANode> getLocationNodes() {
        return this.getLocations().transformAndConcat(AbstractStateWithLocations::getLocationNodes);
    }

    @Override
    public Iterable<CFAEdge> getOutgoingEdges() {
        return this.getLocations().transformAndConcat(AbstractStateWithLocations::getOutgoingEdges);
    }

    @Override
    public Iterable<CFAEdge> getIngoingEdges() {
        return this.getLocations().transformAndConcat(AbstractStateWithLocations::getIngoingEdges);
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Joiner.on((String)",\n ").withKeyValueSeparator("=").appendTo(sb, this.threads);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public Object getPartitionKey() {
        return this.threads;
    }

    @Override
    public String getCPAName() {
        return "ThreadingCPA";
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        if (PROPERTY_DEADLOCK.equals(pProperty)) {
            try {
                return this.hasDeadlock();
            }
            catch (UnrecognizedCodeException e) {
                throw new InvalidQueryException("deadlock-check had a problem", e);
            }
        }
        throw new InvalidQueryException("Query '" + pProperty + "' is invalid.");
    }

    private boolean hasDeadlock() throws UnrecognizedCodeException {
        FluentIterable edges = FluentIterable.from(this.getOutgoingEdges());
        if (edges.isEmpty()) {
            return false;
        }
        for (CFAEdge edge : edges) {
            if (this.needsAlreadyUsedLock(edge) || this.isWaitingForOtherThread(edge)) continue;
            return false;
        }
        return true;
    }

    private boolean needsAlreadyUsedLock(CFAEdge edge) throws UnrecognizedCodeException {
        String newLock = ThreadingTransferRelation.getLockId(edge);
        return newLock != null && this.hasLock(newLock);
    }

    private boolean isWaitingForOtherThread(CFAEdge edge) throws UnrecognizedCodeException {
        String joiningThread;
        String functionName;
        AExpression functionNameExp;
        AStatement statement;
        return edge.getEdgeType() == CFAEdgeType.StatementEdge && (statement = ((AStatementEdge)edge).getStatement()) instanceof AFunctionCall && (functionNameExp = ((AFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression()) instanceof AIdExpression && "pthread_join".equals(functionName = ((AIdExpression)functionNameExp).getName()) && this.threads.containsKey((Object)(joiningThread = ThreadingTransferRelation.extractParamName(statement, 0))) && !ThreadingTransferRelation.isLastNodeOfThread(this.getThreadLocation(joiningThread).getLocationNode());
    }

    public ThreadingState withActiveThread(@Nullable String pActiveThread) {
        return new ThreadingState(this.threads, this.locks, pActiveThread, this.entryFunction, this.threadIdsForWitness);
    }

    String getActiveThread() {
        return this.activeThread;
    }

    public ThreadingState withEntryFunction(@Nullable FunctionCallEdge pEntryFunction) {
        return new ThreadingState(this.threads, this.locks, this.activeThread, pEntryFunction, this.threadIdsForWitness);
    }

    public @Nullable FunctionCallEdge getEntryFunction() {
        return this.entryFunction;
    }

    @Nullable Integer getThreadIdForWitness(String threadId) {
        Preconditions.checkNotNull((Object)threadId);
        return (Integer)this.threadIdsForWitness.get((Object)threadId);
    }

    boolean hasWitnessIdForThread(int witnessId) {
        return this.threadIdsForWitness.containsValue((Object)witnessId);
    }

    ThreadingState setThreadIdForWitness(String threadId, int witnessId) {
        Preconditions.checkNotNull((Object)threadId);
        Preconditions.checkArgument((!this.threadIdsForWitness.containsKey((Object)threadId) ? 1 : 0) != 0, (Object)"threadId already exists");
        Preconditions.checkArgument((!this.threadIdsForWitness.containsValue((Object)witnessId) ? 1 : 0) != 0, (Object)"witnessId already exists");
        return this.withThreadIdsForWitness((PersistentMap<String, Integer>)this.threadIdsForWitness.putAndCopy((Object)threadId, (Object)witnessId));
    }

    ThreadingState removeThreadIdForWitness(String threadId) {
        Preconditions.checkNotNull((Object)threadId);
        Preconditions.checkArgument((boolean)this.threadIdsForWitness.containsKey((Object)threadId), (String)"removing non-existant thread: %s", (Object)threadId);
        return this.withThreadIdsForWitness((PersistentMap<String, Integer>)this.threadIdsForWitness.removeAndCopy((Object)threadId));
    }

    private static class ThreadState {
        private final AbstractState location;
        private final CallstackStateEqualsWrapper callstack;
        private final int num;

        ThreadState(AbstractState pLocation, AbstractState pCallstack, int pNum) {
            this.location = pLocation;
            this.callstack = new CallstackStateEqualsWrapper((CallstackState)pCallstack);
            this.num = pNum;
        }

        public AbstractState getLocation() {
            return this.location;
        }

        public AbstractState getCallstack() {
            return this.callstack.getState();
        }

        public int getNum() {
            return this.num;
        }

        public String toString() {
            return this.location + " " + this.callstack + " @@ " + this.num;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ThreadState)) {
                return false;
            }
            ThreadState other = (ThreadState)o;
            return this.location.equals(other.location) && this.callstack.equals(other.callstack) && this.num == other.num;
        }

        public int hashCode() {
            return Objects.hash(this.location, this.callstack, this.num);
        }
    }
}

