/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.threading;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Optionals;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.CFACloner;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.cpa.threading.GlobalAccessChecker;
import org.sosy_lab.cpachecker.cpa.threading.ThreadingState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;

@Options(prefix="cpa.threading")
public final class ThreadingTransferRelation
extends SingleEdgeTransferRelation {
    @Option(description="do not use the original functions from the CFA, but cloned ones. See cfa.postprocessing.CFACloner for detail.", secure=true)
    private boolean useClonedFunctions = true;
    @Option(description="allow assignments of a new thread to the same left-hand-side as an existing thread.", secure=true)
    private boolean allowMultipleLHS = false;
    @Option(description="the maximal number of parallel threads, -1 for infinite. When combined with 'useClonedFunctions=true', we need at least N cloned functions. The option 'cfa.cfaCloner.numberOfCopies' should be set to N.", secure=true)
    private int maxNumberOfThreads = 5;
    @Option(description="atomic locks are used to simulate atomic statements, as described in the rules of SV-Comp.", secure=true)
    private boolean useAtomicLocks = true;
    @Option(description="local access locks are used to avoid expensive interleaving, if a thread only reads and writes its own variables.", secure=true)
    private boolean useLocalAccessLocks = true;
    @Option(description="in case of witness validation we need to check all possible function calls of cloned CFAs.", secure=true)
    private boolean useAllPossibleClones = false;
    public static final String THREAD_START = "pthread_create";
    public static final String THREAD_JOIN = "pthread_join";
    private static final String THREAD_EXIT = "pthread_exit";
    private static final String THREAD_MUTEX_LOCK = "pthread_mutex_lock";
    private static final String THREAD_MUTEX_UNLOCK = "pthread_mutex_unlock";
    private static final String VERIFIER_ATOMIC = "__VERIFIER_atomic_";
    private static final String VERIFIER_ATOMIC_BEGIN = "__VERIFIER_atomic_begin";
    private static final String VERIFIER_ATOMIC_END = "__VERIFIER_atomic_end";
    private static final String ATOMIC_LOCK = "__CPAchecker_atomic_lock__";
    public static final String LOCAL_ACCESS_LOCK = "__CPAchecker_local_access_lock__";
    private static final String THREAD_ID_SEPARATOR = "__CPAchecker__";
    private static final ImmutableSet<String> UNSUPPORTED_THREAD_FUNCTIONS = ImmutableSet.of((Object)"pthread_cond_wait", (Object)"pthread_cond_timedwait");
    private static final ImmutableSet<String> THREAD_FUNCTIONS = ImmutableSet.of((Object)"pthread_create", (Object)"pthread_mutex_lock", (Object)"pthread_mutex_unlock", (Object)"pthread_join", (Object)"pthread_exit", (Object)"__VERIFIER_atomic_begin", (Object[])new String[]{"__VERIFIER_atomic_end"});
    private final CFA cfa;
    private final LogManagerWithoutDuplicates logger;
    private final CallstackCPA callstackCPA;
    private final ConfigurableProgramAnalysis locationCPA;
    private final GlobalAccessChecker globalAccessChecker = new GlobalAccessChecker();

    public ThreadingTransferRelation(Configuration pConfig, CFA pCfa, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        this.locationCPA = LocationCPA.create(pCfa, pConfig);
        this.callstackCPA = new CallstackCPA(pConfig, pLogger);
        this.logger = new LogManagerWithoutDuplicates(pLogger);
    }

    public Collection<ThreadingState> getAbstractSuccessorsForEdge(AbstractState pState, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        Preconditions.checkNotNull((Object)cfaEdge);
        ThreadingState state = (ThreadingState)pState;
        ThreadingState threadingState = this.exitThreads(state);
        String activeThread = this.getActiveThread(cfaEdge, threadingState);
        if (null == activeThread) {
            return ImmutableSet.of();
        }
        if (this.useAtomicLocks && threadingState.hasLock(ATOMIC_LOCK) && !threadingState.hasLock(activeThread, ATOMIC_LOCK)) {
            return ImmutableSet.of();
        }
        if (this.useLocalAccessLocks && (threadingState = this.handleLocalAccessLock(cfaEdge, threadingState, activeThread)) == null) {
            return ImmutableSet.of();
        }
        if (this.isEndOfMainFunction(cfaEdge) || ThreadingTransferRelation.isTerminatingEdge(cfaEdge)) {
            return ImmutableSet.of();
        }
        Collection results = this.getAbstractSuccessorsFromWrappedCPAs(activeThread, threadingState, precision, cfaEdge);
        results = this.getAbstractSuccessorsForEdge0(cfaEdge, threadingState, activeThread, results);
        results = Collections2.transform(results, ts -> ts.withActiveThread(activeThread));
        return ImmutableList.copyOf((Collection)results);
    }

    private @Nullable String getActiveThread(CFAEdge cfaEdge, ThreadingState threadingState) {
        HashSet<String> activeThreads = new HashSet<String>();
        for (String id : threadingState.getThreadIds()) {
            if (!Iterables.contains(threadingState.getThreadLocation(id).getOutgoingEdges(), (Object)cfaEdge)) continue;
            activeThreads.add(id);
        }
        assert (activeThreads.size() <= 1) : "multiple active threads are not allowed: " + activeThreads;
        return activeThreads.isEmpty() ? null : (String)Iterables.getOnlyElement(activeThreads);
    }

    private Collection<ThreadingState> getAbstractSuccessorsForEdge0(CFAEdge cfaEdge, ThreadingState threadingState, String activeThread, Collection<ThreadingState> results) throws UnrecognizedCodeException, InterruptedException {
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                AStatement statement = ((AStatementEdge)cfaEdge).getStatement();
                if (!(statement instanceof AFunctionCall)) break;
                AExpression functionNameExp = ((AFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression();
                if (functionNameExp instanceof AIdExpression) {
                    String functionName = ((AIdExpression)functionNameExp).getName();
                    if (UNSUPPORTED_THREAD_FUNCTIONS.contains((Object)functionName)) {
                        throw new UnsupportedCodeException("pthread condition variables", cfaEdge);
                    }
                    switch (functionName) {
                        case "pthread_create": {
                            return this.startNewThread(threadingState, statement, results, cfaEdge);
                        }
                        case "pthread_mutex_lock": {
                            return this.addLock(threadingState, activeThread, ThreadingTransferRelation.extractLockId(statement), results);
                        }
                        case "pthread_mutex_unlock": {
                            return this.removeLock(activeThread, ThreadingTransferRelation.extractLockId(statement), results);
                        }
                        case "pthread_join": {
                            return this.joinThread(threadingState, statement, results);
                        }
                        case "pthread_exit": {
                            break;
                        }
                        case "__VERIFIER_atomic_begin": {
                            if (!this.useAtomicLocks) break;
                            return this.addLock(threadingState, activeThread, ATOMIC_LOCK, results);
                        }
                        case "__VERIFIER_atomic_end": {
                            if (!this.useAtomicLocks) break;
                            return this.removeLock(activeThread, ATOMIC_LOCK, results);
                        }
                    }
                }
                break;
            }
            case FunctionCallEdge: {
                if (!this.useAtomicLocks) break;
                String calledFunction = cfaEdge.getSuccessor().getFunctionName();
                if (calledFunction.startsWith(VERIFIER_ATOMIC_BEGIN)) {
                    return this.addLock(threadingState, activeThread, ATOMIC_LOCK, results);
                }
                if (!calledFunction.startsWith(VERIFIER_ATOMIC) || calledFunction.startsWith(VERIFIER_ATOMIC_END)) break;
                return this.addLock(threadingState, activeThread, ATOMIC_LOCK, results);
            }
            case FunctionReturnEdge: {
                if (!this.useAtomicLocks) break;
                String exitedFunction = cfaEdge.getPredecessor().getFunctionName();
                if (exitedFunction.startsWith(VERIFIER_ATOMIC_END)) {
                    return this.removeLock(activeThread, ATOMIC_LOCK, results);
                }
                if (!exitedFunction.startsWith(VERIFIER_ATOMIC) || exitedFunction.startsWith(VERIFIER_ATOMIC_BEGIN)) break;
                return this.removeLock(activeThread, ATOMIC_LOCK, results);
            }
        }
        return results;
    }

    private Collection<ThreadingState> getAbstractSuccessorsFromWrappedCPAs(String activeThread, ThreadingState threadingState, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        Collection<? extends AbstractState> newLocs = this.locationCPA.getTransferRelation().getAbstractSuccessorsForEdge(threadingState.getThreadLocation(activeThread), precision, cfaEdge);
        Collection<? extends AbstractState> newStacks = this.callstackCPA.getTransferRelation().getAbstractSuccessorsForEdge(threadingState.getThreadCallstack(activeThread), precision, cfaEdge);
        ArrayList<ThreadingState> results = new ArrayList<ThreadingState>();
        for (AbstractState abstractState : newLocs) {
            for (AbstractState abstractState2 : newStacks) {
                results.add(threadingState.updateLocationAndCopy(activeThread, abstractState2, abstractState));
            }
        }
        return results;
    }

    public static boolean isLastNodeOfThread(CFANode node) {
        if (0 == node.getNumLeavingEdges()) {
            return true;
        }
        if (1 == node.getNumEnteringEdges()) {
            return ThreadingTransferRelation.isThreadExit(node.getEnteringEdge(0));
        }
        return false;
    }

    private static boolean isThreadExit(CFAEdge cfaEdge) {
        AExpression functionNameExp;
        AStatement statement;
        if (CFAEdgeType.StatementEdge == cfaEdge.getEdgeType() && (statement = ((AStatementEdge)cfaEdge).getStatement()) instanceof AFunctionCall && (functionNameExp = ((AFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression()) instanceof AIdExpression) {
            return THREAD_EXIT.equals(((AIdExpression)functionNameExp).getName());
        }
        return false;
    }

    private static boolean isTerminatingEdge(CFAEdge edge) {
        return edge.getSuccessor() instanceof CFATerminationNode;
    }

    private boolean isEndOfMainFunction(CFAEdge edge) {
        return Objects.equals(this.cfa.getMainFunction().getExitNode(), edge.getSuccessor());
    }

    private ThreadingState exitThreads(ThreadingState tmp) {
        for (String id : tmp.getThreadIds()) {
            if (!ThreadingTransferRelation.isLastNodeOfThread(tmp.getThreadLocation(id).getLocationNode())) continue;
            tmp = this.removeThreadId(tmp, id);
        }
        return tmp;
    }

    private ThreadingState removeThreadId(ThreadingState ts, String id) {
        if (this.useLocalAccessLocks) {
            ts = ts.removeLockAndCopy(id, LOCAL_ACCESS_LOCK);
        }
        if (ts.hasLockForThread(id)) {
            this.logger.log(Level.WARNING, new Object[]{"dying thread", id, "has remaining locks in state", ts});
        }
        return ts.removeThreadAndCopy(id);
    }

    private Collection<ThreadingState> startNewThread(ThreadingState threadingState, AStatement statement, Collection<ThreadingState> results, CFAEdge cfaEdge) throws UnrecognizedCodeException, InterruptedException {
        List<? extends AExpression> params = ((AFunctionCall)statement).getFunctionCallExpression().getParameterExpressions();
        if (!(params.get(0) instanceof CUnaryExpression)) {
            throw new UnrecognizedCodeException("unsupported thread assignment", params.get(0));
        }
        if (!(params.get(2) instanceof CUnaryExpression)) {
            throw new UnrecognizedCodeException("unsupported thread function call", params.get(2));
        }
        CExpression expr0 = ((CUnaryExpression)params.get(0)).getOperand();
        CExpression expr2 = ((CUnaryExpression)params.get(2)).getOperand();
        if (!(expr0 instanceof CIdExpression)) {
            throw new UnrecognizedCodeException("unsupported thread assignment", expr0);
        }
        if (!(expr2 instanceof CIdExpression)) {
            throw new UnrecognizedCodeException("unsupported thread function call", expr2);
        }
        if (!(params.get(3) instanceof CExpression)) {
            throw new UnrecognizedCodeException("unsupported thread function argument", params.get(3));
        }
        CIdExpression id = (CIdExpression)expr0;
        CIdExpression function = (CIdExpression)expr2;
        CExpression threadArg = (CExpression)params.get(3);
        if (this.useAllPossibleClones) {
            ArrayList<ThreadingState> newResults = new ArrayList<ThreadingState>();
            Set<Integer> usedNumbers = threadingState.getThreadNums();
            for (int i = 0; i < this.maxNumberOfThreads; ++i) {
                if (usedNumbers.contains(i)) continue;
                newResults.addAll(this.createThreadWithNumber(threadingState, id, cfaEdge, function, threadArg, i, results));
            }
            return newResults;
        }
        int newThreadNum = threadingState.getSmallestMissingThreadNum();
        return this.createThreadWithNumber(threadingState, id, cfaEdge, function, threadArg, newThreadNum, results);
    }

    private Collection<ThreadingState> createThreadWithNumber(ThreadingState threadingState, CIdExpression id, CFAEdge cfaEdge, CIdExpression function, CExpression threadArg, int newThreadNum, Collection<ThreadingState> results) throws UnrecognizedCodeException, InterruptedException {
        String functionName = function.getName();
        if (this.useClonedFunctions) {
            functionName = CFACloner.getFunctionName(functionName, newThreadNum);
        }
        String threadId = this.getNewThreadId(threadingState, id.getName());
        ArrayList<ThreadingState> newResults = new ArrayList<ThreadingState>();
        for (ThreadingState ts : results) {
            ThreadingState newThreadingState = this.addNewThread(ts, threadId, newThreadNum, functionName);
            if (null == newThreadingState) continue;
            CFunctionCallEdge functionCall = this.createThreadEntryFunctionCall(cfaEdge, function.getExpressionType(), functionName, threadArg);
            newResults.add(newThreadingState.withEntryFunction(functionCall));
        }
        return newResults;
    }

    private CFunctionCallEdge createThreadEntryFunctionCall(CFAEdge cfaEdge, CType type, String functionName, CExpression arg) {
        CFunctionEntryNode functioncallNode = (CFunctionEntryNode)Preconditions.checkNotNull((Object)this.cfa.getFunctionHead(functionName), (Object)("Function '" + functionName + "' was not found. Please enable cloning for the CFA!"));
        CFunctionDeclaration functionDeclaration = (CFunctionDeclaration)functioncallNode.getFunction();
        CIdExpression functionId = new CIdExpression(cfaEdge.getFileLocation(), type, functionName, functionDeclaration);
        CFunctionCallExpression functionCallExpr = new CFunctionCallExpression(cfaEdge.getFileLocation(), type, functionId, (List<CExpression>)ImmutableList.of((Object)arg), functionDeclaration);
        CFunctionCallStatement functionCall = new CFunctionCallStatement(cfaEdge.getFileLocation(), functionCallExpr);
        CFunctionCallEdge edge = new CFunctionCallEdge(functionCallExpr.toASTString(), cfaEdge.getFileLocation(), cfaEdge.getSuccessor(), functioncallNode, functionCall, null);
        return edge;
    }

    @Nullable ThreadingState addNewThread(ThreadingState threadingState, String threadId, int newThreadNum, String functionName) throws InterruptedException {
        CFANode functioncallNode = (CFANode)Preconditions.checkNotNull((Object)this.cfa.getFunctionHead(functionName), (Object)("Function '" + functionName + "' was not found. Please enable cloning for the CFA!"));
        AbstractState initialStack = this.callstackCPA.getInitialState(functioncallNode, StateSpacePartition.getDefaultPartition());
        AbstractState initialLoc = this.locationCPA.getInitialState(functioncallNode, StateSpacePartition.getDefaultPartition());
        if (this.maxNumberOfThreads == -1 || threadingState.getThreadIds().size() < this.maxNumberOfThreads) {
            threadingState = threadingState.addThreadAndCopy(threadId, newThreadNum, initialStack, initialLoc);
            return threadingState;
        }
        this.logger.logfOnce(Level.WARNING, "number of threads is limited, cannot create thread %s", new Object[]{threadId});
        return null;
    }

    private String getNewThreadId(ThreadingState threadingState, String threadId) throws UnrecognizedCodeException {
        if (!this.allowMultipleLHS && threadingState.getThreadIds().contains(threadId)) {
            throw new UnrecognizedCodeException("multiple thread assignments to same LHS not supported: " + threadId, null, null);
        }
        Object newThreadId = threadId;
        int index = 0;
        while (threadingState.getThreadIds().contains(newThreadId) && (this.maxNumberOfThreads == -1 || index < this.maxNumberOfThreads)) {
            newThreadId = threadId + THREAD_ID_SEPARATOR + ++index;
            this.logger.logfOnce(Level.WARNING, "multiple thread assignments to same LHS, using identifier %s instead of %s", new Object[]{newThreadId, threadId});
        }
        return newThreadId;
    }

    private Collection<ThreadingState> addLock(ThreadingState threadingState, String activeThread, String lockId, Collection<ThreadingState> results) {
        if (threadingState.hasLock(lockId)) {
            return ImmutableSet.of();
        }
        return Collections2.transform(results, ts -> ts.addLockAndCopy(activeThread, lockId));
    }

    static @Nullable String getLockId(CFAEdge cfaEdge) throws UnrecognizedCodeException {
        String functionName;
        AExpression functionNameExp;
        AStatement statement;
        if (cfaEdge.getEdgeType() == CFAEdgeType.StatementEdge && (statement = ((AStatementEdge)cfaEdge).getStatement()) instanceof AFunctionCall && (functionNameExp = ((AFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression()) instanceof AIdExpression && THREAD_MUTEX_LOCK.equals(functionName = ((AIdExpression)functionNameExp).getName())) {
            return ThreadingTransferRelation.extractLockId(statement);
        }
        return null;
    }

    private static String extractLockId(AStatement statement) throws UnrecognizedCodeException {
        CExpression subscriptExpression;
        List<? extends AExpression> params = ((AFunctionCall)statement).getFunctionCallExpression().getParameterExpressions();
        if (!(params.get(0) instanceof CUnaryExpression)) {
            throw new UnrecognizedCodeException("unsupported thread locking", params.get(0));
        }
        CExpression operand = ((CUnaryExpression)params.get(0)).getOperand();
        if (operand instanceof CArraySubscriptExpression && !((subscriptExpression = ((CArraySubscriptExpression)operand).getSubscriptExpression()) instanceof ALiteralExpression)) {
            throw new UnrecognizedCodeException("unsupported thread lock assignment", params.get(0));
        }
        String lockId = ((CUnaryExpression)params.get(0)).getOperand().toString();
        return lockId;
    }

    private Collection<ThreadingState> removeLock(String activeThread, String lockId, Collection<ThreadingState> results) {
        return Collections2.transform(results, ts -> ts.removeLockAndCopy(activeThread, lockId));
    }

    private Collection<ThreadingState> joinThread(ThreadingState threadingState, AStatement statement, Collection<ThreadingState> results) throws UnrecognizedCodeException {
        if (threadingState.getThreadIds().contains(ThreadingTransferRelation.extractParamName(statement, 0))) {
            return ImmutableSet.of();
        }
        return results;
    }

    static String extractParamName(AStatement statement, int n) throws UnrecognizedCodeException {
        List<? extends AExpression> params = ((AFunctionCall)statement).getFunctionCallExpression().getParameterExpressions();
        AExpression expr = params.get(n);
        if (!(expr instanceof CIdExpression)) {
            throw new UnrecognizedCodeException("unsupported thread join access", expr);
        }
        return ((CIdExpression)expr).getName();
    }

    private @Nullable ThreadingState handleLocalAccessLock(CFAEdge cfaEdge, ThreadingState threadingState, String activeThread) {
        boolean isImporantForThreading;
        if (threadingState.hasLock(LOCAL_ACCESS_LOCK) && !threadingState.hasLock(activeThread, LOCAL_ACCESS_LOCK)) {
            return null;
        }
        boolean bl = isImporantForThreading = this.globalAccessChecker.hasGlobalAccess(cfaEdge) || ThreadingTransferRelation.isImporantForThreading(cfaEdge);
        if (isImporantForThreading) {
            return threadingState.removeLockAndCopy(activeThread, LOCAL_ACCESS_LOCK);
        }
        return threadingState.addLockAndCopy(activeThread, LOCAL_ACCESS_LOCK);
    }

    private static boolean isImporantForThreading(CFAEdge cfaEdge) {
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                AExpression functionNameExp;
                AStatement statement = ((AStatementEdge)cfaEdge).getStatement();
                if (statement instanceof AFunctionCall && (functionNameExp = ((AFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression()) instanceof AIdExpression) {
                    return THREAD_FUNCTIONS.contains((Object)((AIdExpression)functionNameExp).getName());
                }
                return false;
            }
            case FunctionCallEdge: {
                return cfaEdge.getSuccessor().getFunctionName().startsWith(VERIFIER_ATOMIC);
            }
            case FunctionReturnEdge: {
                return cfaEdge.getPredecessor().getFunctionName().startsWith(VERIFIER_ATOMIC);
            }
        }
        return false;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState state, Iterable<AbstractState> otherStates, @Nullable CFAEdge cfaEdge, Precision precision) throws CPATransferException, InterruptedException {
        Optional<ThreadingState> results = Optional.of((ThreadingState)state);
        for (AutomatonState automatonState : AbstractStates.projectToType(otherStates, AutomatonState.class)) {
            if (!"WitnessAutomaton".equals(automatonState.getOwningAutomatonName())) continue;
            results = results.map(ts -> this.handleWitnessAutomaton((ThreadingState)ts, automatonState));
        }
        return Optionals.asSet(results.map(ts -> ts.withActiveThread(null).withEntryFunction(null)));
    }

    private @Nullable ThreadingState handleWitnessAutomaton(ThreadingState ts, AutomatonState automatonState) {
        Map<String, AutomatonVariable> vars = automatonState.getVars();
        AutomatonVariable witnessThreadId = vars.get(AutomatonGraphmlCommon.KeyDef.THREADID.toString().toUpperCase());
        String threadId = ts.getActiveThread();
        if (witnessThreadId == null || threadId == null || witnessThreadId.getValue() == 0) {
            return ts;
        }
        Integer witnessId = ts.getThreadIdForWitness(threadId);
        if (witnessId == null) {
            if (ts.hasWitnessIdForThread(witnessThreadId.getValue())) {
                return ts;
            }
            return ts.setThreadIdForWitness(threadId, witnessThreadId.getValue());
        }
        if (witnessId.equals(witnessThreadId.getValue())) {
            return ts;
        }
        return ts;
    }

    public static Optional<String> getCreatedThreadFunction(CFAEdge edge) throws UnrecognizedCodeException {
        String functionName;
        AExpression functionNameExp;
        AStatement statement;
        if (edge instanceof AStatementEdge && (statement = ((AStatementEdge)edge).getStatement()) instanceof AFunctionCall && (functionNameExp = ((AFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression()) instanceof AIdExpression && THREAD_START.equals(functionName = ((AIdExpression)functionNameExp).getName())) {
            List<? extends AExpression> params = ((AFunctionCall)statement).getFunctionCallExpression().getParameterExpressions();
            if (!(params.get(2) instanceof CUnaryExpression)) {
                throw new UnrecognizedCodeException("unsupported thread function call", params.get(2));
            }
            CExpression expr2 = ((CUnaryExpression)params.get(2)).getOperand();
            if (!(expr2 instanceof CIdExpression)) {
                throw new UnrecognizedCodeException("unsupported thread function call", expr2);
            }
            String newThreadFunctionName = ((CIdExpression)expr2).getName();
            return Optional.of(newThreadFunctionName);
        }
        return Optional.empty();
    }
}

