/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.traceabstraction;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.traceabstraction.IndexedAbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;

class InterpolationSequence {
    private final ImmutableSortedSet<IndexedAbstractionPredicate> orderedPredicates;
    private final ImmutableSetMultimap<CFANode, IndexedAbstractionPredicate> localPredicates;

    private InterpolationSequence(NavigableSet<IndexedAbstractionPredicate> pNavigablePredicates, Multimap<CFANode, IndexedAbstractionPredicate> pLocalPredicates) {
        this.orderedPredicates = ImmutableSortedSet.copyOfSorted(pNavigablePredicates);
        this.localPredicates = ImmutableSetMultimap.copyOf(pLocalPredicates);
    }

    private ImmutableSet<IndexedAbstractionPredicate> getPredicates(PredicatePrecision.LocationInstance pLocationInstance) {
        return this.localPredicates.get((Object)pLocationInstance.getLocation());
    }

    boolean isInScopeOf(PredicatePrecision.LocationInstance pLocationInstance) {
        return !this.getPredicates(pLocationInstance).isEmpty();
    }

    Optional<IndexedAbstractionPredicate> getFirst(PredicatePrecision.LocationInstance PLocationInstance) {
        return this.getPredicates(PLocationInstance).stream().findFirst();
    }

    Optional<IndexedAbstractionPredicate> getNextIndex(IndexedAbstractionPredicate pPredicate) {
        return Optional.ofNullable((IndexedAbstractionPredicate)this.orderedPredicates.higher((Object)pPredicate));
    }

    Optional<IndexedAbstractionPredicate> getNextPredicate(IndexedAbstractionPredicate pPredicate) {
        IndexedAbstractionPredicate nextPred;
        IndexedAbstractionPredicate curPred = pPredicate;
        while (true) {
            if ((nextPred = (IndexedAbstractionPredicate)this.orderedPredicates.higher((Object)curPred)) == null) {
                return Optional.empty();
            }
            if (!pPredicate.getPredicate().equals(nextPred.getPredicate())) break;
            curPred = nextPred;
        }
        return Optional.of(nextPred);
    }

    boolean isStrictSubsetOf(InterpolationSequence pOtherSequence) {
        if (this.equals(pOtherSequence)) {
            return false;
        }
        return this.convertedPredicates((ImmutableSet<Map.Entry<CFANode, IndexedAbstractionPredicate>>)pOtherSequence.localPredicates.entries()).containsAll(this.convertedPredicates((ImmutableSet<Map.Entry<CFANode, IndexedAbstractionPredicate>>)this.localPredicates.entries()));
    }

    private ImmutableSet<Map.Entry<CFANode, AbstractionPredicate>> convertedPredicates(ImmutableSet<Map.Entry<CFANode, IndexedAbstractionPredicate>> entries) {
        return Collections3.transformedImmutableSetCopy(entries, x -> Map.entry((CFANode)x.getKey(), ((IndexedAbstractionPredicate)x.getValue()).getPredicate()));
    }

    public int hashCode() {
        return Objects.hash(this.orderedPredicates, this.localPredicates);
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (!(pObj instanceof InterpolationSequence)) {
            return false;
        }
        InterpolationSequence other = (InterpolationSequence)pObj;
        return Objects.equals(this.orderedPredicates, other.orderedPredicates) && Objects.equals(this.localPredicates, other.localPredicates);
    }

    public String toString() {
        return Joiner.on((String)"\n").join((Iterable)this.localPredicates.entries());
    }

    static class Builder {
        private static final UniqueIdGenerator ID_GENERATOR = new UniqueIdGenerator();
        private final NavigableSet<IndexedAbstractionPredicate> navigablePredicates = new TreeSet<IndexedAbstractionPredicate>();
        private final Multimap<CFANode, IndexedAbstractionPredicate> localPredicates = MultimapBuilder.treeKeys().hashSetValues().build();
        private final Multimap<CFANode, AbstractionPredicate> localPredCache = HashMultimap.create();

        Builder() {
        }

        @CanIgnoreReturnValue
        Builder addPredicates(PredicatePrecision.LocationInstance pLocInstance, Collection<AbstractionPredicate> pPredicates) {
            for (AbstractionPredicate abstractionPredicate : pPredicates) {
                if (!this.localPredCache.put((Object)pLocInstance.getLocation(), (Object)abstractionPredicate)) continue;
                IndexedAbstractionPredicate indexedPred = new IndexedAbstractionPredicate(ID_GENERATOR.getFreshId(), abstractionPredicate);
                Verify.verify((boolean)this.navigablePredicates.add(indexedPred));
                Verify.verify((boolean)this.localPredicates.put((Object)pLocInstance.getLocation(), (Object)indexedPred));
            }
            return this;
        }

        InterpolationSequence build() {
            return new InterpolationSequence(this.navigablePredicates, this.localPredicates);
        }
    }
}

