/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.traceabstraction;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.traceabstraction.InterpolationSequence;

class InterpolationSequenceStorage {
    private final Set<InterpolationSequence> itpSequences = new HashSet<InterpolationSequence>();
    private final SetMultimap<InterpolationSequence, InterpolationSequence> referenceMap = HashMultimap.create();

    InterpolationSequenceStorage() {
    }

    ImmutableSet<InterpolationSequence> getInterpolationSequences() {
        return ImmutableSet.copyOf(this.itpSequences);
    }

    boolean isEmpty() {
        return this.itpSequences.isEmpty();
    }

    void addItpSequence(InterpolationSequence pNewSequence) {
        Preconditions.checkNotNull((Object)pNewSequence);
        InterpolationSequence subset = this.tryFindSubset(pNewSequence);
        if (subset != null) {
            Verify.verify((boolean)this.itpSequences.remove(subset));
            this.referenceMap.put((Object)subset, (Object)pNewSequence);
            this.updateReferenceMap(subset, pNewSequence);
        }
        this.itpSequences.add(pNewSequence);
    }

    private void updateReferenceMap(InterpolationSequence pSubset, InterpolationSequence pNewSequence) {
        SetMultimap invertedReferences = (SetMultimap)Multimaps.invertFrom(this.referenceMap, (Multimap)HashMultimap.create());
        Set sequencesPointingToSubset = invertedReferences.get((Object)pSubset);
        for (InterpolationSequence seq : sequencesPointingToSubset) {
            this.referenceMap.replaceValues((Object)seq, (Iterable)ImmutableSet.of((Object)pNewSequence));
        }
    }

    Optional<InterpolationSequence> getUpdatedItpSequence(InterpolationSequence pOldSequence) {
        return (Optional)this.referenceMap.get((Object)pOldSequence).stream().collect(MoreCollectors.toOptional());
    }

    private InterpolationSequence tryFindSubset(InterpolationSequence pItpSequence) {
        for (InterpolationSequence itpSequence : this.itpSequences) {
            if (!itpSequence.isStrictSubsetOf(pItpSequence)) continue;
            return itpSequence;
        }
        return null;
    }

    ImmutableSet<InterpolationSequence> difference(Set<InterpolationSequence> pOtherSequences) {
        return Sets.difference(this.itpSequences, pOtherSequences).immutableCopy();
    }
}

