/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.traceabstraction;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.MoreStrings;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.traceabstraction.IndexedAbstractionPredicate;
import org.sosy_lab.cpachecker.cpa.traceabstraction.InterpolationSequence;
import org.sosy_lab.cpachecker.cpa.traceabstraction.InterpolationSequenceStorage;
import org.sosy_lab.cpachecker.cpa.traceabstraction.TraceAbstractionState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.SolverException;

class TraceAbstractionPrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment wrappedPrecAdjustment;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final InterpolationSequenceStorage itpSequenceStorage;
    private final PredicateAbstractionManager predicateAbstractionManager;
    private final FormulaManagerView fMgrView;
    private final BooleanFormulaManagerView bFMgrView;
    private final AbstractionManager abstractionManager;

    TraceAbstractionPrecisionAdjustment(PrecisionAdjustment pWrappedPrecAdjustment, FormulaManagerView pFormulaManagerView, PredicateAbstractionManager pPredicateAbstractionManager, AbstractionManager pAbstractionManager, InterpolationSequenceStorage pItpSequenceStorage, LogManager pLogger, ShutdownNotifier pShutdownNotifier) {
        this.wrappedPrecAdjustment = pWrappedPrecAdjustment;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.itpSequenceStorage = pItpSequenceStorage;
        this.fMgrView = pFormulaManagerView;
        this.bFMgrView = pFormulaManagerView.getBooleanFormulaManager();
        this.abstractionManager = pAbstractionManager;
        this.predicateAbstractionManager = pPredicateAbstractionManager;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, Function<AbstractState, AbstractState> pStateProjection, AbstractState pFullState) throws CPAException, InterruptedException {
        TraceAbstractionState result;
        Preconditions.checkArgument((boolean)(pState instanceof TraceAbstractionState));
        Preconditions.checkArgument((boolean)this.checkEmptyPredicatePrecision(pPrecision));
        Preconditions.checkArgument((boolean)(pFullState instanceof ARGState));
        TraceAbstractionState taState = (TraceAbstractionState)pState;
        AbstractState wrappedPredState = (AbstractState)Verify.verifyNotNull((Object)taState.getWrappedState());
        Optional<PrecisionAdjustmentResult> wrappedPrecResult = this.wrappedPrecAdjustment.prec(wrappedPredState, PredicatePrecision.empty(), pStates, pStateProjection, pFullState);
        if (wrappedPrecResult.isEmpty()) {
            return Optional.empty();
        }
        PrecisionAdjustmentResult precisionAdjustmentResult = wrappedPrecResult.orElseThrow();
        AbstractState newWrappedState = precisionAdjustmentResult.abstractState();
        Verify.verify((boolean)(newWrappedState instanceof PredicateAbstractState));
        Verify.verify((boolean)this.checkEmptyPredicatePrecision(precisionAdjustmentResult.precision()));
        PredicateAbstractState predSuccessor = (PredicateAbstractState)newWrappedState;
        if (newWrappedState != wrappedPredState) {
            taState = taState.withWrappedState(predSuccessor);
        }
        if ((result = this.computeTraceAbstractionSuccessor(taState, predSuccessor, (ARGState)pFullState)) == null) {
            return Optional.empty();
        }
        return Optional.of(PrecisionAdjustmentResult.create(result, pPrecision, precisionAdjustmentResult.action()));
    }

    private boolean checkEmptyPredicatePrecision(Precision pPrecision) {
        return pPrecision instanceof PredicatePrecision && pPrecision.equals(PredicatePrecision.empty());
    }

    private @Nullable TraceAbstractionState computeTraceAbstractionSuccessor(TraceAbstractionState pTaState, PredicateAbstractState pPredSuccessor, ARGState pFullState) throws CPATransferException, InterruptedException {
        if (this.itpSequenceStorage.isEmpty() && !pTaState.containsPredicates()) {
            return pTaState;
        }
        AbstractionFormula abstractionFormula = pPredSuccessor.getAbstractionFormula();
        Verify.verify((boolean)abstractionFormula.isTrue(), (String)"AbstractionFormula was modified. This is not expected when using the TraceAbstraction refinement", (Object[])new Object[0]);
        Optional<CallstackStateEqualsWrapper> callstackWrapper = AbstractStates.extractOptionalCallstackWraper(pFullState);
        CFANode curLocation = (CFANode)Verify.verifyNotNull((Object)AbstractStates.extractLocation(pFullState));
        Verify.verify((pFullState.getParents().size() == 1 ? 1 : 0) != 0);
        ARGState parentARGState = (ARGState)Iterables.getOnlyElement(pFullState.getParents());
        CFANode parentLocation = (CFANode)Verify.verifyNotNull((Object)AbstractStates.extractLocation(parentARGState));
        List<CFAEdge> connectingCfaEdges = parentARGState.getEdgesToChild(pFullState);
        this.logger.logf(Level.FINE, "Taking edge: N%s -> N%s // %s\n", new Object[]{parentLocation.getNodeNumber(), curLocation.getNodeNumber(), connectingCfaEdges.stream().map(CFAEdge::getDescription).collect(Collectors.joining("\n"))});
        if (connectingCfaEdges.stream().allMatch(x -> x.getEdgeType() == CFAEdgeType.BlankEdge)) {
            this.logger.logf(Level.FINER, "Edge(s) only consist of blank edges; returning the current TAstate", new Object[0]);
            return pTaState;
        }
        ImmutableMap<InterpolationSequence, IndexedAbstractionPredicate> statePredicates = pTaState.getActivePredicates();
        Integer newLocInstance = (Integer)pPredSuccessor.getAbstractionLocationsOnPath().getOrDefault((Object)curLocation, (Object)0);
        PredicatePrecision.LocationInstance locInstance = new PredicatePrecision.LocationInstance(curLocation, newLocInstance);
        ImmutableMap.Builder itpSequenceMapping = ImmutableMap.builder();
        boolean continueExploring = this.checkTASuccessors((ImmutableMap.Builder<InterpolationSequence, IndexedAbstractionPredicate>)itpSequenceMapping, locInstance, statePredicates, connectingCfaEdges, abstractionFormula, curLocation, parentLocation, callstackWrapper);
        if (!continueExploring) {
            return null;
        }
        this.checkInactivePredicates((ImmutableMap.Builder<InterpolationSequence, IndexedAbstractionPredicate>)itpSequenceMapping, abstractionFormula, callstackWrapper, curLocation, parentLocation, statePredicates, locInstance);
        ImmutableMap newPreds = itpSequenceMapping.buildOrThrow();
        this.logger.logf(Level.FINER, "Active predicates in the next state: %s\n", new Object[]{newPreds});
        return new TraceAbstractionState(pPredSuccessor, (Map<InterpolationSequence, IndexedAbstractionPredicate>)newPreds);
    }

    private boolean checkTASuccessors(ImmutableMap.Builder<InterpolationSequence, IndexedAbstractionPredicate> pItpSequenceMapping, PredicatePrecision.LocationInstance locInstance, ImmutableMap<InterpolationSequence, IndexedAbstractionPredicate> statePredicates, List<CFAEdge> connectingCfaEdges, AbstractionFormula abstractionFormula, CFANode curLocation, CFANode parentLocation, Optional<CallstackStateEqualsWrapper> callstackWrapper) throws CPATransferException, InterruptedException {
        this.logger.log(Level.FINER, new Object[]{"Computing abstractions"});
        for (Map.Entry entry : statePredicates.entrySet()) {
            Optional<InterpolationSequence> updatedItpSequence = this.itpSequenceStorage.getUpdatedItpSequence((InterpolationSequence)entry.getKey());
            InterpolationSequence currentItpSequence = updatedItpSequence.orElse((InterpolationSequence)entry.getKey());
            if (!currentItpSequence.isInScopeOf(locInstance)) continue;
            PathFormula pathFormula = abstractionFormula.getBlockFormula();
            IndexedAbstractionPredicate curPreds = (IndexedAbstractionPredicate)entry.getValue();
            Optional<IndexedAbstractionPredicate> nextPreds = currentItpSequence.getNextPredicate(curPreds);
            ImmutableList precondition = nextPreds.isEmpty() ? ImmutableList.of((Object)curPreds) : ImmutableList.of((Object)curPreds, (Object)nextPreds.orElseThrow());
            BooleanFormula instantiatedFormula = this.fMgrView.instantiate(curPreds.getPredicate().getSymbolicAtom(), abstractionFormula.getBlockFormula().getSsa());
            BooleanFormula resultFormula = this.bFMgrView.and(pathFormula.getFormula(), instantiatedFormula);
            pathFormula = pathFormula.withFormula(resultFormula);
            AbstractionFormula computedPostCondition = this.buildAbstraction((ImmutableSet<CFANode>)ImmutableSet.of((Object)curLocation, (Object)parentLocation), callstackWrapper, abstractionFormula, pathFormula, (ImmutableSet<AbstractionPredicate>)Collections3.transformedImmutableSetCopy((Collection)precondition, IndexedAbstractionPredicate::getPredicate));
            if (computedPostCondition.isTrue()) {
                boolean assignmentMadeForRelevantPred;
                if (connectingCfaEdges.stream().anyMatch(edge -> edge.getEdgeType() == CFAEdgeType.StatementEdge) && (assignmentMadeForRelevantPred = precondition.stream().anyMatch(pred -> this.anyVariableModified(abstractionFormula.getBlockFormula().getSsa(), computedPostCondition.getBlockFormula().getSsa(), this.fMgrView.extractVariableNames((Formula)pred.getPredicate().getSymbolicAtom()))))) continue;
                pItpSequenceMapping.put((Object)currentItpSequence, (Object)curPreds);
                continue;
            }
            if (computedPostCondition.isFalse()) {
                return false;
            }
            if (nextPreds.isPresent() && this.checkPostcondEntailingPrecond(nextPreds.orElseThrow().getPredicate(), computedPostCondition)) {
                pItpSequenceMapping.put((Object)currentItpSequence, (Object)nextPreds.orElseThrow());
                continue;
            }
            if (this.checkPostcondEntailingPrecond(curPreds.getPredicate(), computedPostCondition)) {
                pItpSequenceMapping.put((Object)currentItpSequence, (Object)curPreds);
                continue;
            }
            if (curPreds.getPredicate().getSymbolicAtom().equals(this.bFMgrView.not(computedPostCondition.asFormula()))) {
                if (!nextPreds.isEmpty()) continue;
                this.logger.log(Level.FINEST, new Object[]{"Abstraction is contradictory to current input predicates. The node is not reachable"});
                continue;
            }
            if (nextPreds.isPresent() && nextPreds.orElseThrow().getPredicate().getSymbolicAtom().equals(this.bFMgrView.not(computedPostCondition.asFormula()))) {
                this.logger.log(Level.FINEST, new Object[]{"Abstraction is contradictory to current input predicates. The node is not reachable"});
                return false;
            }
            throw new AssertionError((Object)"Interpolant <false> is following on an interpolant <true>. This is not yet handled");
        }
        return true;
    }

    private void checkInactivePredicates(ImmutableMap.Builder<InterpolationSequence, IndexedAbstractionPredicate> itpSequenceMapping, AbstractionFormula abstractionFormula, Optional<CallstackStateEqualsWrapper> callstackWrapper, CFANode curLocation, CFANode parentLocation, ImmutableMap<InterpolationSequence, IndexedAbstractionPredicate> statePredicates, PredicatePrecision.LocationInstance locInstance) throws InterruptedException, CPATransferException {
        for (InterpolationSequence itpSequence : this.itpSequenceStorage.difference((Set<InterpolationSequence>)statePredicates.keySet())) {
            Optional<IndexedAbstractionPredicate> itpOpt = itpSequence.getFirst(locInstance);
            if (itpOpt.isEmpty()) continue;
            IndexedAbstractionPredicate indexedPred = itpOpt.orElseThrow();
            AbstractionPredicate preconditionPreds = indexedPred.getPredicate();
            AbstractionFormula computedPostCondition = this.buildAbstraction((ImmutableSet<CFANode>)ImmutableSet.of((Object)curLocation, (Object)parentLocation), callstackWrapper, abstractionFormula, abstractionFormula.getBlockFormula(), (ImmutableSet<AbstractionPredicate>)ImmutableSet.of((Object)preconditionPreds));
            if (computedPostCondition.isTrue() || computedPostCondition.isFalse() || !this.checkPostcondEntailingPrecond(preconditionPreds, computedPostCondition)) continue;
            assert (preconditionPreds.getSymbolicAtom().equals(computedPostCondition.asFormula()));
            itpSequenceMapping.put((Object)itpSequence, (Object)indexedPred);
        }
    }

    private boolean checkPostcondEntailingPrecond(AbstractionPredicate precondition, AbstractionFormula computedPostCondition) throws CPATransferException, InterruptedException {
        try {
            return this.abstractionManager.entails(computedPostCondition.asRegion(), precondition.getAbstractVariable());
        }
        catch (SolverException e) {
            throw new CPATransferException(e.getMessage(), e);
        }
    }

    private boolean anyVariableModified(SSAMap ssaParent, SSAMap ssaChild, Set<String> predVariables) {
        for (String variable : predVariables) {
            if (!ssaChild.containsVariable(variable) || !ssaParent.containsVariable(variable) || ssaChild.getIndex(variable) != ssaParent.getIndex(variable) + 1) continue;
            return true;
        }
        return false;
    }

    private AbstractionFormula buildAbstraction(ImmutableSet<CFANode> pCfaNodes, Optional<CallstackStateEqualsWrapper> callstackWrapper, AbstractionFormula abstractionFormula, PathFormula pathFormula, ImmutableSet<AbstractionPredicate> relevantPreds) throws InterruptedException, CPATransferException {
        try {
            this.logger.logf(Level.FINER, "Predicates: %s\n", new Object[]{relevantPreds});
            this.shutdownNotifier.shutdownIfNecessary();
            AbstractionFormula abstractionResult = this.predicateAbstractionManager.buildAbstraction((Collection<CFANode>)pCfaNodes, callstackWrapper, abstractionFormula, pathFormula, (Collection<AbstractionPredicate>)relevantPreds);
            this.logger.logf(Level.FINER, "New abstraction formula: %s\n", new Object[]{abstractionFormula});
            this.printHoareTriple((Collection<AbstractionPredicate>)relevantPreds, abstractionResult);
            this.printRegions(relevantPreds, abstractionResult);
            return abstractionResult;
        }
        catch (SolverException e) {
            throw new CPATransferException("Solver Failure: " + e.getMessage(), e);
        }
    }

    private void printRegions(ImmutableSet<AbstractionPredicate> relevantPreds, AbstractionFormula abstractionResult) throws SolverException, InterruptedException {
        Region regionPost = abstractionResult.asRegion();
        this.logger.log(Level.FINE, new Object[]{MoreStrings.lazyString(() -> String.format("Region Post: %s -- BF: %s%n", regionPost, this.abstractionManager.convertRegionToFormula(regionPost)))});
        for (AbstractionPredicate abstractionPredicate : relevantPreds) {
            Region regionPre = abstractionPredicate.getAbstractVariable();
            this.logger.log(Level.FINE, new Object[]{MoreStrings.lazyString(() -> String.format("Region Pre: %s -- BF: %s%n", regionPre, this.abstractionManager.convertRegionToFormula(regionPre)))});
            this.logger.logf(Level.FINE, "%s => %s (pre => post): %s%n%s => %s (post => pre): %s%n", new Object[]{regionPre, regionPost, this.abstractionManager.entails(regionPre, regionPost), regionPost, regionPre, this.abstractionManager.entails(regionPost, regionPre)});
        }
    }

    private void printHoareTriple(Collection<AbstractionPredicate> pPredicates, AbstractionFormula resultFormula) {
        Object prettyPrintPredicateList = MoreStrings.lazyString(() -> FluentIterable.from((Iterable)pPredicates).transform(x -> x.getSymbolicAtom()).join(Joiner.on((String)", ")));
        this.logger.logf(Level.FINER, "[%s] --- %s --- %s", new Object[]{prettyPrintPredicateList, resultFormula.getBlockFormula(), resultFormula.asInstantiatedFormula()});
    }
}

