/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.traceabstraction;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.sosy_lab.common.MoreStrings;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionRefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.traceabstraction.InterpolationSequence;
import org.sosy_lab.cpachecker.cpa.traceabstraction.InterpolationSequenceStorage;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Options(prefix="cpa.traceabstraction.refinementStrategy")
public class TraceAbstractionRefinementStrategy
extends PredicateAbstractionRefinementStrategy {
    @Option(secure=true, description="The max amount of refinements for the trace abstraction algorithm. Setting it to 0 leads to an analysis of the ARG without executing any refinements. This is used for debugging purposes.")
    private int maxRefinementIterations = -1;
    private int curRefinementIteration = 0;
    private final ShutdownNotifier shutdownNotifier;
    private final InterpolationSequenceStorage itpSequenceStorage;
    private InterpolationSequence.Builder itpSequenceBuilder;

    public TraceAbstractionRefinementStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, InterpolationSequenceStorage pItpSequenceStorage, PredicateAbstractionManager pPredAbsMgr, Solver pSolver) throws InvalidConfigurationException {
        super(pConfig, pLogger, pPredAbsMgr, pSolver);
        pConfig.inject((Object)this);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.itpSequenceStorage = (InterpolationSequenceStorage)Preconditions.checkNotNull((Object)pItpSequenceStorage);
    }

    @Override
    public boolean performRefinement(ARGReachedSet pReached, List<ARGState> pAbstractionStatesTrace, List<BooleanFormula> pInterpolants, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        Verify.verify((pAbstractionStatesTrace.size() == pInterpolants.size() + 1 ? 1 : 0) != 0);
        this.logger.logf(Level.FINE, "Mapping of interpolants to arg-states:\n%s", new Object[]{this.lazyPrintItpToTransitionMapping(pAbstractionStatesTrace, pInterpolants)});
        if (this.maxRefinementIterations != -1 && this.curRefinementIteration >= this.maxRefinementIterations) {
            this.logger.log(Level.WARNING, new Object[]{"Specified number of max refinements already exceeded. Skipping the refinement"});
            return false;
        }
        return super.performRefinement(pReached, pAbstractionStatesTrace, pInterpolants, pRepeatedCounterexample);
    }

    @Override
    protected final void startRefinementOfPath() {
        this.itpSequenceBuilder = new InterpolationSequence.Builder();
    }

    @Override
    protected void storePredicates(PredicatePrecision.LocationInstance pLocInstance, Collection<AbstractionPredicate> pPredicates) {
        this.itpSequenceBuilder.addPredicates(pLocInstance, pPredicates);
    }

    @Override
    protected void finishRefinementOfPath(ARGState pUnreachableState, List<ARGState> pAffectedStates, ARGReachedSet pReached, List<ARGState> pAbstractionStatesTrace, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        ARGState refinementRoot = this.computeRefinementRoot(pUnreachableState, pAffectedStates, pReached, pRepeatedCounterexample);
        InterpolationSequence newSequence = this.itpSequenceBuilder.build();
        this.logger.logf(Level.INFO, "New Itp-sequence:\n%s", new Object[]{newSequence});
        this.itpSequenceStorage.addItpSequence(newSequence);
        this.updateARG(refinementRoot, pReached);
        ++this.curRefinementIteration;
    }

    private ARGState computeRefinementRoot(ARGState pUnreachableState, List<ARGState> pAffectedStates, ARGReachedSet pReached, boolean pRepeatedCounterexample) throws RefinementFailedException {
        for (CFANode loc : AbstractStates.extractLocations(pUnreachableState)) {
            int locInstance = (Integer)PredicateAbstractState.getPredicateState(pUnreachableState).getAbstractionLocationsOnPath().get((Object)loc);
            this.storePredicates(new PredicatePrecision.LocationInstance(loc, locInstance), this.predAbsMgr.makeFalsePredicate());
        }
        pAffectedStates.add(pUnreachableState);
        ARGState refinementRoot = this.getRefinementRoot(pAffectedStates, pRepeatedCounterexample, pReached.asReachedSet(), (ImmutableSetMultimap<CFANode, AbstractionPredicate>)ImmutableSetMultimap.of());
        this.logger.logf(Level.INFO, "Refinement root: %d (Parents: %s)", new Object[]{refinementRoot.getStateId(), refinementRoot.getParents().stream().map(ARGState::getStateId).collect(ImmutableList.toImmutableList())});
        return refinementRoot;
    }

    private void updateARG(ARGState pRefinementRoot, ARGReachedSet pReached) throws InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        this.argUpdate.start();
        pReached.removeSubtree(pRefinementRoot);
        this.argUpdate.stop();
        assert (this.refinementCount > 0);
    }

    private Object lazyPrintItpToTransitionMapping(Collection<ARGState> pStates, List<BooleanFormula> pInterpolants) {
        return MoreStrings.lazyString(() -> Streams.zip(pStates.stream(), pInterpolants.stream(), (state, itp) -> String.format("%d:%s : %s", state.getStateId(), AbstractStates.extractLocation(state), itp)).collect(Collectors.joining("\n")));
    }
}

