/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.traceabstraction;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.traceabstraction.IndexedAbstractionPredicate;
import org.sosy_lab.cpachecker.cpa.traceabstraction.InterpolationSequence;

class TraceAbstractionState
extends AbstractSingleWrapperState
implements Graphable {
    private final ImmutableMap<InterpolationSequence, IndexedAbstractionPredicate> activePredicates;

    static TraceAbstractionState createInitState(AbstractState pAbstractState) {
        return new TraceAbstractionState(pAbstractState, (Map<InterpolationSequence, IndexedAbstractionPredicate>)ImmutableMap.of());
    }

    TraceAbstractionState(AbstractState pWrappedState, Map<InterpolationSequence, IndexedAbstractionPredicate> pActivePredicates) {
        super(pWrappedState);
        this.activePredicates = ImmutableMap.copyOf(pActivePredicates);
    }

    boolean containsPredicates() {
        return !this.activePredicates.isEmpty();
    }

    ImmutableMap<InterpolationSequence, IndexedAbstractionPredicate> getActivePredicates() {
        return this.activePredicates;
    }

    TraceAbstractionState withWrappedState(AbstractState pWrappedState) {
        if (pWrappedState == this.getWrappedState()) {
            return this;
        }
        return new TraceAbstractionState(pWrappedState, (Map<InterpolationSequence, IndexedAbstractionPredicate>)this.getActivePredicates());
    }

    boolean isLessOrEqual(TraceAbstractionState pOther) {
        return this.equals(pOther);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.activePredicates);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TraceAbstractionState)) {
            return false;
        }
        TraceAbstractionState other = (TraceAbstractionState)obj;
        return Objects.equals(this.activePredicates, other.activePredicates);
    }

    @Override
    public String toString() {
        if (!this.containsPredicates()) {
            return super.toString() + "\n_empty_preds_";
        }
        return this.createString();
    }

    @Override
    public String toDOTLabel() {
        return this.createString();
    }

    private String createString() {
        StringBuilder sb = new StringBuilder();
        AbstractState wrappedState = this.getWrappedState();
        if (wrappedState instanceof Graphable) {
            sb.append(((Graphable)((Object)wrappedState)).toDOTLabel());
            sb.append("\n");
        }
        sb.append(this.activePredicates.values().stream().map(indexedPred -> indexedPred.getPredicate().getSymbolicAtom().toString()).collect(Collectors.joining("\n")));
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        AbstractState wrappedState = this.getWrappedState();
        return wrappedState instanceof Graphable ? ((Graphable)((Object)wrappedState)).shouldBeHighlighted() : false;
    }
}

