/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.uninitvars;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;

public class UninitializedVariablesState
implements AbstractQueryableState,
Serializable {
    private static final long serialVersionUID = 5745797034946117366L;
    private final List<String> globalVars;
    private final Deque<Pair<String, List<String>>> localVars;
    private final Collection<Triple<Integer, String, String>> warnings;
    private Set<ElementProperty> properties = EnumSet.noneOf(ElementProperty.class);

    public UninitializedVariablesState(String entryFunction) {
        this.globalVars = new ArrayList<String>();
        this.localVars = new ArrayDeque<Pair<String, List<String>>>();
        this.warnings = new ArrayList<Triple<Integer, String, String>>();
        this.callFunction(entryFunction);
    }

    public UninitializedVariablesState(List<String> globalVars, Deque<Pair<String, List<String>>> localVars, Collection<Triple<Integer, String, String>> warnings) {
        this.globalVars = globalVars;
        this.localVars = localVars;
        this.warnings = warnings;
    }

    public void addGlobalVariable(String name) {
        if (!this.globalVars.contains(name)) {
            this.globalVars.add(name);
        }
    }

    public void removeGlobalVariable(String name) {
        this.globalVars.remove(name);
    }

    public Collection<String> getGlobalVariables() {
        return this.globalVars;
    }

    public void addLocalVariable(String name) {
        if (!this.localVars.peekLast().getSecond().contains(name)) {
            this.localVars.peekLast().getSecond().add(name);
        }
    }

    public void removeLocalVariable(String name) {
        this.localVars.peekLast().getSecond().remove(name);
    }

    public Collection<String> getLocalVariables() {
        return this.localVars.peekLast().getSecond();
    }

    public Deque<Pair<String, List<String>>> getallLocalVariables() {
        return this.localVars;
    }

    public Collection<Triple<Integer, String, String>> getWarnings() {
        return this.warnings;
    }

    public boolean isUninitialized(String variable) {
        return this.globalVars.contains(variable) || this.localVars.peekLast().getSecond().contains(variable);
    }

    public void callFunction(String functionName) {
        this.localVars.addLast(Pair.of(functionName, new ArrayList()));
    }

    public void returnFromFunction() {
        this.localVars.pollLast();
    }

    public void addWarning(Integer lineNumber, String variable, String message) {
        Triple<Integer, String, String> warning = Triple.of(lineNumber, variable, message);
        if (!this.warnings.contains(warning)) {
            this.warnings.add(warning);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UninitializedVariablesState)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        UninitializedVariablesState otherElement = (UninitializedVariablesState)o;
        return this.globalVars.equals(otherElement.globalVars) && this.localVars.equals(otherElement.localVars);
    }

    @Override
    public int hashCode() {
        return this.localVars.hashCode();
    }

    protected UninitializedVariablesState clone() {
        ArrayDeque<Pair<String, List<String>>> newLocalVars = new ArrayDeque<Pair<String, List<String>>>();
        for (Pair<String, List<String>> localContext : this.localVars) {
            newLocalVars.addLast(Pair.of(localContext.getFirst(), new ArrayList(localContext.getSecond())));
        }
        return new UninitializedVariablesState(new ArrayList<String>(this.globalVars), newLocalVars, new ArrayList<Triple<Integer, String, String>>(this.warnings));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[<global:");
        for (String string : this.globalVars) {
            sb.append(" " + string + " ");
        }
        for (Pair pair : this.localVars) {
            sb.append("> <" + (String)pair.getFirst() + ":");
            for (String var : (List)pair.getSecond()) {
                sb.append(" " + var + " ");
            }
        }
        sb.append(">]");
        return sb.toString();
    }

    void addProperty(ElementProperty pProp) {
        this.properties.add(pProp);
    }

    Set<ElementProperty> getProperties() {
        return this.properties;
    }

    void clearProperties() {
        this.properties.clear();
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        ElementProperty prop;
        try {
            prop = ElementProperty.valueOf(pProperty);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is not defined for this CPA (\"" + this.getCPAName() + "\"");
        }
        return this.properties.contains((Object)prop);
    }

    @Override
    public String getCPAName() {
        return "uninitVars";
    }

    static enum ElementProperty {
        UNINITIALIZED_RETURN_VALUE,
        UNINITIALIZED_VARIABLE_USED;

    }
}

