/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.uninitvars;

import com.google.common.collect.FluentIterable;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.uninitvars.UninitializedVariablesState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;

public class UninitializedVariablesStatistics
implements Statistics {
    private boolean printWarnings;

    public UninitializedVariablesStatistics(String printWarnings) {
        this.printWarnings = Boolean.parseBoolean(printWarnings);
    }

    @Override
    public String getName() {
        return "UninitializedVariablesCPA";
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        int noOfWarnings = 0;
        if (this.printWarnings) {
            HashSet<Pair<Integer, String>> warningsDisplayed = new HashSet<Pair<Integer, String>>();
            FluentIterable<UninitializedVariablesState> projectedReached = AbstractStates.projectToType(pReached, UninitializedVariablesState.class);
            for (UninitializedVariablesState uninitElement : projectedReached) {
                Collection<Triple<Integer, String, String>> warnings = uninitElement.getWarnings();
                for (Triple<Integer, String, String> warning : warnings) {
                    Pair<Integer, String> warningIndex = Pair.of(warning.getFirst(), warning.getSecond());
                    if (!warningsDisplayed.add(warningIndex)) continue;
                    pOut.println(warning.getThird());
                    ++noOfWarnings;
                }
            }
            if (warningsDisplayed.isEmpty()) {
                pOut.println("No uninitialized variables found");
            } else {
                pOut.println("No of uninitialized vars : " + noOfWarnings);
            }
        } else {
            pOut.println("Output deactivated by configuration option");
        }
    }
}

