/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.Identifiers;

public class BinderFunctionInfo {
    private final ImmutableList<Pair<UsageInfo.Access, Integer>> parameterInfo;
    private final Pair<LinkerInfo, LinkerInfo> linkInfo;

    BinderFunctionInfo() {
        this.linkInfo = null;
        this.parameterInfo = ImmutableList.of(Pair.of(UsageInfo.Access.WRITE, 1));
    }

    BinderFunctionInfo(String name, Configuration pConfig, LogManager pLogger) {
        try {
            String line = pConfig.getProperty(name + ".pInfo");
            Preconditions.checkNotNull((Object)line);
            line = CharMatcher.whitespace().removeFrom((CharSequence)line);
            this.parameterInfo = FluentIterable.from((Iterable)Splitter.on((String)",").splitToList((CharSequence)line)).transform(s -> Splitter.on((String)":").splitToList((CharSequence)s)).transform(s -> Pair.of(UsageInfo.Access.valueOf(((String)s.get(0)).toUpperCase()), this.getNumOrDefault((List<String>)s))).toList();
            line = pConfig.getProperty(name + ".linkInfo");
            if (line != null) {
                line = CharMatcher.whitespace().removeFrom((CharSequence)line);
                List options = Splitter.on((String)",").splitToList((CharSequence)line);
                assert (options.size() == 2);
                LinkerInfo[] lInfo = new LinkerInfo[2];
                for (int i = 0; i < 2; ++i) {
                    List pOption = Splitter.on((String)":").splitToList((CharSequence)options.get(i));
                    int dereference = this.getNumOrDefault(pOption);
                    lInfo[i] = new LinkerInfo(Integer.parseInt((String)pOption.get(0)), dereference);
                }
                this.linkInfo = Pair.of(lInfo[0], lInfo[1]);
            } else {
                this.linkInfo = null;
            }
        }
        catch (NumberFormatException e) {
            pLogger.log(Level.WARNING, new Object[]{"No information about parameters in " + name + " function"});
            throw e;
        }
    }

    public boolean shouldBeLinked() {
        return this.linkInfo != null;
    }

    public AbstractIdentifier constructFirstIdentifier(CExpression left, List<CExpression> params, String currentFunction) {
        return this.constructIdentifier(this.linkInfo.getFirst(), left, params, currentFunction);
    }

    public AbstractIdentifier constructSecondIdentifier(CExpression left, List<CExpression> params, String currentFunction) {
        return this.constructIdentifier(this.linkInfo.getSecond(), left, params, currentFunction);
    }

    private AbstractIdentifier constructIdentifier(LinkerInfo info, CExpression left, List<CExpression> params, String currentFunction) {
        CExpression expr;
        if (info.num == 0 && left != null) {
            expr = left;
        } else if (info.num > 0) {
            expr = params.get(info.num - 1);
        } else {
            return null;
        }
        return Identifiers.createIdentifier(expr, info.dereference, currentFunction);
    }

    public AbstractIdentifier createParamenterIdentifier(CExpression param, int num, String currentFunction) {
        return Identifiers.createIdentifier(param, (Integer)((Pair)this.parameterInfo.get(num)).getSecond(), currentFunction);
    }

    public UsageInfo.Access getBindedAccess(int num) {
        return (UsageInfo.Access)((Object)((Pair)this.parameterInfo.get(num)).getFirst());
    }

    private int getNumOrDefault(List<String> list) {
        if (list.size() == 1) {
            return 0;
        }
        return Integer.parseInt(list.get(1));
    }

    private static class LinkerInfo {
        private final int num;
        private final int dereference;

        LinkerInfo(int p, int d) {
            this.num = p;
            this.dereference = d;
        }
    }
}

