/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cpa.bam.BAMMultipleCEXSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockState;
import org.sosy_lab.cpachecker.cpa.lock.LockTransferRelation;
import org.sosy_lab.cpachecker.cpa.usage.ErrorTracePrinter;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.identifiers.GlobalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.LocalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.StructureFieldIdentifier;

@Options(prefix="cpa.usage")
public class ETVErrorTracePrinter
extends ErrorTracePrinter {
    @Option(name="output", description="path to write results", secure=true)
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path outputStatFileName = Path.of("unsafe_rawdata", new String[0]);
    @Option(description="use single file for output or dump every error trace to its own file", secure=true)
    private boolean singleFileOutput = false;
    private Writer globalWriter;

    public ETVErrorTracePrinter(Configuration pC, BAMMultipleCEXSubgraphComputer pT, CFA pCfa, LogManager pL, LockTransferRelation t) throws InvalidConfigurationException {
        super(pC, pT, pCfa, pL, t);
    }

    @Override
    protected void init() {
        try {
            this.globalWriter = Files.newBufferedWriter(Path.of(this.outputStatFileName.toString(), new String[0]), Charset.defaultCharset(), new OpenOption[0]);
            this.logger.log(Level.FINE, new Object[]{"Print statistics about unsafe cases"});
            this.printCountStatistics(this.globalWriter, this.container.getUnsafeIterator());
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "I/O error during init actions");
        }
    }

    @Override
    protected void finish() {
        try {
            this.globalWriter.close();
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "I/O error during finish actions");
        }
    }

    @Override
    protected void printUnsafe(SingleIdentifier id, Pair<UsageInfo, UsageInfo> pPair) {
        File name = new File("output/ErrorPath." + this.createUniqueName(id) + ".txt");
        try {
            Writer writer = this.singleFileOutput ? this.globalWriter : Files.newBufferedWriter(name.toPath(), Charset.defaultCharset(), new OpenOption[0]);
            if (id instanceof StructureFieldIdentifier) {
                writer.append("###\n");
            } else if (id instanceof GlobalVariableIdentifier) {
                writer.append("#\n");
            } else if (id instanceof LocalVariableIdentifier) {
                writer.append("##" + ((LocalVariableIdentifier)id).getFunction() + "\n");
            } else {
                this.logger.log(Level.WARNING, new Object[]{"What is it? " + id});
            }
            writer.append(id.getDereference() + "\n");
            writer.append(id.getType().toASTString(id.getName()) + "\n");
            writer.append("Line 0:     N0 -{/*Two examples:*/}-> N0\n");
            this.createVisualization(id, pPair.getFirst(), writer);
            this.createVisualization(id, pPair.getSecond(), writer);
            if (!this.singleFileOutput) {
                writer.close();
            }
        }
        catch (IOException e) {
            this.logger.logfUserException(Level.WARNING, (Throwable)e, "I/O error while printing unsafe %s", new Object[]{id});
        }
    }

    private void createVisualization(SingleIdentifier id, UsageInfo usage, Writer writer) throws IOException {
        List<CFAEdge> path;
        AbstractLockState locks = usage.getLockState();
        writer.append("Line 0:     N0 -{/*_____________________*/}-> N0\n");
        if (locks != null) {
            writer.append("Line 0:     N0 -{/*" + locks + "*/}-> N0\n");
        }
        if (usage.isLooped()) {
            writer.append("Line 0:     N0 -{/*Failure in refinement*/}-> N0\n");
        }
        if ((path = this.getPath(usage)) == null) {
            return;
        }
        int callstackDepth = 1;
        Iterator<CFAEdge> iterator = path.iterator();
        while (iterator.hasNext()) {
            CFAEdge edge = iterator.next();
            if (edge == null || edge instanceof CDeclarationEdge) continue;
            if (edge instanceof CFunctionCallEdge && iterator.hasNext()) {
                ++callstackDepth;
            } else if (edge instanceof CFunctionReturnEdge) {
                --callstackDepth;
            } else if (edge instanceof CReturnStatementEdge && !iterator.hasNext()) {
                assert (callstackDepth > 0);
                --callstackDepth;
            } else if (edge instanceof BlankEdge && edge.getDescription().contains("return") && !iterator.hasNext()) {
                assert (callstackDepth > 0);
                --callstackDepth;
            }
            String caption = this.getNoteFor(edge);
            if (!caption.isEmpty() && !(edge instanceof CFunctionReturnEdge)) {
                writer.write("Line 0:     N0 -{/*" + caption + "*/}-> N0\n");
                writer.write("Line 0:     N0 -{highlight}-> N0\n");
            } else if (Objects.equals(edge.getSuccessor(), usage.getCFANode()) && edge.toString().contains(id.getName())) {
                writer.write("Line 0:     N0 -{highlight}-> N0\n");
            }
            writer.write(edge + "\n");
        }
        for (int i = 0; i < callstackDepth; ++i) {
            writer.append("Line 0:     N0 -{return;}-> N0\n");
        }
        writer.write("\n");
    }

    private void printCountStatistics(Writer writer, Iterator<SingleIdentifier> idIterator) throws IOException {
        int global = 0;
        int local = 0;
        int fields = 0;
        int globalPointer = 0;
        int localPointer = 0;
        int fieldPointer = 0;
        while (idIterator.hasNext()) {
            SingleIdentifier id = idIterator.next();
            if (id instanceof GlobalVariableIdentifier) {
                if (id.getDereference() == 0) {
                    ++global;
                    continue;
                }
                ++globalPointer;
                continue;
            }
            if (id instanceof LocalVariableIdentifier) {
                if (id.getDereference() == 0) {
                    ++local;
                    continue;
                }
                ++localPointer;
                continue;
            }
            if (!(id instanceof StructureFieldIdentifier)) continue;
            if (id.getDereference() == 0) {
                ++fields;
                continue;
            }
            ++fieldPointer;
        }
        writer.append(global + "\n");
        writer.append(globalPointer + "\n");
        writer.append(local + "\n");
        writer.append(localPointer + "\n");
        writer.append(fields + "\n");
        writer.append(fieldPointer + "\n");
        writer.append(global + globalPointer + local + localPointer + fields + fieldPointer + "\n");
    }
}

