/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.collect.ImmutableList;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.BAMMultipleCEXSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.lock.LockTransferRelation;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.UsageReachedSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.AbstractUsagePointSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.UnsafeDetector;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageContainer;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.usage")
public abstract class ErrorTracePrinter {
    @Option(name="falseUnsafesOutput", description="path to write results", secure=true)
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path outputFalseUnsafes = Path.of("FalseUnsafes", new String[0]);
    @Option(name="filterMissedFiles", description="if a file do not exist, do not include the corresponding edge", secure=true)
    private boolean filterMissedFiles = true;
    @Option(description="print all unsafe cases in report", secure=true)
    private boolean printFalseUnsafes = false;
    protected final LockTransferRelation lockTransfer;
    private final StatTimer preparationTimer = new StatTimer("Time for preparation");
    private final StatTimer unsafeDetectionTimer = new StatTimer("Time for unsafe detection");
    private final StatTimer writingUnsafeTimer = new StatTimer("Time for dumping the unsafes");
    protected final Configuration config;
    protected UsageContainer container;
    protected final LogManager logger;
    protected UnsafeDetector detector;
    protected final CFA cfa;
    private BAMMultipleCEXSubgraphComputer subgraphComputer;

    protected ErrorTracePrinter(Configuration c, BAMMultipleCEXSubgraphComputer t, CFA pCfa, LogManager l, LockTransferRelation lT) throws InvalidConfigurationException {
        this.logger = l;
        this.config = c;
        this.lockTransfer = lT;
        this.config.inject((Object)this, ErrorTracePrinter.class);
        this.subgraphComputer = t;
        this.cfa = pCfa;
    }

    protected boolean hasRelevantFileLocation(CFAEdge e) {
        if (e == null) {
            return false;
        }
        FileLocation loc = e.getFileLocation();
        if (loc == null || !loc.isRealLocation()) {
            return false;
        }
        return !this.filterMissedFiles || Files.exists(loc.getFileName(), new LinkOption[0]);
    }

    private List<CFAEdge> createPath(UsageInfo usage) {
        assert (usage.getKeyState() != null);
        ARGState target = (ARGState)usage.getKeyState();
        ARGPath path = this.subgraphComputer != null ? this.subgraphComputer.computePath(target) : ARGUtils.getOnePathTo(target);
        if (path == null) {
            this.logger.log(Level.SEVERE, new Object[]{"Cannot compute path for: " + usage});
            return ImmutableList.of();
        }
        return path.getInnerEdges();
    }

    protected String createUniqueName(SingleIdentifier id) {
        return id.getType().toASTString("_" + id).replace(" ", "_");
    }

    public void printErrorTraces(UnmodifiableReachedSet reached) {
        Set<SingleIdentifier> falseUnsafes;
        this.preparationTimer.start();
        ReachedSet reachedSet = reached instanceof ForwardingReachedSet ? ((ForwardingReachedSet)reached).getDelegate() : (ReachedSet)reached;
        UsageReachedSet uReached = (UsageReachedSet)reachedSet;
        this.container = uReached.getUsageContainer();
        this.detector = this.container.getUnsafeDetector();
        this.logger.log(Level.FINEST, new Object[]{"Processing unsafe identifiers"});
        Iterator<SingleIdentifier> unsafeIterator = this.container.getUnsafeIterator();
        this.init();
        this.preparationTimer.stop();
        while (unsafeIterator.hasNext()) {
            SingleIdentifier id = unsafeIterator.next();
            AbstractUsagePointSet uinfo = this.container.getUsages(id);
            if (uinfo == null || uinfo.size() == 0) continue;
            this.unsafeDetectionTimer.start();
            if (!this.detector.isUnsafe(uinfo)) {
                this.unsafeDetectionTimer.stop();
                continue;
            }
            Pair<UsageInfo, UsageInfo> tmpPair = this.detector.getUnsafePair(uinfo);
            this.unsafeDetectionTimer.stop();
            this.writingUnsafeTimer.start();
            this.printUnsafe(id, tmpPair);
            this.writingUnsafeTimer.stop();
        }
        if (this.printFalseUnsafes && !(falseUnsafes = this.container.getFalseUnsafes()).isEmpty()) {
            try (BufferedWriter writer = Files.newBufferedWriter(this.outputFalseUnsafes, Charset.defaultCharset(), new OpenOption[0]);){
                this.logger.log(Level.FINE, new Object[]{"Print statistics about false unsafes"});
                for (SingleIdentifier id : falseUnsafes) {
                    writer.append(this.createUniqueName(id) + "\n");
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write error trace");
            }
        }
        this.finish();
    }

    public void printStatistics(StatisticsWriter out) {
        out.spacer().put(this.preparationTimer).put(this.unsafeDetectionTimer).put(this.writingUnsafeTimer);
        this.container.printUsagesStatistics(out);
    }

    protected String getNoteFor(CFAEdge pEdge) {
        return this.lockTransfer == null || pEdge == null ? "" : this.lockTransfer.doesChangeTheState(pEdge);
    }

    protected List<CFAEdge> getPath(UsageInfo usage) {
        List<CFAEdge> path = usage.getPath();
        if (usage.getPath() == null) {
            path = this.createPath(usage);
        }
        return path.isEmpty() ? null : path;
    }

    protected abstract void printUnsafe(SingleIdentifier var1, Pair<UsageInfo, UsageInfo> var2);

    protected void init() {
    }

    protected void finish() {
    }
}

