/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.Identifiers;

public class ExpressionHandler
extends DefaultCExpressionVisitor<Void, NoException> {
    private final List<Pair<AbstractIdentifier, UsageInfo.Access>> result = new ArrayList<Pair<AbstractIdentifier, UsageInfo.Access>>();
    private final String fName;
    private UsageInfo.Access accessMode;

    public ExpressionHandler(UsageInfo.Access mode, String functionName) {
        this.accessMode = mode;
        this.fName = functionName;
    }

    @Override
    public Void visit(CArraySubscriptExpression expression) {
        this.addExpression(expression);
        this.accessMode = UsageInfo.Access.READ;
        expression.getArrayExpression().accept(this);
        return null;
    }

    @Override
    public Void visit(CBinaryExpression expression) {
        Preconditions.checkArgument((this.accessMode == UsageInfo.Access.READ ? 1 : 0) != 0, (String)"Writing to BinaryExpression: %s", (Object)expression.toASTString());
        expression.getOperand1().accept(this);
        expression.getOperand2().accept(this);
        return null;
    }

    @Override
    public Void visit(CCastExpression expression) {
        expression.getOperand().accept(this);
        return null;
    }

    @Override
    public Void visit(CFieldReference expression) {
        this.addExpression(expression);
        if (expression.isPointerDereference()) {
            this.accessMode = UsageInfo.Access.READ;
            expression.getFieldOwner().accept(this);
        }
        return null;
    }

    @Override
    public Void visit(CIdExpression expression) {
        this.addExpression(expression);
        return null;
    }

    @Override
    public Void visit(CUnaryExpression expression) {
        if (expression.getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
            this.addExpression(expression);
            return null;
        }
        this.accessMode = UsageInfo.Access.READ;
        expression.getOperand().accept(this);
        return null;
    }

    @Override
    public Void visit(CPointerExpression pPointerExpression) {
        this.addExpression(pPointerExpression);
        this.accessMode = UsageInfo.Access.READ;
        pPointerExpression.getOperand().accept(this);
        return null;
    }

    @Override
    public Void visit(CComplexCastExpression pComplexCastExpression) {
        pComplexCastExpression.getOperand().accept(this);
        return null;
    }

    private void addExpression(CExpression e) {
        AbstractIdentifier id = Identifiers.createIdentifier(e, this.fName);
        this.result.add(Pair.of(id, this.accessMode));
    }

    public List<Pair<AbstractIdentifier, UsageInfo.Access>> getProcessedExpressions() {
        return this.result;
    }

    @Override
    protected Void visitDefault(CExpression pExp) {
        return null;
    }
}

