/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CThreadOperationStatement;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.bam.BAMMultipleCEXSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.lock.LockTransferRelation;
import org.sosy_lab.cpachecker.cpa.usage.ErrorTracePrinter;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.automaton.VerificationTaskMetaData;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

@Options(prefix="cpa.usage.export")
public class KleverErrorTracePrinter
extends ErrorTracePrinter {
    @Option(secure=true, name="witnessTemplate", description="export counterexample core as text file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathFile = PathTemplate.ofFormatString((String)"witness.%s.graphml");
    private static final String WARNING_MESSAGE = "Access was not found";
    int idCounter = 0;
    ThreadIterator threadIterator;
    private Element currentNode;

    public KleverErrorTracePrinter(Configuration c, BAMMultipleCEXSubgraphComputer pT, CFA pCfa, LogManager pL, LockTransferRelation lT) throws InvalidConfigurationException {
        super(c, pT, pCfa, pL, lT);
        this.config.inject((Object)this, KleverErrorTracePrinter.class);
    }

    private String getCurrentId() {
        return "A" + this.idCounter;
    }

    private String getNextId() {
        ++this.idCounter;
        return this.getCurrentId();
    }

    @Override
    protected void printUnsafe(SingleIdentifier pId, Pair<UsageInfo, UsageInfo> pTmpPair) {
        UsageInfo firstUsage = pTmpPair.getFirst();
        UsageInfo secondUsage = pTmpPair.getSecond();
        List<CFAEdge> firstPath = this.getPath(firstUsage);
        if (firstPath == null) {
            return;
        }
        List<CFAEdge> secondPath = this.getPath(secondUsage);
        if (secondPath == null) {
            return;
        }
        try {
            String defaultSourcefileName = ((CFAEdge)FluentIterable.from(firstPath).filter(this::hasRelevantFileLocation).get(0)).getFileLocation().getFileName().toString();
            AutomatonGraphmlCommon.GraphMlBuilder builder = new AutomatonGraphmlCommon.GraphMlBuilder(AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS, defaultSourcefileName, this.cfa, new VerificationTaskMetaData(this.config, Specification.alwaysSatisfied()));
            this.idCounter = 0;
            this.threadIterator = new ThreadIterator();
            Element result = builder.createNodeElement(this.getCurrentId(), AutomatonGraphmlCommon.NodeType.ONPATH);
            builder.addDataElementChild(result, AutomatonGraphmlCommon.NodeFlag.ISENTRY.key, "true");
            Iterator<CFAEdge> firstIterator = this.getIterator(firstPath);
            Iterator<CFAEdge> secondIterator = this.getIterator(secondPath);
            if (!firstIterator.hasNext()) {
                this.logger.log(Level.WARNING, new Object[]{"Path to " + firstUsage + "is empty"});
                return;
            }
            if (!secondIterator.hasNext()) {
                this.logger.log(Level.WARNING, new Object[]{"Path to " + secondUsage + "is empty"});
                return;
            }
            CFAEdge firstEdge = firstIterator.next();
            CFAEdge secondEdge = secondIterator.next();
            while (firstEdge.equals(secondEdge) && !this.isThreadCreateNFunction(firstEdge)) {
                this.printEdge(builder, firstEdge);
                if (!firstIterator.hasNext()) {
                    this.logger.log(Level.WARNING, new Object[]{"Path to " + firstUsage + "is ended before deviding"});
                    return;
                }
                if (!secondIterator.hasNext()) {
                    this.logger.log(Level.WARNING, new Object[]{"Path to " + secondUsage + "is ended before deviding"});
                    return;
                }
                firstEdge = firstIterator.next();
                secondEdge = secondIterator.next();
            }
            int forkThread = this.threadIterator.getCurrentThread();
            this.printEdge(builder, firstEdge);
            this.printPath(firstUsage, firstIterator, builder);
            this.threadIterator.setCurrentThread(forkThread);
            this.printEdge(builder, secondEdge);
            this.printPath(secondUsage, secondIterator, builder);
            builder.addDataElementChild(this.currentNode, AutomatonGraphmlCommon.NodeFlag.ISVIOLATION.key, "true");
            Path currentPath = this.errorPathFile.getPath(new Object[]{this.createUniqueName(pId)});
            IO.writeFile((Path)currentPath, (Charset)Charset.defaultCharset(), a -> builder.appendTo(a));
        }
        catch (IOException | ParserConfigurationException | InvalidConfigurationException | DOMException e) {
            this.logger.logfUserException(Level.WARNING, e, "Exception during printing unsafe %s", new Object[]{pId});
        }
    }

    private void printPath(UsageInfo usage, Iterator<CFAEdge> iterator, AutomatonGraphmlCommon.GraphMlBuilder builder) {
        String pIdName = usage.getId().getName();
        boolean warningIsPrinted = false;
        while (iterator.hasNext()) {
            CFAEdge pEdge = iterator.next();
            Element edge = this.printEdge(builder, pEdge);
            if (!warningIsPrinted && Objects.equals(pEdge.getSuccessor(), usage.getCFANode()) && this.containsId(pEdge, pIdName)) {
                warningIsPrinted = true;
                builder.addDataElementChild(edge, AutomatonGraphmlCommon.KeyDef.WARNING, usage.toString());
                continue;
            }
            if (warningIsPrinted || iterator.hasNext()) continue;
            this.logger.log(Level.WARNING, new Object[]{"Can not determine an unsafe edge"});
            builder.addDataElementChild(edge, AutomatonGraphmlCommon.KeyDef.WARNING, WARNING_MESSAGE);
        }
    }

    private Element printEdge(AutomatonGraphmlCommon.GraphMlBuilder builder, CFAEdge edge) {
        if (this.isThreadCreateFunction(edge)) {
            CFunctionSummaryEdge sEdge = ((CFunctionCallEdge)edge).getSummaryEdge();
            Element result = this.printEdge(builder, sEdge);
            builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.CREATETHREAD, Integer.toString(this.threadIterator.next()));
        }
        return this.printEdge(builder, edge, this.getCurrentId(), this.getNextId());
    }

    private Element printEdge(AutomatonGraphmlCommon.GraphMlBuilder builder, CFAEdge edge, String currentId, String nextId) {
        Element result = builder.createEdgeElement(currentId, nextId);
        this.dumpCommonInfoForEdge(builder, result, edge);
        String note = this.getNoteFor(edge);
        if (!note.isEmpty()) {
            builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.NOTE, note);
        }
        this.currentNode = builder.createNodeElement(nextId, AutomatonGraphmlCommon.NodeType.ONPATH);
        return result;
    }

    private void dumpCommonInfoForEdge(AutomatonGraphmlCommon.GraphMlBuilder builder, Element result, CFAEdge pEdge) {
        if (pEdge.getSuccessor() instanceof FunctionEntryNode) {
            FunctionEntryNode in = (FunctionEntryNode)pEdge.getSuccessor();
            builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.FUNCTIONENTRY, in.getFunctionName());
        }
        if (pEdge.getSuccessor() instanceof FunctionExitNode) {
            FunctionExitNode out = (FunctionExitNode)pEdge.getSuccessor();
            builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.FUNCTIONEXIT, out.getFunctionName());
        }
        if (pEdge instanceof AssumeEdge) {
            AssumeEdge a = (AssumeEdge)pEdge;
            AutomatonGraphmlCommon.AssumeCase assumeCase = a.getTruthAssumption() ? AutomatonGraphmlCommon.AssumeCase.THEN : AutomatonGraphmlCommon.AssumeCase.ELSE;
            builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.CONTROLCASE, assumeCase.toString());
        }
        FileLocation location = pEdge.getFileLocation();
        assert (location != null) : "should be filtered";
        builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.ORIGINFILE, location.getFileName().toString());
        builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.STARTLINE, Integer.toString(location.getStartingLineInOrigin()));
        builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.OFFSET, Integer.toString(location.getNodeOffset()));
        if (!pEdge.getRawStatement().trim().isEmpty()) {
            builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.SOURCECODE, pEdge.getRawStatement());
        }
        builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.THREADID, Integer.toString(this.threadIterator.getCurrentThread()));
    }

    private Iterator<CFAEdge> getIterator(List<CFAEdge> path) {
        return FluentIterable.from(path).filter(this::hasRelevantFileLocation).iterator();
    }

    private boolean isThreadCreateFunction(CFAEdge pEdge) {
        return this.getThreadCreateStatementIfExists(pEdge) != null;
    }

    private boolean isThreadCreateNFunction(CFAEdge pEdge) {
        CThreadOperationStatement.CThreadCreateStatement stmnt = this.getThreadCreateStatementIfExists(pEdge);
        return stmnt == null ? false : stmnt.isSelfParallel();
    }

    private CThreadOperationStatement.CThreadCreateStatement getThreadCreateStatementIfExists(CFAEdge pEdge) {
        CFunctionSummaryEdge sEdge;
        CFunctionCall fCall;
        if (pEdge instanceof CFunctionCallEdge && (fCall = (sEdge = ((CFunctionCallEdge)pEdge).getSummaryEdge()).getExpression()) instanceof CThreadOperationStatement.CThreadCreateStatement) {
            return (CThreadOperationStatement.CThreadCreateStatement)fCall;
        }
        return null;
    }

    private boolean containsId(CFAEdge edge, String pIdName) {
        if (edge.toString().contains(pIdName)) {
            return true;
        }
        return edge instanceof CFunctionCallEdge && ((CFunctionCallEdge)edge).getSummaryEdge().getRawStatement().contains(pIdName);
    }

    private static class ThreadIterator
    implements Iterator<Integer> {
        private Set<Integer> usedThreadIds = new HashSet<Integer>();
        private int currentThread = 0;

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Integer next() {
            int nextThread = this.currentThread + 1;
            while (this.usedThreadIds.contains(nextThread)) {
                ++nextThread;
            }
            this.currentThread = nextThread;
            this.usedThreadIds.add(nextThread);
            return this.getCurrentThread();
        }

        public int getCurrentThread() {
            return this.currentThread;
        }

        public void setCurrentThread(int newVal) {
            this.currentThread = newVal;
        }
    }
}

