/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.bam.BAMMultipleCEXSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.lock.LockTransferRelation;
import org.sosy_lab.cpachecker.cpa.usage.ErrorTracePrinter;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.automaton.VerificationTaskMetaData;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class KleverErrorTracePrinterOld
extends ErrorTracePrinter {
    int idCounter = 0;

    public KleverErrorTracePrinterOld(Configuration c, BAMMultipleCEXSubgraphComputer pT, CFA pCfa, LogManager pL, LockTransferRelation lT) throws InvalidConfigurationException {
        super(c, pT, pCfa, pL, lT);
    }

    private String getId() {
        return "A" + this.idCounter++;
    }

    @Override
    protected void printUnsafe(SingleIdentifier pId, Pair<UsageInfo, UsageInfo> pTmpPair) {
        UsageInfo firstUsage = pTmpPair.getFirst();
        UsageInfo secondUsage = pTmpPair.getSecond();
        List<CFAEdge> firstPath = this.getPath(firstUsage);
        List<CFAEdge> secondPath = this.getPath(secondUsage);
        if (firstPath == null || secondPath == null) {
            return;
        }
        try {
            File name = new File("output/witness." + this.createUniqueName(pId) + ".graphml");
            String defaultSourcefileName = ((CFAEdge)FluentIterable.from(firstPath).filter(this::hasRelevantFileLocation).get(0)).getFileLocation().getFileName().toString();
            AutomatonGraphmlCommon.GraphMlBuilder builder = new AutomatonGraphmlCommon.GraphMlBuilder(AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS, defaultSourcefileName, this.cfa, new VerificationTaskMetaData(this.config, Specification.alwaysSatisfied()));
            this.idCounter = 0;
            Element result = builder.createNodeElement("A0", AutomatonGraphmlCommon.NodeType.ONPATH);
            builder.addDataElementChild(result, AutomatonGraphmlCommon.NodeFlag.ISENTRY.key, "true");
            this.printPath(firstUsage, 0, builder);
            result = this.printPath(secondUsage, 2, builder);
            builder.addDataElementChild(result, AutomatonGraphmlCommon.NodeFlag.ISVIOLATION.key, "true");
            IO.writeFile((Path)Path.of(name.getAbsolutePath(), new String[0]), (Charset)Charset.defaultCharset(), a -> builder.appendTo(a));
        }
        catch (IOException | ParserConfigurationException | InvalidConfigurationException | DOMException e) {
            this.logger.logfUserException(Level.WARNING, e, "Exception during printing unsafe %s", new Object[]{pId});
        }
    }

    private Element printPath(UsageInfo usage, int threadId, AutomatonGraphmlCommon.GraphMlBuilder builder) {
        String currentId;
        String nextId = currentId = this.getId();
        SingleIdentifier pId = usage.getId();
        List<CFAEdge> path = usage.getPath();
        Iterator iterator = FluentIterable.from(path).filter(this::hasRelevantFileLocation).iterator();
        CFAEdge warning = Lists.reverse(path).stream().filter(e -> Objects.equals(e.getSuccessor(), usage.getCFANode())).filter(e -> e.toString().contains(pId.getName())).findFirst().orElse(null);
        if (warning == null) {
            this.logger.log(Level.WARNING, new Object[]{"Can not determine an unsafe edge"});
        }
        Element result = null;
        Element lastWarningElement = null;
        boolean printEdge = false;
        boolean globalDeclaration = true;
        if (threadId == 0) {
            printEdge = true;
        }
        while (iterator.hasNext()) {
            CFAEdge pEdge = (CFAEdge)iterator.next();
            if (!printEdge && pEdge.getEdgeType() != CFAEdgeType.DeclarationEdge && pEdge.getEdgeType() != CFAEdgeType.BlankEdge) {
                assert (globalDeclaration);
                printEdge = true;
            } else if (!printEdge) continue;
            currentId = nextId;
            nextId = this.getId();
            result = builder.createEdgeElement(currentId, nextId);
            this.dumpCommonInfoForEdge(builder, result, pEdge);
            String note = this.getNoteFor(pEdge);
            if (!note.isEmpty()) {
                builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.NOTE, note);
            }
            if (globalDeclaration && pEdge.getEdgeType() != CFAEdgeType.DeclarationEdge && pEdge.getEdgeType() != CFAEdgeType.BlankEdge) {
                globalDeclaration = false;
                if (threadId == 0) {
                    ++threadId;
                }
                builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.FUNCTIONENTRY, "main");
            }
            builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.THREADID, Integer.toString(threadId));
            if (pEdge == warning) {
                lastWarningElement = result;
            }
            result = builder.createNodeElement(nextId, AutomatonGraphmlCommon.NodeType.ONPATH);
        }
        if (lastWarningElement != null) {
            builder.addDataElementChild(lastWarningElement, AutomatonGraphmlCommon.KeyDef.WARNING, usage.toString());
        }
        --this.idCounter;
        return result;
    }

    private void dumpCommonInfoForEdge(AutomatonGraphmlCommon.GraphMlBuilder builder, Element result, CFAEdge pEdge) {
        if (pEdge.getSuccessor() instanceof FunctionEntryNode) {
            FunctionEntryNode in = (FunctionEntryNode)pEdge.getSuccessor();
            builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.FUNCTIONENTRY, in.getFunctionName());
        }
        if (pEdge.getSuccessor() instanceof FunctionExitNode) {
            FunctionExitNode out = (FunctionExitNode)pEdge.getSuccessor();
            builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.FUNCTIONEXIT, out.getFunctionName());
        }
        if (pEdge instanceof AssumeEdge) {
            AssumeEdge a = (AssumeEdge)pEdge;
            AutomatonGraphmlCommon.AssumeCase assumeCase = a.getTruthAssumption() ? AutomatonGraphmlCommon.AssumeCase.THEN : AutomatonGraphmlCommon.AssumeCase.ELSE;
            builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.CONTROLCASE, assumeCase.toString());
        }
        FileLocation location = pEdge.getFileLocation();
        assert (location != null) : "should be filtered";
        builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.ORIGINFILE, location.getFileName().toString());
        builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.STARTLINE, Integer.toString(location.getStartingLineInOrigin()));
        builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.OFFSET, Integer.toString(location.getNodeOffset()));
        if (!pEdge.getRawStatement().trim().isEmpty()) {
            builder.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.SOURCECODE, pEdge.getRawStatement());
        }
    }
}

