/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.local.LocalState;
import org.sosy_lab.cpachecker.util.identifiers.GeneralGlobalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GeneralIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GeneralLocalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GeneralStructureFieldIdentifier;

public class PresisionParser {
    private CFA cfa;
    private final LogManager logger;

    PresisionParser(CFA pCfa, LogManager l) {
        this.cfa = pCfa;
        this.logger = l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<CFANode, Map<GeneralIdentifier, LocalState.DataType>> parse(Path file) {
        HashMap<CFANode, Map<GeneralIdentifier, LocalState.DataType>> localStatistics = new HashMap<CFANode, Map<GeneralIdentifier, LocalState.DataType>>();
        HashMap idToNodeMap = new HashMap();
        this.cfa.getAllNodes().forEach(n -> idToNodeMap.put(n.getNodeNumber(), n));
        try (BufferedReader reader = Files.newBufferedReader(file, Charset.defaultCharset());){
            String line;
            CFANode node = null;
            HashMap<GeneralIdentifier, LocalState.DataType> info = null;
            Pattern nodePattern = Pattern.compile("N[0-9]*$");
            while ((line = reader.readLine()) != null) {
                String nodeId;
                Matcher matcher = nodePattern.matcher(line);
                if (matcher.find()) {
                    this.putIntoMap(localStatistics, node, info);
                    nodeId = matcher.group().substring(1);
                    node = (CFANode)idToNodeMap.get(Integer.parseInt(nodeId));
                    info = new HashMap<GeneralIdentifier, LocalState.DataType>();
                    continue;
                }
                if (line.isEmpty()) continue;
                if (info == null) {
                    this.logger.log(Level.WARNING, new Object[]{"Cannot parse precision file %s, node id needs to appear first.", file});
                    nodeId = ImmutableMap.of();
                    return nodeId;
                }
                List localSet = Splitter.on((String)";").splitToList((CharSequence)line);
                if (this.shouldBeSkipped(localSet)) continue;
                GeneralIdentifier id = this.parseId(localSet);
                LocalState.DataType type = LocalState.DataType.valueOf(((String)localSet.get(3)).toUpperCase());
                info.put(id, type);
            }
            this.putIntoMap(localStatistics, node, info);
            ImmutableMap immutableMap = ImmutableMap.copyOf(localStatistics);
            return immutableMap;
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Cannot parse precision file");
            return ImmutableMap.of();
        }
    }

    private GeneralIdentifier parseId(List<String> splittedLine) {
        String type = splittedLine.get(0);
        String name = splittedLine.get(1);
        int deref = Integer.parseInt(splittedLine.get(2));
        if (type.equalsIgnoreCase("g")) {
            return new GeneralGlobalVariableIdentifier(name, deref);
        }
        if (type.equalsIgnoreCase("l")) {
            return new GeneralLocalVariableIdentifier(name, deref);
        }
        if (type.equalsIgnoreCase("s") || type.equalsIgnoreCase("f")) {
            return new GeneralStructureFieldIdentifier(name, deref);
        }
        throw new UnsupportedOperationException(splittedLine + " can not be parsed, please, move all checks to shouldBeSkipped()");
    }

    private boolean shouldBeSkipped(List<String> set) {
        return set.get(0).equalsIgnoreCase("r") || set.get(0).equalsIgnoreCase("func");
    }

    private void putIntoMap(Map<CFANode, Map<GeneralIdentifier, LocalState.DataType>> map, CFANode node, Map<GeneralIdentifier, LocalState.DataType> info) {
        if (node != null && info != null) {
            if (map.containsKey(node)) {
                this.logger.log(Level.WARNING, new Object[]{"Node " + node + " is already in presision"});
            } else {
                map.put(node, info);
            }
        }
    }
}

