/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import java.nio.file.Path;
import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.lock.LockCPA;
import org.sosy_lab.cpachecker.cpa.lock.LockTransferRelation;
import org.sosy_lab.cpachecker.cpa.usage.PresisionParser;
import org.sosy_lab.cpachecker.cpa.usage.UsageCPAStatistics;
import org.sosy_lab.cpachecker.cpa.usage.UsageMergeOperator;
import org.sosy_lab.cpachecker.cpa.usage.UsagePrecision;
import org.sosy_lab.cpachecker.cpa.usage.UsagePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.usage.UsageReducer;
import org.sosy_lab.cpachecker.cpa.usage.UsageState;
import org.sosy_lab.cpachecker.cpa.usage.UsageStopOperator;
import org.sosy_lab.cpachecker.cpa.usage.UsageTransferRelation;
import org.sosy_lab.cpachecker.util.CPAs;

@Options
public class UsageCPA
extends AbstractSingleWrapperCPA
implements ConfigurableProgramAnalysisWithBAM,
StatisticsProvider {
    private final StopOperator stopOperator;
    private final MergeOperator mergeOperator;
    private final TransferRelation transferRelation;
    private final PrecisionAdjustment precisionAdjustment;
    private final Reducer reducer;
    private final UsageCPAStatistics statistics;
    private final CFA cfa;
    private final LogManager logger;
    @Option(description="A path to precision", name="precision.path", secure=true)
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path outputFileName = Path.of("localsave", new String[0]);

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(UsageCPA.class);
    }

    private UsageCPA(ConfigurableProgramAnalysis pCpa, CFA pCfa, LogManager pLogger, Configuration pConfig) throws InvalidConfigurationException {
        super(pCpa);
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        this.stopOperator = new UsageStopOperator(pCpa.getStopOperator());
        this.mergeOperator = new UsageMergeOperator(pCpa.getMergeOperator());
        LockCPA lockCPA = CPAs.retrieveCPA(this, LockCPA.class);
        this.statistics = new UsageCPAStatistics(pConfig, pLogger, pCfa, lockCPA != null ? (LockTransferRelation)lockCPA.getTransferRelation() : null);
        this.precisionAdjustment = new UsagePrecisionAdjustment(pCpa.getPrecisionAdjustment());
        if (pCpa instanceof ConfigurableProgramAnalysisWithBAM) {
            Reducer wrappedReducer = ((ConfigurableProgramAnalysisWithBAM)pCpa).getReducer();
            this.reducer = new UsageReducer(wrappedReducer);
        } else {
            this.reducer = null;
        }
        this.logger = pLogger;
        this.transferRelation = new UsageTransferRelation(pCpa.getTransferRelation(), pConfig, pLogger, this.statistics);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return DelegateAbstractDomain.getInstance();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition p) throws InterruptedException {
        PresisionParser parser = new PresisionParser(this.cfa, this.logger);
        return UsagePrecision.create(this.getWrappedCpa().getInitialPrecision(pNode, p), parser.parse(this.outputFileName));
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
        super.collectStatistics(pStatsCollection);
    }

    public UsageCPAStatistics getStats() {
        return this.statistics;
    }

    public LogManager getLogger() {
        return this.logger;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return UsageState.createInitialState(this.getWrappedCpa().getInitialState(pNode, pPartition));
    }

    @Override
    public void setPartitioning(BlockPartitioning pPartitioning) {
        ConfigurableProgramAnalysis cpa = this.getWrappedCpa();
        assert (cpa instanceof ConfigurableProgramAnalysisWithBAM);
        ((ConfigurableProgramAnalysisWithBAM)cpa).setPartitioning(pPartitioning);
    }
}

