/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.base.Function;
import java.io.PrintStream;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMMultipleCEXSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.lock.LockTransferRelation;
import org.sosy_lab.cpachecker.cpa.usage.ETVErrorTracePrinter;
import org.sosy_lab.cpachecker.cpa.usage.ErrorTracePrinter;
import org.sosy_lab.cpachecker.cpa.usage.KleverErrorTracePrinter;
import org.sosy_lab.cpachecker.cpa.usage.KleverErrorTracePrinterOld;
import org.sosy_lab.cpachecker.cpa.usage.UsageState;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.usage")
public class UsageCPAStatistics
implements Statistics {
    @Option(name="outputType", description="all variables should be printed to the one file or to the different", secure=true)
    private OutputFileType outputFileType = OutputFileType.KLEVER;
    @Option(name="printUnsafesIfUnknown", description="print found unsafes in case of unknown verdict", secure=true)
    private boolean printUnsafesInCaseOfUnknown = true;
    private final LogManager logger;
    private final Configuration config;
    private final LockTransferRelation lockTransfer;
    private ErrorTracePrinter errPrinter;
    private final CFA cfa;
    private BAMMultipleCEXSubgraphComputer computer;
    final StatTimer transferRelationTimer = new StatTimer("Time for transfer relation");
    final StatTimer usagePreparationTimer = new StatTimer("Time for usage transfer");
    final StatTimer innerAnalysisTimer = new StatTimer("Time for inner analyses");
    final StatTimer extractStatesTimer = new StatTimer("Time for state extraction");
    private final StatTimer printStatisticsTimer = new StatTimer("Time for printing statistics");
    private final StatTimer printUnsafesTimer = new StatTimer("Time for unsafes printing");

    public UsageCPAStatistics(Configuration pConfig, LogManager pLogger, CFA pCfa, LockTransferRelation lTransfer) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.lockTransfer = lTransfer;
        this.config = pConfig;
        this.cfa = pCfa;
        this.computer = null;
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(out);
        writer.put(this.transferRelationTimer).put(this.usagePreparationTimer).put(this.innerAnalysisTimer).put(this.extractStatesTimer);
        if (this.printUnsafesInCaseOfUnknown || result != CPAcheckerResult.Result.UNKNOWN) {
            this.printUnsafesTimer.start();
            try {
                switch (this.outputFileType) {
                    case KLEVER: {
                        this.errPrinter = new KleverErrorTracePrinter(this.config, this.computer, this.cfa, this.logger, this.lockTransfer);
                        break;
                    }
                    case KLEVER_OLD: {
                        this.errPrinter = new KleverErrorTracePrinterOld(this.config, this.computer, this.cfa, this.logger, this.lockTransfer);
                        break;
                    }
                    case ETV: {
                        this.errPrinter = new ETVErrorTracePrinter(this.config, this.computer, this.cfa, this.logger, this.lockTransfer);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown type " + this.outputFileType);
                    }
                }
                this.errPrinter.printErrorTraces(reached);
                this.errPrinter.printStatistics(writer);
            }
            catch (InvalidConfigurationException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Cannot create error trace printer");
            }
            this.printUnsafesTimer.stop();
        }
        this.printStatisticsTimer.start();
        UsageState.get(reached.getFirstState()).getStatistics().printStatistics(writer);
        writer.put(this.printUnsafesTimer);
        this.printStatisticsTimer.stop();
        writer.put(this.printStatisticsTimer);
    }

    public void setBAMCPA(BAMCPA pBamCpa) {
        this.computer = pBamCpa.createBAMMultipleSubgraphComputer((Function<ARGState, Integer>)((Function)ARGState::getStateId));
    }

    @Override
    public @Nullable String getName() {
        return "UsageCPAStatistics";
    }

    public static enum OutputFileType {
        ETV,
        KLEVER,
        KLEVER_OLD;

    }
}

