/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.lock.AbstractLockState;
import org.sosy_lab.cpachecker.cpa.lock.LockState;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleNode;
import org.sosy_lab.cpachecker.cpa.usage.CompatibleState;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsagePoint;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;

public final class UsageInfo
implements Comparable<UsageInfo> {
    private static final UsageInfo IRRELEVANT_USAGE = new UsageInfo();
    private final UsageCore core;
    private final ImmutableList<CompatibleState> compatibleStates;

    private UsageInfo() {
        this.core = null;
        this.compatibleStates = null;
    }

    private UsageInfo(@NonNull Access atype, @NonNull CFANode n, SingleIdentifier ident, ImmutableList<CompatibleState> pStates) {
        this(new UsageCore(atype, n, ident), pStates);
    }

    private UsageInfo(UsageCore pCore, ImmutableList<CompatibleState> pStates) {
        this.core = pCore;
        this.compatibleStates = pStates;
    }

    public static UsageInfo createUsageInfo(@NonNull Access atype, @NonNull AbstractState state, AbstractIdentifier ident) {
        FluentIterable states;
        if (ident instanceof SingleIdentifier && (states = AbstractStates.asIterable(state).filter(CompatibleState.class)).allMatch(s -> s.isRelevantFor((SingleIdentifier)ident))) {
            UsageInfo result = new UsageInfo(atype, AbstractStates.extractLocation(state), (SingleIdentifier)ident, (ImmutableList<CompatibleState>)states.transform(CompatibleState::prepareToStore).toList());
            return result;
        }
        return IRRELEVANT_USAGE;
    }

    public @NonNull CFANode getCFANode() {
        return this.core.node;
    }

    public @NonNull SingleIdentifier getId() {
        assert (this.core.id != null);
        return this.core.id;
    }

    public void setAsLooped() {
        this.core.isLooped = true;
    }

    public boolean isLooped() {
        return this.core.isLooped;
    }

    public boolean isRelevant() {
        return this != IRRELEVANT_USAGE;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.core.accessType, this.core.node, this.compatibleStates});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UsageInfo other = (UsageInfo)obj;
        return this.core.accessType == other.core.accessType && Objects.equals(this.core.node, other.core.node) && Objects.equals(this.compatibleStates, other.compatibleStates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.core.accessType);
        sb.append(" access to ");
        sb.append(this.core.id);
        AbstractLockState locks = this.getLockState();
        if (locks != null) {
            if (locks.getSize() == 0) {
                sb.append(" without locks");
            } else {
                sb.append(" with ");
                sb.append(locks);
            }
        }
        sb.append(", ");
        sb.append(this.core.node);
        return sb.toString();
    }

    public void setKeyState(AbstractState state) {
        this.core.keyState = state;
    }

    public void setRefinedPath(List<CFAEdge> p) {
        this.core.keyState = null;
        this.core.path = p;
    }

    public AbstractState getKeyState() {
        return this.core.keyState;
    }

    public List<CFAEdge> getPath() {
        return this.core.path;
    }

    @Override
    public int compareTo(UsageInfo pO) {
        int result;
        if (this == pO) {
            return 0;
        }
        Preconditions.checkArgument((this.compatibleStates.size() == pO.compatibleStates.size() ? 1 : 0) != 0, (Object)"Different compatible states in usages are not supported");
        UnmodifiableIterator iterator = this.compatibleStates.iterator();
        UnmodifiableIterator otherIterator = pO.compatibleStates.iterator();
        while (iterator.hasNext()) {
            CompatibleState currentState = (CompatibleState)iterator.next();
            CompatibleState otherState = (CompatibleState)otherIterator.next();
            Preconditions.checkArgument((currentState.getClass() == otherState.getClass() ? 1 : 0) != 0, (Object)"Different compatible states in usages are not supported");
            result = otherState.compareTo(currentState);
            if (result == 0) continue;
            return result;
        }
        result = this.core.node.compareTo(pO.core.node);
        if (result != 0) {
            return result;
        }
        result = this.core.accessType.compareTo(pO.core.accessType);
        if (result != 0) {
            return result;
        }
        if (this.core.id == null || pO.core.id != null) {
            // empty if block
        }
        return 0;
    }

    public UsageInfo copy() {
        return this.copy(this.compatibleStates);
    }

    private UsageInfo copy(ImmutableList<CompatibleState> newStates) {
        return new UsageInfo(this.core, newStates);
    }

    public UsageInfo expand(LockState expandedState) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (CompatibleState state : this.compatibleStates) {
            if (state instanceof AbstractLockState) {
                builder.add((Object)expandedState);
                continue;
            }
            builder.add((Object)state);
        }
        return this.copy((ImmutableList<CompatibleState>)builder.build());
    }

    public AbstractLockState getLockState() {
        for (CompatibleState state : this.compatibleStates) {
            if (!(state instanceof AbstractLockState)) continue;
            return (AbstractLockState)state;
        }
        return null;
    }

    public UsagePoint createUsagePoint() {
        ImmutableList nodes = Collections3.transformedImmutableListCopy(this.compatibleStates, CompatibleState::getCompatibleNode);
        return new UsagePoint((List<CompatibleNode>)nodes, this.core.accessType);
    }

    private static class UsageCore {
        private final CFANode node;
        private final Access accessType;
        private AbstractState keyState;
        private List<CFAEdge> path;
        private final SingleIdentifier id;
        private boolean isLooped;

        private UsageCore(@NonNull Access atype, @NonNull CFANode n, SingleIdentifier ident) {
            this.node = n;
            this.accessType = atype;
            this.keyState = null;
            this.isLooped = false;
            this.id = ident;
        }
    }

    public static enum Access {
        WRITE,
        READ;

    }
}

