/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.usage.UsagePrecision;
import org.sosy_lab.cpachecker.cpa.usage.UsageState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class UsageMergeOperator
implements MergeOperator {
    private final MergeOperator wrappedMerge;

    public UsageMergeOperator(MergeOperator wrapped) {
        this.wrappedMerge = wrapped;
    }

    @Override
    public AbstractState merge(AbstractState pState1, AbstractState pState2, Precision pPrecision) throws CPAException, InterruptedException {
        UsageState result;
        UsageState uState1 = (UsageState)pState1;
        UsageState uState2 = (UsageState)pState2;
        UsagePrecision prec = (UsagePrecision)pPrecision;
        AbstractState wrappedState1 = uState1.getWrappedState();
        AbstractState wrappedState2 = uState2.getWrappedState();
        AbstractState mergedState = this.wrappedMerge.merge(wrappedState1, wrappedState2, prec.getWrappedPrecision());
        if (uState1.isLessOrEqual(uState2)) {
            result = uState2.copy(mergedState);
        } else if (uState2.isLessOrEqual(uState1)) {
            result = uState1.copy(mergedState);
        } else {
            result = uState1.copy(mergedState);
            result.joinRecentUsagesFrom(uState2);
        }
        if (mergedState.equals(wrappedState2) && result.equals(uState2)) {
            return pState2;
        }
        return result;
    }
}

