/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AdjustablePrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.WrapperPrecision;
import org.sosy_lab.cpachecker.cpa.local.LocalState;
import org.sosy_lab.cpachecker.util.identifiers.GeneralIdentifier;

public final class UsagePrecision
implements WrapperPrecision,
AdjustablePrecision {
    private final Map<CFANode, Map<GeneralIdentifier, LocalState.DataType>> localStatistics;
    private final Precision wrappedPrecision;

    private UsagePrecision(Precision pWrappedPrecision, Map<CFANode, Map<GeneralIdentifier, LocalState.DataType>> pMap) {
        this.localStatistics = pMap;
        this.wrappedPrecision = pWrappedPrecision;
    }

    static UsagePrecision create(Precision pWrappedPrecision, Map<CFANode, Map<GeneralIdentifier, LocalState.DataType>> pMap) {
        return new UsagePrecision(pWrappedPrecision, (Map<CFANode, Map<GeneralIdentifier, LocalState.DataType>>)ImmutableMap.copyOf(pMap));
    }

    Map<GeneralIdentifier, LocalState.DataType> get(CFANode node) {
        return this.localStatistics.get(node);
    }

    public Precision getWrappedPrecision() {
        return this.wrappedPrecision;
    }

    public UsagePrecision copy(Precision pWrappedPrecision) {
        return new UsagePrecision(pWrappedPrecision, this.localStatistics);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.localStatistics);
        result = 31 * result + Objects.hashCode(this.wrappedPrecision);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UsagePrecision other = (UsagePrecision)obj;
        return Objects.equals(this.localStatistics, other.localStatistics) && Objects.equals(this.wrappedPrecision, other.wrappedPrecision);
    }

    public String toString() {
        return "Size = " + this.localStatistics.size() + ";" + this.wrappedPrecision;
    }

    public int getTotalRecords() {
        int sum = 0;
        for (Map<GeneralIdentifier, LocalState.DataType> val : this.localStatistics.values()) {
            sum += val.size();
        }
        return sum;
    }

    @Override
    public <T extends Precision> T retrieveWrappedPrecision(Class<T> pType) {
        if (pType.isAssignableFrom(this.getClass())) {
            return (T)((Precision)pType.cast(this));
        }
        if (pType.isAssignableFrom(this.wrappedPrecision.getClass())) {
            return (T)((Precision)pType.cast(this.wrappedPrecision));
        }
        if (this.wrappedPrecision instanceof WrapperPrecision) {
            return ((WrapperPrecision)this.wrappedPrecision).retrieveWrappedPrecision(pType);
        }
        return null;
    }

    @Override
    public Precision replaceWrappedPrecision(Precision pNewPrecision, Predicate<? super Precision> pReplaceType) {
        if (pReplaceType.apply((Object)this)) {
            return pNewPrecision;
        }
        if (pReplaceType.apply((Object)this.wrappedPrecision)) {
            return this.copy(pNewPrecision);
        }
        if (this.wrappedPrecision instanceof WrapperPrecision) {
            return this.copy(((WrapperPrecision)this.wrappedPrecision).replaceWrappedPrecision(pNewPrecision, pReplaceType));
        }
        return null;
    }

    @Override
    public Iterable<Precision> getWrappedPrecisions() {
        return Collections.singleton(this.wrappedPrecision);
    }

    @Override
    public AdjustablePrecision add(AdjustablePrecision pOtherPrecision) {
        return this.adjust(pOtherPrecision, (a, b) -> a.add((AdjustablePrecision)b));
    }

    @Override
    public AdjustablePrecision subtract(AdjustablePrecision pOtherPrecision) {
        return this.adjust(pOtherPrecision, (a, b) -> a.subtract((AdjustablePrecision)b));
    }

    private AdjustablePrecision adjust(AdjustablePrecision pOtherPrecision, BiFunction<AdjustablePrecision, AdjustablePrecision, AdjustablePrecision> adjustFunction) {
        AdjustablePrecision wrappedOtherPrecision;
        AdjustablePrecision thisWrappedPrecision = (AdjustablePrecision)this.wrappedPrecision;
        if (pOtherPrecision instanceof UsagePrecision) {
            UsagePrecision otherPrecision = (UsagePrecision)pOtherPrecision;
            wrappedOtherPrecision = (AdjustablePrecision)otherPrecision.wrappedPrecision;
            assert (this.localStatistics.equals(otherPrecision.localStatistics));
        } else {
            wrappedOtherPrecision = pOtherPrecision;
        }
        AdjustablePrecision newWrappedPrecision = adjustFunction.apply(thisWrappedPrecision, wrappedOtherPrecision);
        return this.copy(newWrappedPrecision);
    }

    @Override
    public boolean isEmpty() {
        return ((AdjustablePrecision)this.wrappedPrecision).isEmpty();
    }
}

