/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.defaults.SimpleTargetInformation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.usage.UsageState;
import org.sosy_lab.cpachecker.cpa.usage.storage.UnsafeDetector;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageConfiguration;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageContainer;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class UsageReachedSet
extends PartitionedReachedSet {
    private static final ImmutableSet<Targetable.TargetInformation> RACE_PROPERTY = SimpleTargetInformation.singleton("Race condition");
    private final UsageConfiguration config;
    private final LogManager logger;
    private final UnsafeDetector unsafeDetector;
    private UsageContainer container = null;

    public UsageReachedSet(ConfigurableProgramAnalysis pCpa, Waitlist.WaitlistFactory waitlistFactory, UsageConfiguration pConfig, LogManager pLogger) {
        super(pCpa, waitlistFactory);
        this.config = pConfig;
        this.logger = pLogger;
        this.unsafeDetector = new UnsafeDetector(pConfig);
    }

    @Override
    public void remove(AbstractState pState) {
        super.remove(pState);
        if (this.container != null) {
            UsageState ustate = UsageState.get(pState);
            this.container.removeState(ustate);
        }
    }

    @Override
    public void add(AbstractState pState, Precision pPrecision) {
        super.add(pState, pPrecision);
        UsageState USstate = AbstractStates.extractStateByType(pState, UsageState.class);
        USstate.saveUnsafesInContainerIfNecessary(pState);
    }

    @Override
    public void clear() {
        if (this.container != null) {
            this.container.resetUnrefinedUnsafes();
        }
        super.clear();
    }

    @Override
    public boolean wasTargetReached() {
        return this.getUsageContainer().getTotalUnsafeSize() > 0;
    }

    public Set<Targetable.TargetInformation> getTargetInformation() {
        if (this.wasTargetReached()) {
            return RACE_PROPERTY;
        }
        return ImmutableSet.of();
    }

    public UsageContainer getUsageContainer() {
        if (this.container == null) {
            this.container = new UsageContainer(this.config, this.logger, this.unsafeDetector);
        }
        UsageState lastState = UsageState.get(this.getLastState());
        this.container.initContainerIfNecessary(lastState.getFunctionContainer());
        return this.container;
    }
}

