/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.usage.UsagePrecision;
import org.sosy_lab.cpachecker.cpa.usage.UsageState;

public class UsageReducer
implements Reducer {
    private final Reducer wrappedReducer;

    public UsageReducer(Reducer pWrappedReducer) {
        this.wrappedReducer = pWrappedReducer;
    }

    @Override
    public AbstractState getVariableReducedState(AbstractState pExpandedElement, Block pContext, CFANode pLocation) throws InterruptedException {
        UsageState funElement = (UsageState)pExpandedElement;
        AbstractState red = this.wrappedReducer.getVariableReducedState(funElement.getWrappedState(), pContext, pLocation);
        return funElement.reduce(red);
    }

    @Override
    public AbstractState getVariableExpandedState(AbstractState pRootElement, Block pReducedContext, AbstractState pReducedElement) throws InterruptedException {
        UsageState funRootState = (UsageState)pRootElement;
        UsageState funReducedState = (UsageState)pReducedElement;
        AbstractState exp = this.wrappedReducer.getVariableExpandedState(funRootState.getWrappedState(), pReducedContext, funReducedState.getWrappedState());
        UsageState result = funRootState.copy(exp);
        result.joinContainerFrom(funReducedState);
        result.asExitable();
        return result;
    }

    @Override
    public Object getHashCodeForState(AbstractState pElementKey, Precision pPrecisionKey) {
        UsageState funElement = (UsageState)pElementKey;
        UsagePrecision precision = (UsagePrecision)pPrecisionKey;
        return this.wrappedReducer.getHashCodeForState(funElement.getWrappedState(), precision.getWrappedPrecision());
    }

    @Override
    public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
        UsagePrecision newPrecision = ((UsagePrecision)pPrecision).copy(this.wrappedReducer.getVariableReducedPrecision(((UsagePrecision)pPrecision).getWrappedPrecision(), pContext));
        return newPrecision;
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision rootPrecision, Block rootContext, Precision reducedPrecision) {
        UsagePrecision redPrecision = (UsagePrecision)reducedPrecision;
        UsagePrecision newPrecision = ((UsagePrecision)rootPrecision).copy(this.wrappedReducer.getVariableExpandedPrecision(((UsagePrecision)rootPrecision).getWrappedPrecision(), rootContext, redPrecision.getWrappedPrecision()));
        return newPrecision;
    }

    @Override
    public int measurePrecisionDifference(Precision pPrecision, Precision pOtherPrecision) {
        UsagePrecision first = (UsagePrecision)pPrecision;
        UsagePrecision second = (UsagePrecision)pOtherPrecision;
        int wrapperDifference = this.wrappedReducer.measurePrecisionDifference(first.getWrappedPrecision(), second.getWrappedPrecision());
        return wrapperDifference + Math.abs(first.getTotalRecords() - second.getTotalRecords());
    }

    @Override
    public AbstractState rebuildStateAfterFunctionCall(AbstractState pRootState, AbstractState pEntryState, AbstractState pExpandedState, FunctionExitNode pExitLocation) {
        return pExpandedState;
    }
}

