/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.core.defaults.AbstractSerializableSingleWrapperState;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.lock.LockState;
import org.sosy_lab.cpachecker.cpa.lock.effects.LockEffect;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.storage.FunctionContainer;
import org.sosy_lab.cpachecker.cpa.usage.storage.TemporaryUsageStorage;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.Identifiers;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public final class UsageState
extends AbstractSerializableSingleWrapperState
implements LatticeAbstractState<UsageState> {
    private static final long serialVersionUID = -898577877284268426L;
    private TemporaryUsageStorage recentUsages;
    private final FunctionContainer functionContainer;
    private final transient StateStatistics stats;
    private boolean isExitState;
    private boolean isStorageDumped;
    private transient PersistentSortedMap<AbstractIdentifier, AbstractIdentifier> variableBindingRelation;

    private UsageState(AbstractState pWrappedElement, PersistentSortedMap<AbstractIdentifier, AbstractIdentifier> pVarBind, TemporaryUsageStorage pRecentUsages, FunctionContainer pFuncContainer, StateStatistics pStats, boolean exit) {
        super(pWrappedElement);
        this.variableBindingRelation = pVarBind;
        this.recentUsages = pRecentUsages;
        this.functionContainer = pFuncContainer;
        this.stats = pStats;
        this.isExitState = exit;
        this.isStorageDumped = false;
    }

    public static UsageState createInitialState(AbstractState pWrappedElement) {
        FunctionContainer initialContainer = FunctionContainer.createInitialContainer();
        return new UsageState(pWrappedElement, (PersistentSortedMap<AbstractIdentifier, AbstractIdentifier>)PathCopyingPersistentTreeMap.of(), new TemporaryUsageStorage(), initialContainer, new StateStatistics(initialContainer.getStatistics()), false);
    }

    private UsageState(AbstractState pWrappedElement, UsageState state) {
        this(pWrappedElement, state.variableBindingRelation, state.recentUsages, state.functionContainer, state.stats, state.isExitState);
    }

    public boolean containsLinks(AbstractIdentifier id) {
        return FluentIterable.from(Identifiers.getDereferencedIdentifiers(id)).anyMatch(arg_0 -> this.variableBindingRelation.containsKey(arg_0));
    }

    public void put(AbstractIdentifier id1, AbstractIdentifier id2) {
        if (!id1.equals(id2)) {
            this.variableBindingRelation = this.variableBindingRelation.putAndCopy((Object)id1, (Object)id2);
        }
    }

    public AbstractIdentifier getLinksIfNecessary(AbstractIdentifier id) {
        if (!this.containsLinks(id)) {
            return id;
        }
        Optional<AbstractIdentifier> linkedId = Identifiers.getDereferencedIdentifiers(id).stream().filter(arg_0 -> this.variableBindingRelation.containsKey(arg_0)).findFirst();
        if (linkedId.isPresent()) {
            AbstractIdentifier pointsFrom = linkedId.orElseThrow();
            int delta = id.getDereference() - pointsFrom.getDereference();
            AbstractIdentifier initialId = (AbstractIdentifier)this.variableBindingRelation.get((Object)pointsFrom);
            AbstractIdentifier pointsTo = initialId.cloneWithDereference(initialId.getDereference() + delta);
            if (this.containsLinks(pointsTo)) {
                pointsTo = this.getLinksIfNecessary(pointsTo);
            }
            return pointsTo;
        }
        return null;
    }

    public UsageState copy() {
        return this.copy(this.getWrappedState());
    }

    public UsageState copy(AbstractState pWrappedState) {
        UsageState result = new UsageState(pWrappedState, this);
        if (this.isStorageDumped) {
            result.recentUsages = new TemporaryUsageStorage();
            this.functionContainer.registerTemporaryContainer(result.recentUsages);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.variableBindingRelation);
        result = 31 * result + Objects.hashCode(this.recentUsages);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UsageState other = (UsageState)obj;
        return Objects.equals(this.variableBindingRelation, other.variableBindingRelation) && Objects.equals(this.recentUsages, other.recentUsages) && this.getWrappedState().equals(other.getWrappedState());
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        Joiner.on((String)", ").withKeyValueSeparator("->").appendTo(str, this.variableBindingRelation);
        str.append("]\n");
        str.append(this.getWrappedState());
        return str.toString();
    }

    @Override
    public boolean isLessOrEqual(UsageState other) {
        this.stats.lessTimer.start();
        if (this.variableBindingRelation.size() > other.variableBindingRelation.size()) {
            this.stats.lessTimer.stop();
            return false;
        }
        if (FluentIterable.from((Iterable)this.variableBindingRelation.keySet()).anyMatch(Predicates.not(arg_0 -> other.variableBindingRelation.containsKey(arg_0)))) {
            this.stats.lessTimer.stop();
            return false;
        }
        if (!this.recentUsages.isSubsetOf(other.recentUsages)) {
            this.stats.lessTimer.stop();
            return false;
        }
        this.stats.lessTimer.stop();
        return true;
    }

    public void addUsage(SingleIdentifier id, UsageInfo usage) {
        this.recentUsages.add(id, usage);
    }

    public void joinContainerFrom(UsageState reducedState) {
        this.stats.joinTimer.start();
        this.functionContainer.join(reducedState.functionContainer);
        this.stats.joinTimer.stop();
        reducedState.functionContainer.clearStorages();
    }

    public void joinRecentUsagesFrom(UsageState pState) {
        this.stats.joinTimer.start();
        this.recentUsages.copyUsagesFrom(pState.recentUsages);
        this.stats.joinTimer.stop();
        for (Map.Entry entry : pState.variableBindingRelation.entrySet()) {
            this.variableBindingRelation = this.variableBindingRelation.putAndCopy((Object)((AbstractIdentifier)entry.getKey()), (Object)((AbstractIdentifier)entry.getValue()));
        }
    }

    public UsageState reduce(AbstractState wrappedState) {
        LockState rootLockState = AbstractStates.extractStateByType(this, LockState.class);
        LockState reducedLockState = AbstractStates.extractStateByType(wrappedState, LockState.class);
        Multiset<LockEffect> difference = rootLockState == null || reducedLockState == null ? HashMultiset.create() : reducedLockState.getDifference(rootLockState);
        return new UsageState(wrappedState, (PersistentSortedMap<AbstractIdentifier, AbstractIdentifier>)PathCopyingPersistentTreeMap.of(), this.recentUsages.copy(), this.functionContainer.clone(difference), this.stats, this.isExitState);
    }

    public void saveUnsafesInContainerIfNecessary(AbstractState abstractState) {
        ARGState argState = AbstractStates.extractStateByType(abstractState, ARGState.class);
        PredicateAbstractState state = AbstractStates.extractStateByType(argState, PredicateAbstractState.class);
        if (state == null || !state.getAbstractionFormula().isFalse() && state.isAbstractionState()) {
            this.recentUsages.setKeyState(argState);
            this.stats.addRecentUsagesTimer.start();
            this.functionContainer.join(this.recentUsages);
            this.stats.addRecentUsagesTimer.stop();
            this.isStorageDumped = true;
        }
    }

    public FunctionContainer getFunctionContainer() {
        return this.functionContainer;
    }

    public void asExitable() {
        this.isExitState = true;
    }

    public StateStatistics getStatistics() {
        return this.stats;
    }

    public static UsageState get(AbstractState state) {
        return AbstractStates.extractStateByType(state, UsageState.class);
    }

    @Override
    public UsageState join(UsageState pOther) {
        throw new UnsupportedOperationException("Join is not supported for usage states, use merge operator");
    }

    Object readResolve() {
        return new UsageState(this.getWrappedState(), (PersistentSortedMap<AbstractIdentifier, AbstractIdentifier>)PathCopyingPersistentTreeMap.of(), this.recentUsages, this.functionContainer, new StateStatistics(this.functionContainer.getStatistics()), this.isExitState);
    }

    public static class StateStatistics {
        private StatTimer joinTimer = new StatTimer("Time for joining");
        private StatTimer lessTimer = new StatTimer("Time for cover check");
        private StatTimer addRecentUsagesTimer = new StatTimer("Time for adding recent usages");
        private final FunctionContainer.StorageStatistics storageStats;

        public StateStatistics(FunctionContainer.StorageStatistics stats) {
            this.storageStats = Objects.requireNonNull(stats);
        }

        public void printStatistics(StatisticsWriter out) {
            out.spacer().put(this.joinTimer).put(this.addRecentUsagesTimer).put(this.lessTimer);
            this.storageStats.printStatistics(out);
        }
    }
}

