/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.WrapperTransferRelation;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackTransferRelation;
import org.sosy_lab.cpachecker.cpa.local.LocalState;
import org.sosy_lab.cpachecker.cpa.usage.BinderFunctionInfo;
import org.sosy_lab.cpachecker.cpa.usage.ExpressionHandler;
import org.sosy_lab.cpachecker.cpa.usage.UsageCPAStatistics;
import org.sosy_lab.cpachecker.cpa.usage.UsageInfo;
import org.sosy_lab.cpachecker.cpa.usage.UsagePrecision;
import org.sosy_lab.cpachecker.cpa.usage.UsageState;
import org.sosy_lab.cpachecker.cpa.usage.VariableSkipper;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.HandleCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.GeneralIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.LocalVariableIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.StructureIdentifier;

@Options(prefix="cpa.usage")
public class UsageTransferRelation
extends AbstractSingleWrapperTransferRelation {
    private final UsageCPAStatistics statistics;
    @Option(description="functions, which we don't analize", secure=true)
    private Set<String> skippedfunctions = ImmutableSet.of();
    @Option(description="functions, which are used to bind variables (like list elements are binded to list variable)", secure=true)
    private Set<String> binderFunctions = ImmutableSet.of();
    @Option(description="functions, which are marked as write access", secure=true)
    private Set<String> writeAccessFunctions = ImmutableSet.of();
    @Option(name="abortfunctions", description="functions, which stops analysis", secure=true)
    private Set<String> abortFunctions = ImmutableSet.of();
    private final CallstackTransferRelation callstackTransfer;
    private final VariableSkipper varSkipper;
    private final Map<String, BinderFunctionInfo> binderFunctionInfo;
    private final LogManager logger;
    private UsageState newState;
    private UsagePrecision precision;

    public UsageTransferRelation(TransferRelation pWrappedTransfer, Configuration config, LogManager pLogger, UsageCPAStatistics s) throws InvalidConfigurationException {
        super(pWrappedTransfer);
        config.inject((Object)this, UsageTransferRelation.class);
        this.callstackTransfer = ((WrapperTransferRelation)this.transferRelation).retrieveWrappedTransferRelation(CallstackTransferRelation.class);
        this.statistics = s;
        this.logger = pLogger;
        ImmutableMap.Builder binderFunctionInfoBuilder = ImmutableMap.builder();
        FluentIterable.from(this.binderFunctions).forEach(name -> binderFunctionInfoBuilder.put(name, (Object)new BinderFunctionInfo((String)name, config, this.logger)));
        BinderFunctionInfo dummy = new BinderFunctionInfo();
        FluentIterable.from(this.writeAccessFunctions).forEach(name -> binderFunctionInfoBuilder.put(name, (Object)dummy));
        this.binderFunctionInfo = binderFunctionInfoBuilder.buildOrThrow();
        this.skippedfunctions = Sets.union(this.skippedfunctions, this.binderFunctions);
        this.varSkipper = new VariableSkipper(config);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState pElement, Precision pPrecision) throws InterruptedException, CPATransferException {
        assert (pPrecision instanceof UsagePrecision);
        CFANode node = AbstractStates.extractLocation(pElement);
        ArrayList<? extends AbstractState> results = new ArrayList<AbstractState>(node.getNumLeavingEdges());
        for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
            results.addAll(this.getAbstractSuccessorsForEdge(pElement, pPrecision, edge));
        }
        return results;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        this.statistics.transferRelationTimer.start();
        ArrayList<UsageState> result = new ArrayList<UsageState>();
        UsageState oldState = (UsageState)pState;
        CFAEdge currentEdge = this.changeIfNeccessary(pCfaEdge);
        AbstractState oldWrappedState = oldState.getWrappedState();
        this.newState = oldState.copy();
        this.precision = (UsagePrecision)pPrecision;
        this.statistics.usagePreparationTimer.start();
        this.handleEdge(currentEdge);
        this.statistics.usagePreparationTimer.stop();
        this.statistics.innerAnalysisTimer.start();
        Collection<? extends AbstractState> newWrappedStates = this.transferRelation.getAbstractSuccessorsForEdge(oldWrappedState, this.precision.getWrappedPrecision(), currentEdge);
        this.statistics.innerAnalysisTimer.stop();
        for (AbstractState abstractState : newWrappedStates) {
            result.add(this.newState.copy(abstractState));
        }
        if (currentEdge != pCfaEdge) {
            this.callstackTransfer.disableRecursiveContext();
        }
        this.newState = null;
        this.precision = null;
        this.statistics.transferRelationTimer.stop();
        return result;
    }

    private CFAEdge changeIfNeccessary(CFAEdge pCfaEdge) {
        String functionName;
        if (pCfaEdge.getEdgeType() == CFAEdgeType.FunctionCallEdge && this.skippedfunctions.contains(functionName = pCfaEdge.getSuccessor().getFunctionName())) {
            FunctionSummaryEdge newEdge = ((FunctionCallEdge)pCfaEdge).getSummaryEdge();
            Preconditions.checkNotNull((Object)newEdge, (Object)("Cannot find summary edge for " + pCfaEdge + " as skipped function"));
            this.logger.log(Level.FINEST, new Object[]{pCfaEdge.getSuccessor().getFunctionName() + " is skipped"});
            this.callstackTransfer.enableRecursiveContext();
            return newEdge;
        }
        return pCfaEdge;
    }

    private void handleEdge(CFAEdge pCfaEdge) throws CPATransferException {
        switch (pCfaEdge.getEdgeType()) {
            case DeclarationEdge: {
                CDeclarationEdge declEdge = (CDeclarationEdge)pCfaEdge;
                this.handleDeclaration(declEdge);
                break;
            }
            case StatementEdge: {
                CStatementEdge statementEdge = (CStatementEdge)pCfaEdge;
                this.handleStatement(statementEdge.getStatement());
                break;
            }
            case AssumeEdge: {
                this.visitStatement(((CAssumeEdge)pCfaEdge).getExpression(), UsageInfo.Access.READ);
                break;
            }
            case FunctionCallEdge: {
                this.handleFunctionCall((CFunctionCallEdge)pCfaEdge);
                break;
            }
            case FunctionReturnEdge: 
            case ReturnStatementEdge: 
            case BlankEdge: 
            case CallToReturnEdge: {
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(pCfaEdge);
            }
        }
    }

    private void handleFunctionCall(CFunctionCallEdge edge) throws HandleCodeException {
        CFunctionCall statement = edge.getFunctionCall();
        if (statement instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallExpression right = ((CFunctionCallAssignmentStatement)statement).getRightHandSide();
            CLeftHandSide variable = ((CFunctionCallAssignmentStatement)statement).getLeftHandSide();
            this.visitStatement(variable, UsageInfo.Access.WRITE);
            this.handleFunctionCallExpression(variable, right);
        } else if (statement instanceof CFunctionCallStatement) {
            this.handleFunctionCallExpression(null, ((CFunctionCallStatement)statement).getFunctionCallExpression());
        } else {
            throw new HandleCodeException("No function found");
        }
    }

    private void handleDeclaration(CDeclarationEdge declEdge) {
        if (declEdge.getDeclaration().getClass() != CVariableDeclaration.class) {
            return;
        }
        CVariableDeclaration decl = (CVariableDeclaration)declEdge.getDeclaration();
        if (decl.isGlobal()) {
            return;
        }
        CInitializer init = decl.getInitializer();
        if (init == null) {
            return;
        }
        if (init instanceof CInitializerExpression) {
            CExpression initExpression = ((CInitializerExpression)init).getExpression();
            this.visitStatement(initExpression, UsageInfo.Access.READ);
        }
    }

    private void handleFunctionCallExpression(CExpression left, CFunctionCallExpression fcExpression) {
        String functionCallName = fcExpression.getFunctionNameExpression().toASTString();
        if (this.binderFunctionInfo.containsKey(functionCallName)) {
            BinderFunctionInfo currentInfo = this.binderFunctionInfo.get(functionCallName);
            List<CExpression> params = fcExpression.getParameterExpressions();
            this.linkVariables(left, params, currentInfo);
            for (int i = 0; i < params.size(); ++i) {
                AbstractIdentifier id = currentInfo.createParamenterIdentifier(params.get(i), i, this.getCurrentFunction());
                id = this.newState.getLinksIfNecessary(id);
                UsageInfo usage = UsageInfo.createUsageInfo(currentInfo.getBindedAccess(i), this.newState, id);
                this.addUsageIfNeccessary(usage);
            }
        } else if (this.abortFunctions.contains(functionCallName)) {
            this.newState.asExitable();
        } else {
            fcExpression.getParameterExpressions().forEach(p -> this.visitStatement((CExpression)p, UsageInfo.Access.READ));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleStatement(CStatement pStatement) throws HandleCodeException {
        if (pStatement instanceof CAssignment) {
            CAssignment assignment = (CAssignment)pStatement;
            CLeftHandSide left = assignment.getLeftHandSide();
            CRightHandSide right = assignment.getRightHandSide();
            this.visitStatement(left, UsageInfo.Access.WRITE);
            if (right instanceof CExpression) {
                this.visitStatement((CExpression)right, UsageInfo.Access.READ);
                return;
            } else {
                if (!(right instanceof CFunctionCallExpression)) throw new HandleCodeException("Unrecognised type of right side of assignment: " + assignment.toASTString());
                this.handleFunctionCallExpression(left, (CFunctionCallExpression)right);
            }
            return;
        } else if (pStatement instanceof CFunctionCallStatement) {
            this.handleFunctionCallExpression(null, ((CFunctionCallStatement)pStatement).getFunctionCallExpression());
            return;
        } else {
            if (!(pStatement instanceof CExpressionStatement)) throw new HandleCodeException("Unrecognized statement: " + pStatement.toASTString());
            this.visitStatement(((CExpressionStatement)pStatement).getExpression(), UsageInfo.Access.WRITE);
        }
    }

    private void linkVariables(CExpression left, List<CExpression> params, BinderFunctionInfo bInfo) {
        if (bInfo.shouldBeLinked()) {
            AbstractIdentifier idIn = bInfo.constructFirstIdentifier(left, params, this.getCurrentFunction());
            AbstractIdentifier idFrom = bInfo.constructSecondIdentifier(left, params, this.getCurrentFunction());
            if (idIn == null || idFrom == null) {
                return;
            }
            if (this.newState.containsLinks(idFrom)) {
                idFrom = this.newState.getLinksIfNecessary(idFrom);
            }
            this.logger.log(Level.FINEST, new Object[]{"Link " + idIn + " and " + idFrom});
            this.newState.put(idIn, idFrom);
        }
    }

    private void visitStatement(CExpression expression, UsageInfo.Access access) {
        ExpressionHandler handler = new ExpressionHandler(access, this.getCurrentFunction());
        expression.accept(handler);
        for (Pair<AbstractIdentifier, UsageInfo.Access> pair : handler.getProcessedExpressions()) {
            AbstractIdentifier id = pair.getFirst();
            id = this.newState.getLinksIfNecessary(id);
            UsageInfo usage = UsageInfo.createUsageInfo(pair.getSecond(), this.newState, id);
            this.addUsageIfNeccessary(usage);
        }
    }

    private void addUsageIfNeccessary(UsageInfo usage) {
        if (!usage.isRelevant()) {
            return;
        }
        SingleIdentifier singleId = usage.getId();
        CFANode node = AbstractStates.extractLocation(this.newState);
        Map<GeneralIdentifier, LocalState.DataType> localInfo = this.precision.get(node);
        if (localInfo != null) {
            GeneralIdentifier gId = singleId.getGeneralId();
            if (localInfo.get(gId) == LocalState.DataType.LOCAL) {
                this.logger.log(Level.FINER, new Object[]{singleId + " is considered to be local, so it wasn't add to statistics"});
                return;
            }
            FluentIterable composedIds = FluentIterable.from(singleId.getComposedIdentifiers()).filter(SingleIdentifier.class).transform(SingleIdentifier::getGeneralId);
            boolean isLocal = composedIds.anyMatch(i -> localInfo.get(i) == LocalState.DataType.LOCAL);
            boolean isGlobal = composedIds.anyMatch(i -> localInfo.get(i) == LocalState.DataType.GLOBAL);
            if (isLocal && !isGlobal) {
                this.logger.log(Level.FINER, new Object[]{singleId + " is supposed to be local, so it wasn't add to statistics"});
                return;
            }
        }
        if (this.varSkipper.shouldBeSkipped(singleId, usage.getCFANode().getFunctionName())) {
            return;
        }
        if (singleId instanceof LocalVariableIdentifier && singleId.getDereference() <= 0) {
            return;
        }
        if (singleId instanceof StructureIdentifier && !singleId.isGlobal() && !singleId.isDereferenced()) {
            return;
        }
        if (singleId instanceof StructureIdentifier) {
            singleId = ((StructureIdentifier)singleId).toStructureFieldIdentifier();
        }
        this.logger.log(Level.FINER, new Object[]{"Add " + usage + " to unsafe statistics"});
        this.newState.addUsage(singleId, usage);
    }

    private String getCurrentFunction() {
        return AbstractStates.extractStateByType(this.newState, CallstackState.class).getCurrentFunction();
    }
}

