/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage;

import com.google.common.base.CharMatcher;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.identifiers.AbstractIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.SingleIdentifier;
import org.sosy_lab.cpachecker.util.identifiers.StructureIdentifier;

@Options(prefix="cpa.usage.skippedvariables")
public class VariableSkipper {
    @Option(description="variables, which will be filtered by its name", secure=true)
    private Set<String> byName = ImmutableSet.of();
    @Option(description="variables, which will be filtered by its name prefix", secure=true)
    private Set<String> byNamePrefix = ImmutableSet.of();
    @Option(description="variables, which will be filtered by its type", secure=true)
    private Set<String> byType = ImmutableSet.of();
    @Option(description="variables, which will be filtered by function location", secure=true)
    private Set<String> byFunction = ImmutableSet.of();
    @Option(description="variables, which will be filtered by function prefix", secure=true)
    private Set<String> byFunctionPrefix = ImmutableSet.of();

    public VariableSkipper(Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
    }

    public boolean shouldBeSkipped(AbstractIdentifier id, String functionName) {
        if (id instanceof SingleIdentifier) {
            SingleIdentifier singleId = (SingleIdentifier)id;
            if (this.checkId(singleId)) {
                return true;
            }
            if (singleId instanceof StructureIdentifier) {
                AbstractIdentifier owner = singleId;
                while (owner instanceof StructureIdentifier) {
                    owner = ((StructureIdentifier)owner).getOwner();
                }
                if (owner instanceof SingleIdentifier && this.checkId((SingleIdentifier)owner)) {
                    return true;
                }
            }
        }
        if (this.byFunction.contains(functionName)) {
            return true;
        }
        return FluentIterable.from(this.byFunctionPrefix).anyMatch(functionName::startsWith);
    }

    private boolean checkId(SingleIdentifier singleId) {
        String varName = singleId.getName();
        if (this.byName.contains(varName)) {
            return true;
        }
        if (FluentIterable.from(this.byNamePrefix).anyMatch(varName::startsWith)) {
            return true;
        }
        if (!this.byType.isEmpty()) {
            CType idType = singleId.getType();
            if (idType instanceof CArrayType) {
                idType = ((CArrayType)idType).getType();
            }
            String typeString = idType.toString();
            typeString = CharMatcher.anyOf((CharSequence)"()").removeFrom((CharSequence)typeString);
            if (this.byType.contains(typeString)) {
                return true;
            }
        }
        return false;
    }
}

