/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.usage.refinement;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ConfigurableRefinementBlock;
import org.sosy_lab.cpachecker.cpa.usage.refinement.ExtendedARGPath;
import org.sosy_lab.cpachecker.cpa.usage.refinement.GenericFilter;
import org.sosy_lab.cpachecker.util.Pair;

@Options(prefix="cpa.usage")
public class CallstackFilter
extends GenericFilter<String> {
    @Option(name="notSelfParallelFunctions", description="The functions, which cannot be executed in parallel with themselves", secure=true)
    protected Set<String> notSelfParallelFunctions = new HashSet<String>();
    @Option(name="singleThreadFunctions", description="The functions, which are executed in one thread", secure=true)
    protected Set<String> singleThreadFunctions = new HashSet<String>();

    public CallstackFilter(ConfigurableRefinementBlock<Pair<ExtendedARGPath, ExtendedARGPath>> pWrapper, Configuration pConfig) throws InvalidConfigurationException {
        super(pWrapper, pConfig);
        pConfig.inject((Object)this, CallstackFilter.class);
    }

    @Override
    protected Boolean filter(String pFirstPathCore, String pSecondPathCore) {
        if (this.notSelfParallelFunctions.contains(pFirstPathCore) && pFirstPathCore.equals(pSecondPathCore)) {
            return false;
        }
        if (this.singleThreadFunctions.contains(pFirstPathCore) || this.singleThreadFunctions.contains(pSecondPathCore)) {
            return false;
        }
        return true;
    }

    @Override
    protected String getPathCore(ExtendedARGPath pPath) {
        ImmutableList firstCalls = FluentIterable.from(pPath.getStateSet()).filter(this.isFirstCall).toList();
        ImmutableList callerFunctions = Collections3.transformedImmutableListCopy((Collection)firstCalls, (Function)this.getFunctionName);
        if (callerFunctions.size() >= 1) {
            return (String)callerFunctions.get(callerFunctions.size() - 1);
        }
        return null;
    }
}

